import AbstractGraphicView from "../../base/AbstractGraphicView";
import ContainerPanel from "../../../common/component/container/panel/ContainerPanel";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import H5VFlexPanel from "../../../common/component/container/panel/H5VFlexPanel";
import AbstractPropertyDefine from "../../plugin/property/base/AbstractPropertyDefine";
import Paras from "../../../common/struct/Paras";
import BorderPanel from "../../../common/component/container/panel/BorderPanel";
import JComponent from "../../../common/component/JComponent";
import ITagNode from "../../../common/xml/node/ITagNode";
import DataMigrationOptStateDelegate from "../state/DataMigrationOptStateDelegate";
import DataMigrationPropertyDefine from "../base/DataMigrationPropertyDefine";
import DataMigrationConstants from "../base/DataMigrationConstants";
import SourceTableView from "./element/SourceTableView";
import TargetTableView from "./element/TargetTableView";
import SizeInfo from "../../../common/struct/SizeInfo";
import BaseConstants from "../../base/BaseConstants";
import {FieldView} from "./FieldView";
import ActionNames from "../../../common/event/ActionNames";
import DomUtil from "../../../common/dom/DomUtil";
import Custom from "../../../common/component/control/Custom";
import DomElement from "../../../common/dom/element/DomElement";
import GDataMigration from "../../plugin/graphic/snap/GDataMigration";
import IGTable from "../../../common/ui/graphic/IGTable";
import ArrayList from "../../../common/struct/ArrayList";
import DivElement from "../../../common/dom/element/DivElement";
import AbstractLink from "./element/link/AbstractLink";
import SequenceFlow from "./element/link/SequenceFlow";
import NewLinkCmd from "../cmd/NewLinkCmd";
import CmdQueue from "../../../common/cmd/CmdQueue";
import AddSourceFieldCmd from "../cmd/AddSourceFieldCmd";
import AddTargetFieldCmd from "../cmd/AddTargetFieldCmd";
import DataMigrationNodeUtil from "../util/DataMigrationNodeUtil";
import MoveFieldCmd from "../cmd/MoveFieldCmd";
import MoveTableCmd from "../cmd/MoveTableCmd";
import InputCellCmd from "../cmd/InputCellCmd";
import FieldDelete from "../cmd/FieldDelete";
import DATAMIGRATION from "../base/DATAMIGRATION";
import DeleteLinkCmd from "../cmd/DeleteLinkCmd";
import AddSourceFieldsCmd from "../cmd/AddSourceFieldsCmd";
import IWorkSpace from "../../../common/workspace/IWorkSpace";
import AddTargetFieldsCmd from "../cmd/AddTargetFieldsCmd";
import DataMigrationUtil from "../base/DataMigrationUtil";
import {CommonConstant} from "../../datamap/base/CommonConstant";
import Button from "../../../common/component/control/Button";
import Events from "../../../common/event/Events";
import OperationDispatcher from "../../../common/operation/OperationDispatcher";


export default class DataMigrationGraphicView extends AbstractGraphicView<DataMigrationOptStateDelegate> {
    get sourceViews(): Map<string, SourceTableView> {
        return this._sourceViews;
    }

    get targetViews(): Map<string, TargetTableView> {
        return this._targetViews;
    }

    private paper: GDataMigration;

    public static TOOLBOX_WIDTH = 50;

    private xmlEntity!: IXmlEntity;

    private scrPoints: Map<string, DivElement>;
    private tarPoints: Map<string, DivElement>;

    private mapLinks: Map<String, AbstractLink>;

    private boardContainer: ContainerPanel;

    private board: ContainerPanel;

    private srcitems: Map<string, any>;
    private taritems: Map<string, any>;

    //锚点集合
    private pointLIst: Custom[] = [];

    //打印设计窗口(含尺码)
    private designView: BorderPanel;
    private selectFieldView?: FieldView;
    private selectFieldTagNode?: ITagNode;

    private sourceTableCollectionView: H5VFlexPanel;
    private selectViewName: string = "sourceColl";

    private targetTableCollectionView: H5VFlexPanel;
    private selectSourceView: SourceTableView | undefined;
    private selectTargetView: TargetTableView | undefined;

    private srcForeginObject: SVGForeignObjectElement | undefined;
    private tagForeginObject: SVGForeignObjectElement | undefined;
    private operationDispatcher?: OperationDispatcher;

    // 视图元素集合
    private sourceViewElements: SourceTableView[] = [];
    private targetViewElements: TargetTableView[] = [];
    private _sourceViews: Map<string, SourceTableView> = new Map<string, SourceTableView>()
    private _targetViews: Map<string, TargetTableView> = new Map<string, TargetTableView>()

    private extendSourceToTargetLinks: String[] = [];
    private linkDataMigrationButton?: Button;

    private path?: string;

    constructor() {
        super(0, 0, 64, 0);
        this.srcitems = new Map<string, string>()
        this.taritems = new Map<string, string>()
        this.scrPoints = new Map<string, DivElement>()
        this.tarPoints = new Map<string, DivElement>()
        this.mapLinks = new Map<string, AbstractLink>()
        this.boardContainer = new ContainerPanel();

        this.paper = new GDataMigration("100%", "100%");
        this.paper.attr({'preserveAspectRatio': "none meet"});
        this.paper.attr({'tabindex': 0});
        this.paper.addClass('datamigrationlink');
        var paperControl = new Custom(new DomElement(this.paper.getHtmlElement()));
        this.boardContainer.addComponent(paperControl);
        this.boardContainer.addClass("boardContainer");
        this.addComponent(this.boardContainer, 1, 1, 4, 4);
        this.boardContainer.setStyle("overflow", "auto")
        this.boardContainer.setStyle('background', "#f5f5f8");
        this.board = new ContainerPanel();
        // this.boardContainer.addComponent(board);
        this.board.setStyle("overflow", "visible")
        this.designView = new BorderPanel(15, 0, 15, 0);
        this.designView.setStyle("overflow", "visible")
        this.designView.setWidth(SizeInfo.valueOfPX(1211));
        this.designView.setHeight(SizeInfo.valueOfPX(774));
        this.board.addComponent(this.designView);
        this.sourceTableCollectionView = new H5VFlexPanel();
        this.sourceTableCollectionView.addClass('sourceColl');
        this.sourceTableCollectionView.setStyle('position', "relative");
        this.targetTableCollectionView = new H5VFlexPanel();
        this.targetTableCollectionView.addClass('targetColl');
        this.targetTableCollectionView.setStyle('position', "relative");
        this.designView.setLeft(this.sourceTableCollectionView);
        this.designView.setCenter(this.targetTableCollectionView);
        this.initViewMouseEvent(this.paper);
    }

    /**
     * 初始化视图面板的鼠标事件
     * @param paper
     */
    private initViewMouseEvent(paper: IGTable): void {
        paper.getHtmlElement().addEventListener('contextmenu', function (e: any) {
            e.preventDefault();
        })
        paper.mousedown(e => this.getOptStateDelegate().getCurrentState().mousedown(e));
        paper.mousemove(e => this.getOptStateDelegate().getCurrentState().mousemove(e));
        paper.mouseup(e => this.getOptStateDelegate().getCurrentState().mouseup(e));
    }

    createOptStateDelegate(): DataMigrationOptStateDelegate {
        return new DataMigrationOptStateDelegate(this);
    }

    getPropertyDefine(): AbstractPropertyDefine {
        return DataMigrationPropertyDefine.getInstance();
    }

    getMapLinks(): Map<String, AbstractLink> {
        return this.mapLinks;
    }

    getTemplateView(): JComponent<any> {
        if (this.selectViewName == 'sourceColl') {
            return this.sourceTableCollectionView;
        } else {
            return this.targetTableCollectionView;
        }
    }

    setSelectViewName(name: string) {
        this.selectViewName = name;
    }

    getDesginView(): BorderPanel {
        return this.designView;
    }

    getPointLIst(): Custom[] {
        return this.pointLIst;
    }

    getBoardContainer(): ContainerPanel {
        return this.boardContainer;
    }

    load(xmlEntity: IXmlEntity): void {
        this.xmlEntity = xmlEntity;
    }

    /**
     * 通过xml模型载入视图
     */
    loadView(xmlEntity: IXmlEntity, operationDispatcher: OperationDispatcher, path: string): void {
        this.sourceViewElements = [];
        this.targetViewElements = [];
        this.sourceTableCollectionView.removeAll();
        this.targetTableCollectionView.removeAll();
        if (this.srcForeginObject) {
            this.srcForeginObject.remove();
        }
        if (this.tagForeginObject) {
            this.tagForeginObject.remove();
        }
        if(this.linkDataMigrationButton) {
            this.boardContainer.removeComponent(this.linkDataMigrationButton);
        }
        this.clearElements();
        this.operationDispatcher = operationDispatcher;
        this.path = path;
        this.xmlEntity = xmlEntity;
        var tagMigration = xmlEntity.getTagRoot();
        DataMigrationNodeUtil.reloadTableCollectionHeight(xmlEntity);
        this.creatSourceAndTargetView(tagMigration, this, path)//创建源表页面，目标表页面嵌入SVG标签中
        let paperHeight = this.checkDesignViewHeight();
        let htmlElement = <HTMLElement>this.paper.getHtmlElement();
        if (paperHeight < 800) {
            htmlElement.style["height"] = SizeInfo.valueOfPX(800).toString();
        } else {

            htmlElement.style["height"] = SizeInfo.valueOfPX(paperHeight).toString();
        }
        // 更新视图
        //this.updateView();
    }

    initInputState(sefl: DataMigrationGraphicView, e: any) {
        var cmd = new InputCellCmd(sefl, e);
        this.getCmdQueue().doCmd(cmd);

    }

    initDeleteState(sefl: DataMigrationGraphicView, e: any) {
        var cmd = new FieldDelete(sefl, e);
        this.getCmdQueue().doCmd(cmd);

    }

    checkDesignViewHeight(): number {
        let tagMigration = this.getXmlEntity().getTagRoot();
        var nodes = tagMigration.getChildren();
        var nodeSourceColl = <ITagNode>nodes[0]; //源表集合
        var nodeTargetColl = <ITagNode>nodes[1]; //目标表表集合'
        let sorHeight = nodeSourceColl.getAttributeValueInt(BaseConstants.ATTR_Height, 0);
        let sorY = nodeSourceColl.getAttributeValueInt(BaseConstants.ATTR_Y, 0);
        let tarHeight = nodeTargetColl.getAttributeValueInt(BaseConstants.ATTR_Height, 0)
        let tarY = nodeTargetColl.getAttributeValueInt(BaseConstants.ATTR_Y, 0)
        return sorHeight + sorY > tarHeight + tarY ? sorHeight + sorY : tarHeight + tarY
    }

    creatSourceAndTargetView(tagMigration: ITagNode, dataMigrationGraphicView: DataMigrationGraphicView,  path: string): void {
        if (!tagMigration) return;
        var nodes = tagMigration.getChildren();
        var nodeSourceColl = <ITagNode>nodes[0]; //源表集合
        var nodeTargetColl = <ITagNode>nodes[1]; //目标表表集合

        if(tagMigration.hasAttribute(CommonConstant.ATTR_Extend)){
            let extend = tagMigration.getAttributeValue(CommonConstant.ATTR_Extend);
            this.linkDataMigrationButton = new Button("关联数据迁移");
            this.linkDataMigrationButton.addClass("linkDataMapButton");
            this.linkDataMigrationButton.addEventListener(Events.MouseDown, (event: any) => {
                //@ts-ignore
                const exp = `OpenDataMigration('${extend}','${path}','')`;

                this.operationDispatcher?.eval(exp);
            });
            this.boardContainer.addComponent(this.linkDataMigrationButton);
        }

        var fistSourceView = new SourceTableView(nodeSourceColl, true, this.srcitems, this);
        fistSourceView.addClass("tableArea")
        this.sourceTableCollectionView.addComponent(fistSourceView);
        this._sourceViews.set(fistSourceView.getTableName(), fistSourceView)
        this.sourceViewElements.push(fistSourceView);
        var firstTargetView = new TargetTableView(nodeTargetColl, true, this.taritems, dataMigrationGraphicView);
        firstTargetView.addClass("tableArea")
        this.targetTableCollectionView.addComponent(firstTargetView);
        this._targetViews.set(firstTargetView.getTableName(), firstTargetView)
        this.targetViewElements.push(firstTargetView);
        let sourceTables = nodeSourceColl.getChildren();
        for (let sourceTable of sourceTables) {
            var sourceTableNode = <ITagNode>sourceTable;
            var sourceCollView = new SourceTableView(sourceTableNode, false, this.srcitems, dataMigrationGraphicView);
            sourceCollView.addClass("tableArea")
            this.sourceTableCollectionView.addComponent(sourceCollView);
            this.sourceViewElements.push(sourceCollView);
            this._sourceViews.set(sourceCollView.getTableName(), sourceCollView)
        }
        let targetTables = nodeTargetColl.getChildren();
        for (let targetTable of targetTables) {
            var targetNode = <ITagNode>targetTable;
            var targetTableView = new TargetTableView(targetNode, false, this.taritems, dataMigrationGraphicView);
            targetTableView.addClass("tableArea")
            this.targetTableCollectionView.addComponent(targetTableView);
            this.targetViewElements.push(targetTableView);
            this._targetViews.set(targetTableView.getTableName(), targetTableView)
        }
        let height = nodeSourceColl.getAttributeValueInt(BaseConstants.ATTR_Height, 0);
        let width = nodeSourceColl.getAttributeValueInt(BaseConstants.ATTR_Width, 0);
        let x = nodeSourceColl.getAttributeValueInt(BaseConstants.ATTR_X, 0);
        let y = nodeSourceColl.getAttributeValueInt(BaseConstants.ATTR_Y, 0);
        let height1 = nodeTargetColl.getAttributeValueInt(BaseConstants.ATTR_Height, 0);
        let width1 = nodeTargetColl.getAttributeValueInt(BaseConstants.ATTR_Width, 0);
        let x1 = nodeTargetColl.getAttributeValueInt(BaseConstants.ATTR_X, 0);
        let y1 = nodeTargetColl.getAttributeValueInt(BaseConstants.ATTR_Y, 0);
        this.sourceTableCollectionView.setHeight(SizeInfo.valueOfPX(height))
        this.sourceTableCollectionView.setWidth(SizeInfo.valueOfPX(width))
        this.targetTableCollectionView.setHeight(SizeInfo.valueOfPX(height1))
        this.targetTableCollectionView.setWidth(SizeInfo.valueOfPX(width1))
        this.sourceTableCollectionView.display();
        this.targetTableCollectionView.display();
        this.srcForeginObject = this.paper.table(x, y, width, height, this.sourceTableCollectionView.getEl());
        this.tagForeginObject = this.paper.table(x1, y1, width1, height1, this.targetTableCollectionView.getEl());
        this.addAnchorPoint(nodeSourceColl, nodeTargetColl);
        this.loadLinks(nodeSourceColl);
    }

    getSrcForeginObject(): SVGForeignObjectElement {
        return this.srcForeginObject!;
    }

    getTagForeginObject(): SVGForeignObjectElement {
        return this.tagForeginObject!;
    }

    /**
     * 根据鼠标的点击位置获取到该位置对应的区域
     */
    hitCell(x: number, y: number, tagName: string): FieldView | undefined {
        let list;
        if (tagName != 'source') {
            list = this.targetViewElements
        } else {
            list = this.sourceViewElements
        }
        for (let element of list) {
            if (element.containPoint(x, y)) {
                var sectionView = <TargetTableView>element;
                var sectionOffset = DomUtil.offsetParent(sectionView.getEl());
                var offsetX = x - sectionOffset.offsetLeft;
                var offsetY = y - sectionOffset.offsetTop;
                var cellView = sectionView.locCell(offsetX, offsetY);
                if (cellView) {
                    return cellView;
                }
            }
        }
        return undefined;
    }

    // 根据xml模型中的变化事件，更新界面显示
    notifyEvent(cmd: string, paras: Paras): void {
        var node = paras.getElement();
        switch (cmd) {
            case ActionNames.model_node_add:
                this.loadView(this.xmlEntity, this.operationDispatcher!, this.path!);
                break;
            case ActionNames.model_node_remove:
                this.loadView(this.xmlEntity, this.operationDispatcher!, this.path!);
                break;
            case ActionNames.model_node_update:
                this.loadView(this.xmlEntity, this.operationDispatcher!, this.path!);
                break;
            case ActionNames.model_node_update_select:
                this.loadView(this.xmlEntity, this.operationDispatcher!, this.path!);
                break;
        }
    }

    //单个添加源表字段
    public doAddFieldCmd(dataMigrationGraphicView: DataMigrationGraphicView, tableKey: string, fieldKey: string, tagNode: ITagNode): any {
        var cmd = new AddSourceFieldCmd(dataMigrationGraphicView, tableKey, fieldKey, tagNode);
        this.getCmdQueue().doCmd(cmd);
    }

    //单个添加目标表字段
    public doAddTargetFieldCmd(dataMigrationGraphicView: DataMigrationGraphicView, tableKey: string, fieldKey: string, tagNode: ITagNode): any {
        var cmd = new AddTargetFieldCmd(dataMigrationGraphicView, tableKey, fieldKey, tagNode);
        this.getCmdQueue().doCmd(cmd);
    }

    //批量添加源表字段
    public doAddFieldsCmd(dataTable: any, xmlEntity: IXmlEntity, wfWorkSpace: IWorkSpace): any {
        var cmd = new AddSourceFieldsCmd(dataTable, xmlEntity, wfWorkSpace);
        this.getCmdQueue().doCmd(cmd);
    }

    //批量添加目标表字段
    public doAddTargetFieldsCmd(dataTable: any, xmlEntity: IXmlEntity, wfWorkSpace: IWorkSpace): any {
        var cmd = new AddTargetFieldsCmd(dataTable, xmlEntity, wfWorkSpace);
        this.getCmdQueue().doCmd(cmd);
    }

    //连线
    public doNewLinkCmd(dataMigrationGraphicView: DataMigrationGraphicView, scrNode: ITagNode, tarNode: ITagNode): any {
        var cmd = new NewLinkCmd(dataMigrationGraphicView.getXmlEntity(), scrNode, tarNode);
        this.getCmdQueue().doCmd(cmd);
    }

    //删除线
    public doDeleteLinkCmd(dataMigrationGraphicView: DataMigrationGraphicView, tarNode: ITagNode): any {
        var cmd = new DeleteLinkCmd(dataMigrationGraphicView, tarNode);
        this.getCmdQueue().doCmd(cmd);
    }

    // 交换Field
    public doMoveFieldCmd(dataMigrationGraphicView: DataMigrationGraphicView, scrNode: ITagNode, tarNode: ITagNode): any {
        var cmd = new MoveFieldCmd(dataMigrationGraphicView.getXmlEntity(), scrNode, tarNode);
        this.getCmdQueue().doCmd(cmd);
    }

    // 移动table
    public doMoveTableCmd(dataMigrationGraphicView: DataMigrationGraphicView, tagNode: ITagNode, x: number, y: number): any {
        var cmd = new MoveTableCmd(dataMigrationGraphicView.getXmlEntity(), tagNode, x, y);
        this.getCmdQueue().doCmd(cmd);
    }

    getCmdQueue(): CmdQueue {
        return this.xmlEntity.getCmdQueue();
    }

    setSrcMap(map: Map<string, any>) {
        this.srcitems = map;
    }

    setTarMap(map: Map<string, any>) {
        this.taritems = map;
    }

    getSourceCollectionView() {
        return this.sourceTableCollectionView;
    }

    getTargetCollectionView() {
        return this.targetTableCollectionView;
    }

    getPaper(): GDataMigration {
        return this.paper;
    }

    getSrcPoint(): Map<string, DivElement> {
        return this.scrPoints;
    }

    getTarPoint(): Map<string, DivElement> {
        return this.tarPoints;
    }

    getXmlEntity() {
        return this.xmlEntity;
    }

    getTargetViewElements() {
        return this.targetViewElements;
    }

    setSelectSourceView(sourceView: SourceTableView) {
        this.selectSourceView = sourceView
    }

    getSelectSourceView(): SourceTableView | undefined {
        return this.selectSourceView;
    }

    setSelectTargetView(targetTableView: TargetTableView) {
        this.selectTargetView = targetTableView
    }

    getSelectTargetView(): TargetTableView | undefined {
        return this.selectTargetView;
    }

    getSourceViewElements() {
        return this.sourceViewElements;
    }

    getSelectFieldView(): FieldView | undefined {
        return this.selectFieldView;
    }

    setSelectFieldView(fieldView: FieldView): void {
        this.selectFieldView = fieldView;
        this.selectFieldTagNode = fieldView.getTagNode();
    }

    getSelectFieldTagNode(): ITagNode | undefined {
        if (!this.selectFieldTagNode){
            return this.selectFieldView?.getTagNode();
        }
        return this.selectFieldTagNode;
    }

    setSelectFieldTagNode(iTagNode: ITagNode): void {
        this.selectFieldTagNode = iTagNode;
    }


    private addAnchorPoint(sourceColl: ITagNode, targetColl: ITagNode) {//添加连线锚点
        //添加源表连线锚点
        let x = sourceColl.getAttributeValueInt(BaseConstants.ATTR_X, 0);
        let y = sourceColl.getAttributeValueInt(BaseConstants.ATTR_Y, 0) + 100;
        let sourceTables = sourceColl.getChildren();
        let sourWidth = sourceColl.getAttributeValueInt(BaseConstants.ATTR_Width, 0)
        let ySpan = 2 * DATAMIGRATION.D_ROW_HEIGHT;
        for (let sourceTable of sourceTables) {
            let sorTable = <ITagNode>sourceTable;
            let tableKey = sorTable.getAttributeValue(DataMigrationConstants.Attr_Key);
            let definitionList = new ArrayList();
            let sourceFields = sorTable.getChildren();
            if (sourceFields) {
                for (let sourceField of sourceFields) {
                    let field = <ITagNode>sourceField;
                    let showText = DataMigrationUtil.getSourceFieldShowText(field);
                    let targetFieldKey = field.getAttributeValue(DataMigrationConstants.NODE_TargetFieldKey);
                    let targetTableKey = field.getAttributeValue(DataMigrationConstants.NODE_TargetTableKey);
                    if (!definitionList.contain(tableKey + "_" + showText)) {
                        definitionList.add(tableKey + "_" + showText);
                        let anchor = new DivElement();
                        anchor.setAttr("tableKey", tableKey);
                        anchor.setAttr("definition", showText);
                        anchor.addClass("anchorpoint");
                        anchor.setStyle("left", SizeInfo.valueOfPX(sourWidth + x - 2));
                        anchor.setStyle("top", SizeInfo.valueOfPX(y + ySpan + 2));
                        //if (targetTableKey) {
                        anchor.setAttr("targetTableKey", targetTableKey);
                        anchor.setAttr("targetFieldKey", targetFieldKey);
                        this.scrPoints.set(tableKey + "_" + showText, anchor);
                        //   }
                        var point = new Custom(anchor);
                        this.pointLIst.push(point)
                        this.boardContainer.addComponent(point)
                        ySpan = ySpan + DATAMIGRATION.D_ROW_HEIGHT;
                    }
                }
            }
            ySpan = ySpan + 2 * DATAMIGRATION.D_ROW_HEIGHT;
        }
        //添加目标表头部锚点
        let x1 = targetColl.getAttributeValueInt(BaseConstants.ATTR_X, 0);
        let y1 = targetColl.getAttributeValueInt(BaseConstants.ATTR_Y, 0) + 100;
        let targetTables = targetColl.getChildren();
        ySpan = 2 * DATAMIGRATION.D_ROW_HEIGHT;
        for (let targetTable of targetTables) {
            let tarTable = <ITagNode>targetTable;
            let tableKey = tarTable.getAttributeValue(BaseConstants.ATTR_TableKey);
            let definitionList = new ArrayList();
            let targetFields = tarTable.getChildren();
            if (targetFields) {
                for (let targetField of targetFields) {
                    let field = <ITagNode>targetField;
                    let fieldKey = field.getAttributeValue(DataMigrationConstants.NODE_FieldKey);
                    if (!definitionList.contain(tableKey + "_" + fieldKey)) {
                        definitionList.add(tableKey + "_" + fieldKey);
                        let anchor = new DivElement();
                        anchor.setAttr("tableKey", tableKey);
                        anchor.setAttr("fieldKey", fieldKey);
                        anchor.addClass("anchorpoint");
                        anchor.setStyle("left", SizeInfo.valueOfPX(x1));
                        anchor.setStyle("top", SizeInfo.valueOfPX(y1 + ySpan + 2));
                        var point = new Custom(anchor);
                        this.boardContainer.addComponent(point)
                        this.pointLIst.push(point)
                        this.tarPoints.set(tableKey + "_" + fieldKey, anchor);
                        ySpan = ySpan + DATAMIGRATION.D_ROW_HEIGHT;
                    }
                }
            }
            ySpan = ySpan + 2 * DATAMIGRATION.D_ROW_HEIGHT;
        }
        this.boardContainer.display();
    }

    private loadLinks(source: ITagNode) {
        let sourceTables = source.getChildren();
        if (sourceTables) {
            for (let sourceTable of sourceTables) {
                let sorTable = <ITagNode>sourceTable;
                let tableKey = sorTable.getAttributeValue(DataMigrationConstants.Attr_Key);
                let sourceFields = sorTable.getChildren();
                if (sourceFields) {
                    for (let sourceField of sourceFields) {
                        let field = <ITagNode>sourceField;
                        let showText = DataMigrationUtil.getSourceFieldShowText(field);
                        let targetFieldKey = field.getAttributeValue(DataMigrationConstants.NODE_TargetFieldKey);
                        let targetTableKey = field.getAttributeValue(DataMigrationConstants.NODE_TargetTableKey);
                        if (targetFieldKey && targetTableKey) {
                            let srcPoint = this.scrPoints.get(tableKey + "_" + showText);
                            let tarPoint = this.tarPoints.get(targetTableKey + "_" + targetFieldKey);
                            if (srcPoint && tarPoint) {
                                let sequenceFlow = new SequenceFlow();
                                sequenceFlow.initGSection(this.paper.section())
                                sequenceFlow.setFromNode({
                                    x: srcPoint!.getOffsetLeft(),
                                    y: srcPoint!.getOffsetTop() - 30,
                                    width: 4,
                                    height: 4
                                })
                                sequenceFlow.setToNode({
                                    x: tarPoint!.getOffsetLeft(),
                                    y: tarPoint!.getOffsetTop() - 30,
                                    width: 4,
                                    height: 4
                                });

                                let controlNode = sequenceFlow.getControlNode();
                                controlNode.attr({"pathId": tableKey + "*_*" + showText + "*_*" + targetTableKey + "*_*" + targetFieldKey});
                                controlNode.attr({"Key": field.getAttributeValue(DataMigrationConstants.Attr_Key)});
                                controlNode.attr({"srcTableKey": tableKey});
                                controlNode.attr({"tagTableKey": targetTableKey});
                                controlNode.attr({"class": "fieldCell_pointer"});
                                this.mapLinks.set(tableKey + "*_*" + showText + "*_*" + targetTableKey + "*_*" + targetFieldKey, sequenceFlow);
                            }
                        }
                    }
                }
            }
        }


    }

    private clearElements() {
        for (let custom of this.pointLIst) {
            this.boardContainer.removeComponent(custom);
            this.pointLIst = [];
        }
        for (let scrPoint of this.mapLinks.values()) {
            scrPoint.remove();
        }
        this.mapLinks.clear();
        this.scrPoints.clear();
        this.tarPoints.clear();
    }

    setExtendSourceToTargetLinks(list: String[]){
        this.extendSourceToTargetLinks = list;
    }

    getExtendSourceToTargetLinks(): String[]{
        return this.extendSourceToTargetLinks;
    }
}
