import OperationDispatcher from "../../../common/operation/OperationDispatcher";
import SizeInfo from "../../../common/struct/SizeInfo";
import PropertyPlugin from "../../plugin/property/PropertyPlugin";
import DesignVariable from "../../base/DesignVariable";
import Toolbar from "../../../common/component/toolbar/Toolbar";
import AbstractDesignView from "../../base/AbstractDesignView";
import DevPropertyPlugin from "../../bpm/property/DevPropertyPlugin";
import PropertyUIContainer from "../../plugin/property/ui/PropertyUIContainer";
import ComplexDesignView from "../../base/ComplexDesignView";
import PrintConstants from "../../print/base/PrintConstants";
import DataMigrationGraphicView from "./DataMigrationGraphicView";
import DataMigrationPropertyDefine from "../base/DataMigrationPropertyDefine";
import DataMigrationConstants from "../base/DataMigrationConstants";


export default class DevDesignView extends AbstractDesignView<DevPropertyPlugin> {

    private viewContainer: ComplexDesignView<DataMigrationGraphicView, Toolbar>;

    private propertyPlugin: PropertyPlugin;

    constructor(viewContainer: ComplexDesignView<DataMigrationGraphicView, Toolbar>, optDispatcher: OperationDispatcher) {
        super(DesignVariable.D_PROPERTY_WIDTH, new PropertyUIContainer(new DevPropertyPlugin(optDispatcher)));
        this.viewContainer = viewContainer;
        this.propertyPlugin = this.propertyUIContainer.getPropertyPlugin();

        this.propertyUIContainer.setStyle('float', 'right');
        this.setCenter(viewContainer);
        this.setRight(this.propertyUIContainer);

        var PD = DataMigrationPropertyDefine.getInstance();
        this.propertyPlugin.register(DataMigrationConstants.NODE_DataMigration, PD.getPropertyDefines(DataMigrationConstants.NODE_DataMigration));
        this.propertyPlugin.register(DataMigrationConstants.NODE_SourceTableCollection, PD.getPropertyDefines(DataMigrationConstants.NODE_SourceTableCollection));
        this.propertyPlugin.register(DataMigrationConstants.NODE_SourceTable, PD.getPropertyDefines(DataMigrationConstants.NODE_SourceTable));
        this.propertyPlugin.register(DataMigrationConstants.NODE_SourceField, PD.getPropertyDefines(DataMigrationConstants.NODE_SourceField));
        this.propertyPlugin.register(DataMigrationConstants.NODE_TargetTableCollection, PD.getPropertyDefines(DataMigrationConstants.NODE_TargetTableCollection));
        this.propertyPlugin.register(DataMigrationConstants.NODE_TargetTable, PD.getPropertyDefines(DataMigrationConstants.NODE_TargetTable));
        this.propertyPlugin.register(DataMigrationConstants.NODE_TargetField, PD.getPropertyDefines(DataMigrationConstants.NODE_TargetField));
        this.propertyPlugin.register("Ligature", PD.getPropertyDefines("Ligature"));
    }

    resize(parentWidth: number, parentHeight: number) {
        var width = parentWidth -  DesignVariable.D_PROPERTY_WIDTH;
        this.viewContainer.resize(width, parentHeight);
        this.propertyUIContainer.setHeight(SizeInfo.valueOfPX(parentHeight));
    }
}