import AbstactDataMigrationOptState from "./AbstactDataMigrationOptState";
import ITagNode from "../../../common/xml/node/ITagNode";
import DataMigrationOptStateDelegate from "./DataMigrationOptStateDelegate";
import {FieldView} from "../view/FieldView";
import TagNode from "../../../common/xml/node/TagNode";
import DataMigrationConstants from "../base/DataMigrationConstants";


export default class NormalState extends AbstactDataMigrationOptState {
    private fromTag?: ITagNode;

    private toNodeKey?: ITagNode;

    constructor(delegate: DataMigrationOptStateDelegate) {
        super(delegate);
    }


    mousedown(e: MouseEvent): void {
        let selectionModel = this.getView().getXmlEntity().getSelectionModel();
        /*
           if (e.currentTarget.tagName == "svg") {
               return;
           }
   */
        let target = <HTMLElement>e.target;
        if (target.nodeName == "path") {
            let elHTMLElement = <HTMLElement>e.target;
            const el = $(elHTMLElement);
            el.addClass("fieldCell_pointer");
            let pathId = target.getAttribute('pathId');
            if (pathId) {
                let srcTableKey = target.getAttribute('srcTableKey');
                let tagTableKey = target.getAttribute('tagTableKey');
                let fields = pathId!.split("*_*");
                let src_field = fields[1];
                let tag_field = fields[3];
                let child = <ITagNode>this.getView().getXmlEntity().getRoot().find("SourceTableCollection", "", "");
                let findSourceTable = child.find("SourceTable", DataMigrationConstants.Attr_Key, srcTableKey!);

                let result = null;
                findSourceTable!.getChildren().forEach((node, i, ii) => {
                    let node1 = <ITagNode>(node);
                    if (node1.getAttributeValue(DataMigrationConstants.Attr_Key) == target.getAttribute(DataMigrationConstants.Attr_Key) && node1.getAttributeValue("TargetFieldKey", "") == tag_field && node1.getAttributeValue("TargetTableKey", "") == tagTableKey) {
                        result = node;
                    }
                })
                if (result != null) {
                    selectionModel.select(this.getView().getXmlEntity().getTagRoot());
                    let ligature = new TagNode("Ligature");
                    ligature.setAttributeValue("TargetTableKey", tagTableKey!);
                    ligature.setAttributeValue("TargetFieldKey", tag_field!);
                    ligature.setAttributeValue("TableKey", srcTableKey!);
                    ligature.setAttributeValue("Definition", src_field!);
                    ligature.setAttributeValue("Key", target.getAttribute(DataMigrationConstants.Attr_Key)!);
                    ligature.setAttributeValue("OpSign", (<ITagNode>result)!.getAttributeValue("OpSign", "AddDelta")!);
                    ligature.setAttributeValue("GroupingPolicy", (<ITagNode>result)!.getAttributeValue("GroupingPolicy", "Discrete")!);
                    ligature.setAttributeValue("PeriodValue", (<ITagNode>result)!.getAttributeValue("PeriodValue", "Default")!);
                    ligature.setAttributeValue("MapFormula", (<ITagNode>result)!.getAttributeValue("MapFormula", "")!);
                    ligature.setAttributeValue("IsNegtive", (<ITagNode>result)!.getAttributeValue("IsNegtive", "false")!);
                    ligature.setAttributeValue("DateGranularity", (<ITagNode>result)!.getAttributeValue("DateGranularity", "")!);
                    ligature.getChildren().push(result);
                    selectionModel.select(ligature);
                }
                let mapLinks = this.getView().getMapLinks();
                mapLinks.get(pathId!);
                // @ts-ignore
                $(mapLinks.get(pathId).group.line.paper.node).css("stroke-width", "3");
                if (e.button == 2) {//右键
                    if (result != null) {
                        this.getView().doDeleteLinkCmd(this.getView(),result);
                    }
                }
            }
        } else {
            /* // @ts-ignore
             if (e.currentTarget.tagName == "svg") {
                 return;
             }*/
            var view = this.findFieldView(e);
            if (!view) {
                //@ts-ignore
                if (target.tagName == "svg") {
                    selectionModel.select(this.getView().getXmlEntity().getTagRoot());
                }
                return;
            }
            let node = view.getTagNode();
            this.getView().setSelectFieldView(view);
            selectionModel.select(node);
        }


    }


    mousemove(e: MouseEvent): void {
        let view = this.findFieldView(e);
        if (view) { // 转发到字段操作状态
            this.getDelegate().setFieldOptState();
        }
    }

    mouseup(e: MouseEvent): void {

    }

    reset(): void {
        super.reset();
        this.fromTag = undefined;
        this.toNodeKey = undefined;
        //this.getDelegate().reset();
    }

}
