import ITagNode from "../../../common/xml/node/ITagNode";
import DataMigrationConstants from "./DataMigrationConstants";

export default class DataMigrationUtil {
    static getSourceFieldKey(tagNode: ITagNode): string {
        let sourceTable = tagNode.getParent();
        let sourceFields = sourceTable!.getChildren();
        let count = 1;
        for (let i = 0; i < sourceFields.length; i++) {
            let sourceField = <ITagNode>sourceFields[i];
            if (sourceField.getAttributeValue(DataMigrationConstants.NODE_Definition) == tagNode.getAttributeValue(DataMigrationConstants.Attr_Key)) {
                count++;
                //存在key相同的情况，再 ++
                if (sourceField.getAttributeValue(DataMigrationConstants.Attr_Key) == tagNode.getAttributeValue(DataMigrationConstants.Attr_Key) + count) {
                    count++;
                }
            }
        }
        return tagNode.getAttributeValue(DataMigrationConstants.Attr_Key) + count;
    }

    static getSourceFieldShowText(tagNode: ITagNode): string{
        if(tagNode.hasAttribute(DataMigrationConstants.NODE_Definition)) {
            return tagNode.getAttributeValue(DataMigrationConstants.NODE_Definition);
        }else{
            return tagNode.getAttributeValue(DataMigrationConstants.Attr_Key);
        }
    }
}