export default class DATAMIGRATION {
    public static D_TH_COLUMN_WIDTH = 35;
    public static D_TH_COLUMN_HEIGHT = 60;
    public static D_COLUMN_WIDTH = 80;
    public static D_MAX_ROW_SIZE = 31;
    public static D_MAX_COL_SIZE = 31;
    public static PREFIX = "designer";//".""designer"
    public static D_ROW_HEIGHT = 30;

    public static D_ROW_Type = "Fix";

    public static D_FONT_NAME = "SimSun";

    public static D_FONT_SIZE = 12;

    public static PROPERTIES_XML: string =
        `<DATAMIGRATION>
<DefineCollection>
    <Define Key="DataMigration" Caption="迁移属性" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="迁移标识" Control="TextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="迁移名称" Control="TextEditor"/>
            <Property Key="Description" Caption="迁移描述" Control="TextEditor"/>
            <Property Key="SrcDataObjectKey" Caption="源表单标识" Control="TextEditor" Editable = "false"/>
            <Property Key="TgtDataObjectKey" Caption="目标对象标识" Control="TextEditor" Editable = "false"/>
            <Property Key="StatusFieldKey" Caption="状态字段标识" Control="Combobox"  OnInitialize="=Macro_getStatusFideldKey(GetSrcDataObjectKey())" />
            <Property Key="StatusValue" Caption="状态字段值" Control="Combobox" OnInitialize="=Macro_getStatusValue(GetSrcDataObjectKey())" />
            <Property Key="Condition" Caption="明细迁移条件" Control="ButtonEditor" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
            <Property Key="HeadCondition" Caption="迁移总条件" Control="ButtonEditor" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
        </PropertyCollection>
    </Define>
    <Define Key="SourceTableCollection" Caption="源表集合" Extends="">
        <PropertyCollection>
            <Property Key="X" Caption="水平位置" Control="NumberEditor" />
            <Property Key="Y" Caption="垂直位置" Control="NumberEditor" />
            <Property Key="Width" Caption="宽度" Control="NumberEditor"/>
            <Property Key="Height" Caption="高度" Control="NumberEditor"/>
        </PropertyCollection>
    </Define>
    <Define Key="SourceTable" Caption="源表" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="源表标识" Control="TextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="源表说明" Control="Combobox" Editable = "false" OnInitialize="=Macro_getTableCaption(GetSrcDataObjectKey(),GetDataMigrationTableKey())" DefaultValue=""/>
            <Property Key="IsPrimary" Caption="是否主表" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="false"/>
        </PropertyCollection>
    </Define>
    <Define Key="SourceField" Caption="源表字段" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="源字段标识" Control="TextEditor" Editable = "false" Visible="IsField()=='Field' && !HasAttrDefinition()"/>
            <Property Key="Definition" Caption="源字段标识" Control="TextEditor" Editable = "false" Visible="IsField()=='Field' && HasAttrDefinition()"/>
            <Property Key="Key" Caption="源字段内容" Control="DataMapTextEditor" Editable="true" Visible="GetPropertyValue('Type', 'Field') !='Field'  && !HasAttrDefinition()"/>
            <Property Key="Definition" Caption="源字段内容" Control="DataMapTextEditor" Editable="true" Visible="GetPropertyValue('Type', 'Field') !='Field' && HasAttrDefinition()"/>
            <Property Key="Caption" Caption="源字段说明" Control="Combobox" Editable = "false" OnInitialize="=Macro_getCaption(GetSrcDataObjectKey(),GetDataMigrationTableKey(),GetFieldKey())" DefaultValue="" Visible="IsField()=='Field'"/>
            <Property Key="DataType" Caption="源字段数据类型" Control="Combobox" Editable = "false" OnInitialize="=Macro_getDataType(GetSrcDataObjectKey(),GetDataMigrationTableKey(),GetFieldKey())" DefaultValue="" Visible="IsField()=='Field'"/>
            <Property Key="Type" Caption="源字段类型" Control="Combobox"  DefaultValue="Field" OnInitialize="Field,字段;Formula,公式;Const,常量"  Editable = "false"/>
            <Property Key="RefFieldKey" Caption="参照的主表字段标识" Control="Combobox" OnInitialize="=Macro_getMianTableFideldKey(GetSrcDataObjectKey(),GetIsPrimaryTableKey())" Visible="IsMainTable()!='true'"/>
        </PropertyCollection>
    </Define>
    <Define Key="TargetTableCollection" Caption="目标表集合" Extends="">
        <PropertyCollection>
            <Property Key="X" Caption="水平位置" Control="NumberEditor" />
            <Property Key="Y" Caption="垂直位置" Control="NumberEditor" />
            <Property Key="Width" Caption="宽度" Control="NumberEditor"/>
            <Property Key="Height" Caption="高度" Control="NumberEditor"/>
        </PropertyCollection>
    </Define>
    <Define Key="TargetTable" Caption="目标表" Extends="">
        <PropertyCollection>
            <Property Key="TableKey" Caption="目标表标识" Control="TextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="目标表说明" Control="Combobox" Editable = "false" OnInitialize="=Macro_getTableCaption(GetTagDataObjectKey(),GetDataMigrationTableKey())" DefaultValue=""/>
        </PropertyCollection>
    </Define>
    <Define Key="TargetField" Caption="目标表字段" Extends="">
        <PropertyCollection>
            <Property Key="FieldKey" Caption="目标字段标识" Control="TextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="目标字段说明" Control="Combobox" Editable = "false" OnInitialize="=Macro_getCaption(GetTagDataObjectKey(),GetDataMigrationTableKey(),GetFieldKey())" DefaultValue=""/>
            <Property Key="DataType" Caption="目标字段数据类型" Control="Combobox" Editable = "false"  OnInitialize="=Macro_getDataType(GetTagDataObjectKey(),GetDataMigrationTableKey(),GetFieldKey())" DefaultValue=""/>
        </PropertyCollection>
    </Define> 
    <Define Key="Ligature" Caption="连接线属性" Extends="">
        <PropertyCollection>
            <Property Key="TableKey" Caption="源表标识" Control="TextEditor" Editable = "false"/>
            <Property Key="Key" Caption="源字段key" Control="TextEditor"  Editable = "false"/>
            <Property Key="Definition" Caption="源字段标识" Control="TextEditor"  Editable = "false"/>
            <Property Key="TargetTableKey" Caption="目标表标识" Control="TextEditor" Editable = "false"/>
            <Property Key="TargetFieldKey" Caption="目标字段" Control="TextEditor" Editable = "false"/>
            <Property Key="GroupingPolicy" Caption="分组策略" Control="Combobox" OnInitialize="Period,期间分组;Discrete,直接量;" DefaultValue="Discrete"  Visible="!Macro_getGroupTypeByLin(GetTagDataObjectKey(),GetTagTableKeyByLin(),GetTagFieldKeyByLin())"/>
            <Property Key="PeriodValue" Caption="期间取值方式" Control="Combobox" OnInitialize="Default,默认;Value,直接取值;Map,值映射;" DefaultValue="Default"  Visible="!Macro_getGroupTypeByLin(GetTagDataObjectKey(),GetTagTableKeyByLin(),GetTagFieldKeyByLin())"/>
            <Property Key="MapFormula" Caption="分组映射公式" Control="ButtonEditor" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'  Visible="!Macro_getGroupTypeByLin(GetTagDataObjectKey(),GetTagTableKeyByLin(),GetTagFieldKeyByLin())"/>
            <Property Key="OpSign" Caption="值处理方式" Control="Combobox" OnInitialize="AddDelta,加变化值;AddValue,加直接量;Assign,赋直接量;" DefaultValue="AddDelta" Visible="Macro_getGroupTypeByLin(GetTagDataObjectKey(),GetTagTableKeyByLin(),GetTagFieldKeyByLin())"/>
            <Property Key="IsNegtive" Caption="是否负向迁移" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="false"  Visible="Macro_getGroupTypeByLin(GetTagDataObjectKey(),GetTagTableKeyByLin(),GetTagFieldKeyByLin())"/>
            <Property Key="DateGranularity" Caption="时间粒度"  Control="Combobox" OnInitialize=",;Day,日;Month,月;Year,年;FiscalMonth,财政月份;" DefaultValue="" Visible="false"/>
        </PropertyCollection>
    </Define>
</DefineCollection>
</DATAMIGRATION>
`;
}