import AbstractWorkSpace from "../base/AbstractWorkSpace";
import {EDesignMode} from "../../common/enum/Enums";
import AbstractDesignView from "../base/AbstractDesignView";
import ComplexDesignView from "../base/ComplexDesignView";

import CmdQueue from "../../common/cmd/CmdQueue";
import OperationDispatcher from "../../common/operation/OperationDispatcher";
import Toolbar from "../../common/component/toolbar/Toolbar";

import AbstractDomElement from "../../common/dom/AbstractDomElement";
import {IPropertyIO} from "../plugin/property/base/PropertyDefine";
import DataMigrationGraphicView from "./view/DataMigrationGraphicView";
import DataMigrationDesignView from "./view/DataMigrationDesignView";
import {DataMigrationProperty} from "./property/DataMigrationProperty";
import Button from "../../common/component/control/Button";
import XmlEntity from "../../common/xml/XmlEntity";
import Events from "../../common/event/Events";
import Menu from "../../common/component/menu/Menu";
import ITagNode from "../../common/xml/node/ITagNode";
import InputState from "./state/InputState";
import TextEditor from "../../common/component/control/TextEditor";
import SizeInfo from "../../common/struct/SizeInfo";
import KeyUpEvent = JQuery.KeyUpEvent;
import {CommonConstant} from "../datamap/base/CommonConstant";


export default class DataMigrationWorkSpace extends AbstractWorkSpace<DataMigrationGraphicView, Toolbar> {
    private xml: string;
    private path?: string;
    private mune: Menu | undefined;

    constructor(mode: EDesignMode, path: string) {
        super(mode, new Toolbar());
        this.addClass("excel-workspace");
        this.path = path;
        this.xml = "";
    }

    createDesignView(viewContainer: ComplexDesignView<any, any>, operationDispatcher: OperationDispatcher): AbstractDesignView<any> {
        return new DataMigrationDesignView(viewContainer, operationDispatcher);
    }

    createGraphicView(mode: EDesignMode) {
        var excelGraphicView = new DataMigrationGraphicView();
        var sourceCollectionView = excelGraphicView.getSourceCollectionView();
        var targetCollectionView = excelGraphicView.getTargetCollectionView();
        this.initViewMouseEvent(sourceCollectionView.getDomElement());
        this.initTargetEvent(targetCollectionView.getDomElement());
        let domEl = excelGraphicView.getDesginView().getDomElement();
        domEl.addEventListener('contextmenu',function(e:any){
            e.preventDefault();
        })
        domEl.addEventListener('mousemove', (e: MouseEvent) => this.getGraphicView().getOptStateDelegate().getCurrentState().mousemove(e));
        domEl.addEventListener('mouseup', (e: MouseEvent) => this.getGraphicView().getOptStateDelegate().getCurrentState().mouseup(e));
        return excelGraphicView;
    }

    load(xml: string) {
        let xmlEntity = XmlEntity.parse(xml ? xml : this.DEMO_XML);
        let root = xmlEntity.getRoot().getChild("DataMigration")!;
        let tgtDataObjectKey = root.getAttributeValue("TgtDataObjectKey");
        let srcDataObjectKey = root.getAttributeValue("SrcDataObjectKey");

        if(root.hasAttribute(CommonConstant.ATTR_Extend)){
            var exp =`Macro_GetExtendDataMigrationLinks('${root.getAttributeValue(CommonConstant.ATTR_Extend)}')`;
            this.operationDispatcher.eval(exp).then((res) =>{
                this.getGraphicView().setExtendSourceToTargetLinks(res);
            });
        }

        let srcFormula = "Macro_GetAllFields(" + "'" + srcDataObjectKey + "','" + tgtDataObjectKey + "')"
        this.operationDispatcher.eval(srcFormula).then((res) => {
            let parse = JSON.parse(res);
            var srcmap = new Map<string, any>()
            var tarmap = new Map<string, any>()
            for (let parseKey in parse["srcitems"]) {
                srcmap.set(parseKey, parse["srcitems"][parseKey]);
            }
            for (let parseKey in parse["taritems"]) {
                tarmap.set(parseKey, parse["taritems"][parseKey]);
            }
            this.getGraphicView().setSrcMap(srcmap);
            this.getGraphicView().setTarMap(tarmap);
            this.getGraphicView().loadView(this.getXmlEntity(), this.operationDispatcher, this.path!)
        });
        super.load(xml ? xml : this.DEMO_XML);
    }


    /**
     * 初始化源表字段事件
     */
    private initViewMouseEvent(domEl: AbstractDomElement): void {
        domEl.addEventListener('mousedown', (e: MouseEvent) => {
            var target = <HTMLElement>e.target;
            let extend = this.getGraphicView().getXmlEntity().getTagRoot().getAttributeValue(CommonConstant.ATTR_Extend);
            if (target.nodeName == "SPAN" && target.className.indexOf("selectButton") != -1) {
                let srcchild = <ITagNode>this.getGraphicView().getXmlEntity().getTagRoot().getChildren()[0];
                let srcValue = Number(srcchild.getAttributeValue("Height")) + 300;
                this.getGraphicView().getSrcForeginObject().setAttribute("height", SizeInfo.valueOfPX(srcValue).toString());
                let attribute = target.getAttribute("tableName");
                let sourceViews = this.getGraphicView().sourceViews;
                let sourceView = sourceViews.get(attribute!);
                if (sourceView) {
                    this.getGraphicView().setSelectSourceView(sourceView);
                    var isFirst = sourceView.getIsFirst();
                    var tableName = sourceView.getTableName();
                    let formula = "Macro_GetAllItem(" + "'" + true + "','" + isFirst + "','" + tableName  +"','" + extend + "'" + ")";
                    let menu = sourceView!.getMenu();
                    menu.addEventListener("focus", (e: any) => {
                        this.getGraphicView().getOptStateDelegate().setInputState()
                    });
                    var self = this;
                    menu.addEventListener("blur", (e: any) => {
                        // setTimeout(function () {
                            self.getGraphicView().getOptStateDelegate().setNormalState()
                        // },100)
                    });
                    this.operationDispatcher.eval(formula).then((res) => {
                        var r = res.toString();
                        let strings = r.split(";");

                        this.mune = menu;
                        for (let string of strings) {
                            let keyAndCaption = string.split(",");
                            let menuItem = menu.addMenuItem("FieldItem", keyAndCaption[1]);
                            menuItem.getDomElement().setAttr("Value", keyAndCaption[0]);
                            menu.setStyle("overflow", "auto");
                            menuItem.addEventListener(Events.MouseDown, (event: any) => {
                                let selectSourceView = this.getGraphicView().getSelectSourceView();
                                if (selectSourceView) {
                                    let tagNode = selectSourceView.getTagNode();
                                    let value = menuItem.getDomElement().getAttr("value");
                                    let keyAndValue = value!.split("|");
                                    this.getGraphicView().doAddFieldCmd(this.getGraphicView(), keyAndValue[0], keyAndValue[1], tagNode);
                                }
                                menu.hide();
                            })

                        }
                        // @ts-ignore
                        let top = target.parentElement.parentElement.offsetParent.offsetTop
                        menu.show(0, top + 60, sourceView!.getWidth().getValue(), 300, sourceView!.getEl())
                        menu.getEl().focus();
                    })
                }
            } else if (target.nodeName == "INPUT" && target.className.indexOf("inputButton") != -1) {
                let attribute = target.getAttribute("tableName");
                let sourceViews = this.getGraphicView().sourceViews;
                let sourceView = sourceViews.get(attribute!);
                if (sourceView) {
                    this.getGraphicView().setSelectSourceView(sourceView);
                    var isFirst = sourceView.getIsFirst();
                    var tableName = sourceView.getTableName();
                    let isSource = sourceView.isSource;
                    let child = <ITagNode>this.getXmlEntity().getRoot().getChildren()[1];
                    let dataMigrationKey = child.getAttributeValue("Key")
                    let formula = "Macro_ShowFieldList(" + "'" + isFirst + "','" + tableName + "','" + dataMigrationKey + "','" + isSource + "')"
                    this.operationDispatcher.eval(formula);
                }
            } else if (target.nodeName == "SPAN" && target.className.indexOf("addItemButton") != -1) {
                let attribute = target.getAttribute("tableName");
                let sourceViews = this.getGraphicView().sourceViews;
                let srcchild = <ITagNode>this.getGraphicView().getXmlEntity().getTagRoot().getChildren()[0];
                let srcValue = Number(srcchild.getAttributeValue("Height")) + 300;
                this.getGraphicView().getSrcForeginObject().setAttribute("height", SizeInfo.valueOfPX(srcValue).toString());
                let sourceView = sourceViews.get(attribute!);
                if (sourceView) {
                    let addItemButton = sourceView.getAddItemButton();
                    addItemButton!.setStyle("display", "none");
                    let addItemInput = sourceView.getAddItemInput();
                    if (addItemInput) {
                        var height = SizeInfo.valueOfPX(Number($(target).parent().height()));
                        var width = SizeInfo.valueOfPX(Number($(target).parent().width()));
                        addItemInput.setStyle("display", "block");
                        addItemInput.setStyle("width", width);
                        addItemInput.setStyle("height", "100%")
                        addItemInput.setStyle("min-height", height)
                        addItemInput.setStyle("disabled", "true");
                        setTimeout(function () {
                            addItemInput!.getEl().focus();
                        }, 10);
                    }
                    var self = this;
                    addItemInput!.removeEventListener("focus", (e: any) => {
                        self.getGraphicView().getOptStateDelegate().setInputState()
                        sourceView!.getAddIcon().setStyle("display", "none");
                        sourceView!.getInputButton()?.setStyle("display", "none");
                        self.getGraphicView().setSelectSourceView(sourceView!);
                        var isFirst = sourceView!.getIsFirst();
                        var tableName = sourceView!.getTableName();
                        let formula = "Macro_GetAllItem(" + "'" + true + "','"  + isFirst + "','" + tableName +"','" + extend + "'" + ")"
                        self.operationDispatcher.eval(formula).then((res) => {
                            var r = res.toString();
                            let strings = r.split(";");

                            let menu = sourceView!.getMenu();
                            menu.removeEventListener("blur", (e: any) => {
                                setTimeout(function () {
                                    menu.hide();
                                }, 10)
                            });
                            self.mune = menu;
                            for (let string of strings) {
                                let keyAndCaption = string.split(",");
                                let menuItem = menu.addMenuItem("FieldItem", keyAndCaption[1]);
                                menuItem.getDomElement().setAttr("Value", keyAndCaption[0]);
                                menu.setStyle("overflow", "auto");
                                menuItem.addEventListener(Events.MouseDown, (event: any) => {
                                    let selectSourceView = self.getGraphicView().getSelectSourceView();
                                    if (selectSourceView) {
                                        let tagNode = selectSourceView.getTagNode();
                                        let value = menuItem.getDomElement().getAttr("value");
                                        let keyAndValue = value!.split("|");
                                        self.getGraphicView().doAddFieldCmd(self.getGraphicView(), keyAndValue[0], keyAndValue[1], tagNode);
                                    }
                                    menu.hide();
                                })
                            }
                            // @ts-ignore
                            let top = addItemInput.getEl().parentElement.parentElement.offsetParent.offsetTop
                            menu.show(0, 60 + top, sourceView!.getWidth().getValue(), 300, <HTMLElement>addItemInput!.getEl().parentElement);
                        });
                    });
                    addItemInput!.addEventListener("focus", (e: any) => {
                        self.getGraphicView().getOptStateDelegate().setInputState()
                        sourceView!.getAddIcon().setStyle("display", "none");
                        sourceView!.getInputButton()?.setStyle("display", "none");
                        self.getGraphicView().setSelectSourceView(sourceView!);
                        var isFirst = sourceView!.getIsFirst();
                        var tableName = sourceView!.getTableName();
                        let formula = "Macro_GetAllItem(" + "'" + true + "','"  + isFirst + "','" + tableName +"','" + extend + "'" + ")"
                        self.operationDispatcher.eval(formula).then((res) => {
                            var r = res.toString();
                            let strings = r.split(";");

                            let menu = sourceView!.getMenu();
                            menu.removeEventListener("blur", (e: any) => {
                                setTimeout(function () {
                                    menu.hide();
                                }, 10)
                            });
                            self.mune = menu;
                            for (let string of strings) {
                                let keyAndCaption = string.split(",");
                                let menuItem = menu.addMenuItem("FieldItem", keyAndCaption[1]);
                                menuItem.getDomElement().setAttr("Value", keyAndCaption[0]);
                                menu.setStyle("overflow", "auto");
                                menuItem.addEventListener(Events.MouseDown, (event: any) => {
                                    let selectSourceView = self.getGraphicView().getSelectSourceView();
                                    if (selectSourceView) {
                                        let tagNode = selectSourceView.getTagNode();
                                        let value = menuItem.getDomElement().getAttr("value");
                                        let keyAndValue = value!.split("|");
                                        self.getGraphicView().doAddFieldCmd(self.getGraphicView(), keyAndValue[0], keyAndValue[1], tagNode);
                                    }
                                    menu.hide();
                                })
                            }

                            // @ts-ignore
                            let top = addItemInput.getEl().parentElement.parentElement.offsetParent.offsetTop
                            menu.show(0, 60 + top, sourceView!.getWidth().getValue(), 300, <HTMLElement>addItemInput!.getEl().parentElement);
                        });
                    });
                    addItemInput!.addEventListener("blur", (e: any) => {
                        self.getGraphicView().getOptStateDelegate().setNormalState();
                        setTimeout(function () {
                            sourceView!.getMenu().hide();
                        }, 10)
                        sourceView!.getAddIcon().setStyle("display", "block");
                        addItemInput!.setStyle("display", "none");
                        sourceView!.getInputButton()?.setStyle("display", "block");
                        addItemButton!.setStyle("display", "block");

                    });
                    addItemInput!.removeEventListener("blur", (e: any) => {
                        self.getGraphicView().getOptStateDelegate().setNormalState();
                        setTimeout(function () {
                            sourceView!.getMenu().hide();
                        }, 10)
                        sourceView!.getAddIcon().setStyle("display", "block");
                        addItemInput!.setStyle("display", "none");
                        sourceView!.getInputButton()?.setStyle("display", "block");
                        addItemButton!.setStyle("display", "block");

                    });

                    addItemInput!.addEventListener("keyup", (e: KeyUpEvent) => {
                        if (!e.ctrlKey && e.code != "ControlLeft" && e.code != "ControlRight") {
                            if (e.code != "ArrowDown" && e.code != "ArrowUp" && e.code != "ArrowLeft" && e.code != "ArrowRight") {
                                console.log("执行了清除")
                                let menu = sourceView!.getMenu();
                                menu.clearChildren();
                                var isFirst = sourceView!.getIsFirst();
                                var tableName = sourceView!.getTableName();
                                let formula = "Macro_GetAllItemByCondition(" + "'" + true + "','"  +  isFirst + "','" + tableName + "','" + e.target.value  +"','" + extend + "'" +  ")"
                                self.operationDispatcher.eval(formula).then((res) => {
                                    if (res != null) {
                                        var r = res.toString();
                                        let strings = r.split(";");
                                        menu.removeEventListener("blur", (e: any) => {
                                            setTimeout(function () {
                                                menu.hide();
                                            }, 10)
                                        });
                                        self.mune = menu;
                                        for (let string of strings) {
                                            let keyAndCaption = string.split(",");
                                            let menuItem = menu.addMenuItem("FieldItem", keyAndCaption[1]);
                                            menuItem.getDomElement().setAttr("Value", keyAndCaption[0]);
                                            menu.setStyle("overflow", "auto");
                                            menuItem.addEventListener(Events.MouseDown, (event: any) => {
                                                let selectSourceView = self.getGraphicView().getSelectSourceView();
                                                if (selectSourceView) {
                                                    let tagNode = selectSourceView.getTagNode();
                                                    let value = menuItem.getDomElement().getAttr("value");
                                                    let keyAndValue = value!.split("|");
                                                    self.getGraphicView().doAddFieldCmd(self.getGraphicView(), keyAndValue[0], keyAndValue[1], tagNode);
                                                }
                                                menu.hide();
                                            })
                                        }
                                        // @ts-ignore
                                        let top = addItemInput.getEl().parentElement.parentElement.offsetParent.offsetTop
                                        menu.show(0, 60 + top, sourceView!.getWidth().getValue(), 300, <HTMLElement>addItemInput!.getEl().parentElement);
                                    }

                                });

                            }

                        }
                    });

                }


            }
        });
    }

    /**
     * 初始化目标表点击事件
     */
    private initTargetEvent(domEl: AbstractDomElement): void {
        domEl.addEventListener('mousedown', (e: MouseEvent) => {
            var target = <HTMLElement>e.target;
            let extend = this.getGraphicView().getXmlEntity().getTagRoot().getAttributeValue(CommonConstant.ATTR_Extend);
            if (target.nodeName == "SPAN" && target.className.indexOf("selectButton") != -1) {

                let tagchild = <ITagNode>this.getGraphicView().getXmlEntity().getTagRoot().getChildren()[0];
                let tagValue = Number(tagchild.getAttributeValue("Height")) + 300;
                this.getGraphicView().getTagForeginObject()?.setAttribute("height", SizeInfo.valueOfPX(tagValue).toString())
                let attribute = target.getAttribute("tableName");
                let targetViews = this.getGraphicView().targetViews;
                let targetView = targetViews.get(attribute!);
                if (targetView) {
                    this.getGraphicView().setSelectTargetView(targetView);
                    var isFirst = targetView.getIsFirst();
                    var tableName = targetView.getTableName();
                    let formula = "Macro_GetAllItem(" + "'" + false + "','" + isFirst + "','" + tableName +"','" + extend + "'" + ")";
                    let menu = targetView!.getMenu();
                    menu.addEventListener("focus", (e: any) => {
                        this.getGraphicView().getOptStateDelegate().setInputState()
                    });
                    menu.addEventListener("blur", (e: any) => {
                        this.getGraphicView().getOptStateDelegate().setNormalState()
                    });
                    this.operationDispatcher.eval(formula).then((res) => {
                        var r = res.toString();
                        let strings = r.split(";");

                        this.mune = menu;
                        for (let string of strings) {
                            let keyAndCaption = string.split(",");
                            let menuItem = menu.addMenuItem("FieldItem", keyAndCaption[1]);
                            menuItem.getDomElement().setAttr("Value", keyAndCaption[0]);
                            menu.setStyle("overflow", "auto");
                            menuItem.addEventListener(Events.MouseDown, (event: any) => {
                                let selectTargetView = this.getGraphicView().getSelectTargetView();
                                if (selectTargetView) {
                                    let tagNode = selectTargetView.getTagNode();
                                    let value = menuItem.getDomElement().getAttr("value");
                                    let keyAndValue = value!.split("|");
                                    this.getGraphicView().doAddTargetFieldCmd(this.getGraphicView(), keyAndValue[0], keyAndValue[1], tagNode);
                                }
                                menu.hide();
                            })

                        }
                        // @ts-ignore
                        let top = target.parentElement.parentElement.offsetParent.offsetTop
                        menu.show(0, top + 60, targetView!.getWidth().getValue(), 300, targetView!.getEl())
                        menu.getEl().focus();
                    })
                }
            } else if (target.nodeName == "INPUT" && target.className.indexOf("inputButton") != -1) {
                let attribute = target.getAttribute("tableName");
                let targetViews = this.getGraphicView().targetViews;
                let targetView = targetViews.get(attribute!);
                if (targetView) {
                    this.getGraphicView().setSelectTargetView(targetView);
                    var isFirst = targetView.getIsFirst();
                    var tableName = targetView.getTableName();
                    let isSource = targetView.isSource;
                    let child = <ITagNode>this.getXmlEntity().getRoot().getChildren()[1];
                    let dataMigrationKey = child.getAttributeValue("Key")
                    let formula = "Macro_ShowFieldList(" + "'" + isFirst + "','" + tableName + "','" + dataMigrationKey + "','" + isSource + "')"
                    this.operationDispatcher.eval(formula);
                }
            } else if (target.nodeName == "SPAN" && target.className.indexOf("addItemButton") != -1) {
                let tagchild = <ITagNode>this.getGraphicView().getXmlEntity().getTagRoot().getChildren()[0];
                let tagValue = Number(tagchild.getAttributeValue("Height")) + 300;
                this.getGraphicView().getTagForeginObject()?.setAttribute("height", SizeInfo.valueOfPX(tagValue).toString())
                let attribute = target.getAttribute("tableName");
                let targetViews = this.getGraphicView().targetViews;
                let tableView = targetViews.get(attribute!);
                if (tableView) {
                    let addItemButton = tableView.getAddItemButton();
                    addItemButton!.setStyle("display", "none");
                    let addItemInput = tableView.getAddItemInput();
                    if (addItemInput) {
                        var height = SizeInfo.valueOfPX(Number($(target).parent().height()));
                        var width = SizeInfo.valueOfPX(Number($(target).parent().width()));
                        addItemInput.setStyle("display", "block");
                        addItemInput.setStyle("width", width);
                        addItemInput.setStyle("height", "100%")
                        addItemInput.setStyle("min-height", height)
                        addItemInput.setStyle("disabled", "true");
                        setTimeout(function () {
                            addItemInput!.getEl().focus();
                        }, 10);
                    }
                    var self = this;
                    addItemInput!.removeEventListener("focus", (e: any) => {
                        self.getGraphicView().getOptStateDelegate().setInputState()
                        tableView!.getAddIcon().setStyle("display", "none");
                        tableView!.getInputButton()?.setStyle("display", "none");
                        self.getGraphicView().setSelectTargetView(tableView!);
                        var isFirst = tableView!.getIsFirst();
                        var tableName = tableView!.getTableName();
                        let formula = "Macro_GetAllItem(" + "'" + false + "','" + isFirst + "','" + tableName +"','" + extend + "'" + ")"
                        self.operationDispatcher.eval(formula).then((res) => {
                            var r = res.toString();
                            let strings = r.split(";");

                            let menu = tableView!.getMenu();
                            menu.removeEventListener("blur", (e: any) => {
                                setTimeout(function () {
                                    menu.hide();
                                }, 10)
                            });
                            self.mune = menu;
                            for (let string of strings) {
                                let keyAndCaption = string.split(",");
                                let menuItem = menu.addMenuItem("FieldItem", keyAndCaption[1]);
                                menuItem.getDomElement().setAttr("Value", keyAndCaption[0]);
                                menu.setStyle("overflow", "auto");
                                menuItem.addEventListener(Events.MouseDown, (event: any) => {
                                    let selectTargetView = self.getGraphicView().getSelectTargetView();
                                    if (selectTargetView) {
                                        let tagNode = selectTargetView.getTagNode();
                                        let value = menuItem.getDomElement().getAttr("value");
                                        let keyAndValue = value!.split("|");
                                        self.getGraphicView().doAddTargetFieldCmd(self.getGraphicView(), keyAndValue[0], keyAndValue[1], tagNode);
                                    }
                                    menu.hide();
                                })
                            }
                            // @ts-ignore
                            let top = addItemInput.getEl().parentElement.parentElement.offsetParent.offsetTop
                            menu.show(0, 60 + top, tableView!.getWidth().getValue(), 300, <HTMLElement>addItemInput!.getEl().parentElement);
                        });
                    });
                    addItemInput!.addEventListener("focus", (e: any) => {
                        self.getGraphicView().getOptStateDelegate().setInputState()
                        tableView!.getAddIcon().setStyle("display", "none");
                        tableView!.getInputButton()?.setStyle("display", "none");
                        self.getGraphicView().setSelectTargetView(tableView!);
                        var isFirst = tableView!.getIsFirst();
                        var tableName = tableView!.getTableName();
                        let formula = "Macro_GetAllItem(" + "'" + false + "','" + isFirst + "','" + tableName +"','" + extend + "'" + ")"
                        self.operationDispatcher.eval(formula).then((res) => {
                            var r = res.toString();
                            let strings = r.split(";");

                            let menu = tableView!.getMenu();
                            menu.removeEventListener("blur", (e: any) => {
                                setTimeout(function () {
                                    menu.hide();
                                }, 10)
                            });
                            self.mune = menu;
                            for (let string of strings) {
                                let keyAndCaption = string.split(",");
                                let menuItem = menu.addMenuItem("FieldItem", keyAndCaption[1]);
                                menuItem.getDomElement().setAttr("Value", keyAndCaption[0]);
                                menu.setStyle("overflow", "auto");
                                menuItem.addEventListener(Events.MouseDown, (event: any) => {
                                    let selectTargetView = self.getGraphicView().getSelectTargetView();
                                    if (selectTargetView) {
                                        let tagNode = selectTargetView.getTagNode();
                                        let value = menuItem.getDomElement().getAttr("value");
                                        let keyAndValue = value!.split("|");
                                        self.getGraphicView().doAddTargetFieldCmd(self.getGraphicView(), keyAndValue[0], keyAndValue[1], tagNode);
                                    }
                                    menu.hide();
                                })
                            }

                            // @ts-ignore
                            let top = addItemInput.getEl().parentElement.parentElement.offsetParent.offsetTop
                            menu.show(0, 60 + top, tableView!.getWidth().getValue(), 300, <HTMLElement>addItemInput!.getEl().parentElement);
                        });
                    });
                    addItemInput!.addEventListener("blur", (e: any) => {
                        self.getGraphicView().getOptStateDelegate().setNormalState();
                        setTimeout(function () {
                            tableView!.getMenu().hide();
                        }, 10)
                        tableView!.getAddIcon().setStyle("display", "block");
                        addItemInput!.setStyle("display", "none");
                        tableView!.getInputButton()?.setStyle("display", "block");
                        addItemButton!.setStyle("display", "block");

                    });
                    addItemInput!.removeEventListener("blur", (e: any) => {
                        self.getGraphicView().getOptStateDelegate().setNormalState();
                        setTimeout(function () {
                            tableView!.getMenu().hide();
                        }, 10)
                        tableView!.getAddIcon().setStyle("display", "block");
                        addItemInput!.setStyle("display", "none");
                        tableView!.getInputButton()?.setStyle("display", "block");
                        addItemButton!.setStyle("display", "block");

                    });

                    addItemInput!.addEventListener("keyup", (e: KeyUpEvent) => {
                        if (!e.ctrlKey && e.code != "ControlLeft" && e.code != "ControlRight") {
                            if (e.code != "ArrowDown" && e.code != "ArrowUp" && e.code != "ArrowLeft" && e.code != "ArrowRight") {
                                console.log("执行了清除")
                                let menu = tableView!.getMenu();
                                menu.clearChildren();
                                var isFirst = tableView!.getIsFirst();
                                var tableName = tableView!.getTableName();
                                let formula = "Macro_GetAllItemByCondition(" + "'" + false + "','"  +  isFirst + "','" + tableName + "','" + e.target.value  +"','" + extend + "'" +  ")"
                                self.operationDispatcher.eval(formula).then((res) => {
                                    if (res != null) {
                                        var r = res.toString();
                                        let strings = r.split(";");
                                        menu.removeEventListener("blur", (e: any) => {
                                            setTimeout(function () {
                                                menu.hide();
                                            }, 10)
                                        });
                                        self.mune = menu;
                                        for (let string of strings) {
                                            let keyAndCaption = string.split(",");
                                            let menuItem = menu.addMenuItem("FieldItem", keyAndCaption[1]);
                                            menuItem.getDomElement().setAttr("Value", keyAndCaption[0]);
                                            menu.setStyle("overflow", "auto");
                                            menuItem.addEventListener(Events.MouseDown, (event: any) => {
                                                let selectTargetView = self.getGraphicView().getSelectTargetView();
                                                if (selectTargetView) {
                                                    let tagNode = selectTargetView.getTagNode();
                                                    let value = menuItem.getDomElement().getAttr("value");
                                                    let keyAndValue = value!.split("|");
                                                    self.getGraphicView().doAddTargetFieldCmd(self.getGraphicView(), keyAndValue[0], keyAndValue[1], tagNode);
                                                }
                                                menu.hide();
                                            })
                                        }
                                        // @ts-ignore
                                        let top = addItemInput.getEl().parentElement.parentElement.offsetParent.offsetTop
                                        menu.show(0, 60 + top, tableView!.getWidth().getValue(), 300, <HTMLElement>addItemInput!.getEl().parentElement);
                                    }

                                });

                            }

                        }
                    });

                }


            }
        });
    }


    installToolbar(toolbar: Toolbar, viewContainer: ComplexDesignView<any, any>): void {
        var btnUndo = new Button("撤销");
        //btnUndo.setTitle("快捷键 Ctrl+z");
        btnUndo.setOnClickListener((e: MouseEvent) => viewContainer.undo());
        toolbar.addItem(btnUndo);
        var btnRedo = new Button("重做");
        //btnRedo.setTitle("快捷键 Ctrl+y");
        btnRedo.setOnClickListener((e: MouseEvent) => viewContainer.redo());
        toolbar.addItem(btnRedo);
        // 分隔符
        toolbar.addSeparator();
        var btnSwitch = new Button("源码");
        btnSwitch.setOnClickListener((e: MouseEvent) => {
            viewContainer.toggleSourceVisible();
            this.getGraphicView().load(this.getXmlEntity());
            btnSwitch.setCaption(viewContainer.isSourceVisible() ? "视图" : "源码");
        });
        toolbar.addItem(btnSwitch);
    }


    protected prepareToolbar(toolbar: Toolbar): void {
        var btnSave = new Button("保存");
        btnSave.setOnClickListener((e: MouseEvent) => {
            this.save();
        });
        toolbar.addItem(btnSave);

        var btnDelete = new Button("删除");
        btnDelete.setOnClickListener((e: MouseEvent) => {
            this.delete();
        });
        toolbar.addItem(btnDelete);
        this.installToolbar(toolbar, this.viewContainer);
    }

    save(): void {
        var exp = `SaveExcel()`;
        this.operationDispatcher.eval(exp);
    }

    getCmdQueue(): CmdQueue {
        return this.viewContainer.getGraphicView().getXmlEntity().getCmdQueue();
    }


    delete(): void {
        var exp = `DeleteBpm()`;
        this.operationDispatcher.eval(exp);
    }

    eval(): void {
        var exp = `DeleteBpm()`;
        this.operationDispatcher.eval(exp);
    }

    deleteElement(): void {
        throw new Error("Method not implemented.");
    }

    private DEMO_XML: string = `<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<DataMigration Caption="物料库存余额期间迁移表" Key="MM_MSEG_MM_MaterialStorage" SrcDataObjectKey="MM_MSEG" StatusFieldKey="Status" StatusValue="Init" TgtDataObjectKey="MM_MaterialStorage" Condition="IIF(EMM_MaterialDocument.IsNoStock==1,0,IIF(EMM_MaterialDocument.Direction==1,EMM_MaterialDocument.BaseQuantity,0-EMM_MaterialDocument.BaseQuantity))" HeadCondition="IIF(EMM_MaterialDocument.IsNoStock==1,0,IIF(EMM_MaterialDocument.Direction==1,EMM_MaterialDocument.BaseQuantity,0-EMM_MaterialDocument.BaseQuantity))" Description="IIF(EMM_MaterialDocument.IsNoStock==1,0,IIF(EMM_MaterialDocument.Direction==1,EMM_MaterialDocument.BaseQuantity,0-EMM_MaterialDocument.BaseQuantity))">
    <SourceTableCollection Height="760" Width="300" X="30" Y="30">
        <SourceTable TableKey="EMM_MaterialDocumentHead" MaxKey="5">
            <SourceField Definition="ClientID" OpSign="Assign" TargetFieldKey="ClientID" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="ClientID" OpSign="Assign" TargetFieldKey="MaterialID" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="ClientID" OpSign="Assign" TargetFieldKey="ValuationTypeID" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="ClientID" OpSign="Assign" TargetFieldKey="StoragePointID" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="asiufsakdjfhiosj;;&quot;&quot;" Type="Const" Key="2" RefFieldKey="OID" TargetFieldKey="MaterialID" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="ad（asbkdjab‘’asdfsdf123）" Type="Formula" Key="3" RefFieldKey="SOID" TargetFieldKey="MaterialID" TargetTableKey="EMM_MaterialStorage" PeriodValue="Value" MapFormula="asdxshiaaajck"/>
        </SourceTable>
        <SourceTable IsPrimary="true" TableKey="EMM_MaterialDocument" MaxKey="25">
            <SourceField Definition="CompanyCodeID" OpSign="Assign" TargetFieldKey="CompanyCodeID" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="PlantID" OpSign="Assign" TargetFieldKey="PlantID" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="MaterialID" OpSign="Assign" TargetFieldKey="MaterialID" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="BaseUnitID" OpSign="Assign" TargetFieldKey="BaseUnitID" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="StorageLocationID" OpSign="Assign" TargetFieldKey="StorageLocationID" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="StockType" OpSign="Assign" TargetFieldKey="StockType" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="SpecialIdentity" OpSign="Assign" TargetFieldKey="SpecialIdentity" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="IdentityID" OpSign="Assign" TargetFieldKey="IdentityID" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="IdentityIDItemKey" OpSign="Assign" TargetFieldKey="IdentityIDItemKey" TargetTableKey="EMM_MaterialStorage"/>
            <SourceField Definition="BatchCode" OpSign="Assign" TargetFieldKey="BatchCode" TargetTableKey="EMM_MaterialStorage"/>
    </SourceTable>
    </SourceTableCollection>
    <TargetTableCollection Height="1000" Width="324" X="429" Y="59">
        <TargetTable TableKey="EMM_MaterialStorage">
            <TargetField FieldKey="ClientID"/>
            <TargetField FieldKey="MaterialID"/>
            <TargetField FieldKey="PlantID"/>
            <TargetField FieldKey="BaseUnitID"/>
            <TargetField FieldKey="StorageLocationID"/>
            <TargetField FieldKey="StockType"/>
            <TargetField FieldKey="SpecialIdentity"/>
            <TargetField FieldKey="IdentityID"/>
            <TargetField FieldKey="IdentityIDItemKey"/>
            <TargetField FieldKey="BatchCode"/>
            <TargetField FieldKey="IsBatchRestricted"/>
            <TargetField FieldKey="QuantityBalance"/>
            <TargetField FieldKey="CompanyCodeID"/>
            <TargetField FieldKey="ValuationTypeID"/>
            <TargetField FieldKey="StoragePointID"/>
        </TargetTable>
    </TargetTableCollection>
</DataMigration>
`;

    protected createPropertyIO(): IPropertyIO {
        return new DataMigrationProperty(this.getXmlEntity(), this.getGraphicView());
    }
}
