import AbstractOptStateDelegate from "../../../common/state/AbstractOptStateDelegate";
import {DataMapGraphicView} from "../view/DataMapGraphicView";
import {DataMapNormalState} from "./DataMapNormalState";
import {DataMapFieldOptState} from "./DataMapFieldOptState";
import {DataMapNewLinkState} from "./DataMapNewLinkState";
import {DataMapMoveTableState} from "./DataMapMoveTableState";
import {DataMapMoveFieldState} from "./DataMapMoveFieldState";
import InputState from "../../datamigration/state/InputState";
import DataMapInputFieldState from "./DataMapInputFieldState";

export class DataMapOptStateDelegate extends AbstractOptStateDelegate<DataMapGraphicView>{
    private normalState: DataMapNormalState;
    private fieldOptState: DataMapFieldOptState;
    private moveFieldState: DataMapMoveFieldState;
    private moveTableState: DataMapMoveTableState;
    private newLinkState: DataMapNewLinkState;
    private inputState: DataMapInputFieldState;


    constructor(view: DataMapGraphicView){
        super(view);
        this.normalState = new DataMapNormalState(this);
        this.fieldOptState = new DataMapFieldOptState(this);
        this.moveFieldState = new DataMapMoveFieldState(this);
        this.moveTableState = new DataMapMoveTableState(this);
        this.newLinkState = new DataMapNewLinkState(this);
        this.inputState = new DataMapInputFieldState(this);
        this.setInitState(this.normalState);
    }

    setFieldOptState(): void {
        this.setCurrentState(this.fieldOptState);
    }

    setNormalState(): void {
        this.setCurrentState(this.normalState);
    }

    setNewLinkState(newLinkState: DataMapNewLinkState): void {
        this.setCurrentState(newLinkState);
    }

    setMoveTableState(moveTableState: DataMapMoveTableState): void {
        this.setCurrentState(moveTableState);
    }

    setMoveFieldState(moveFieldState: DataMapMoveFieldState): void {
        this.setCurrentState(moveFieldState);
    }

    setInputFieldState(){
        this.setCurrentState(this.inputState);
    }



}