import { Item } from "../../../../common/struct/Structs";
import IGElement from "../../../../common/ui/graphic/IGElement";
import IGSection from "../../../../common/ui/graphic/IGSection";
import WfDefines from "../../base/WfDefines";

export default class GPopMenu {

    protected gSection: IGSection;

    private items: Item[] = [];

    private offsetX: number = 0;

    private offsetY: number = 0;

    constructor(gSection: IGSection, offsetX: number, offsetY: number) {
        this.gSection = gSection;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    getGSection(): IGSection {
        return this.gSection;
    }

    addItem(item: Item): IGElement {
        var gl = this.gSection.text(this.offsetX + 35 * this.items.length, 0, item.text);
        gl.attr({'fill': WfDefines.G_COLOR_STROKE_NORMAL})
        this.items.push(item);
        this.initAction(gl);
        return gl;
    }

    private initAction(gl: IGElement): void {
        gl.hover(() => gl.attr({'fill': WfDefines.G_COLOR_STROKE_HOVER}), () => gl.attr({'fill': WfDefines.G_COLOR_STROKE_NORMAL}));
    }
}