import ITagNode from "../../../../../../common/xml/node/ITagNode";
import WfConstants from "../../../../base/WfConstants";
import AbstractWfElement from "../../AbstractWfElement";
import BaseDiamondNode from "./BaseDiamondNode";

export default class GatewayNode extends BaseDiamondNode {

    constructor(xmlNode?: ITagNode) {
        super(xmlNode);
    }

    protected drawSymbo(): void{
        var pathAttr = {stroke: "#000",fill: "none", strokeWidth: 1};
        var w = this.getBounds().width;
        this.gSection.circle(w/2, w/2, w/4).attr(pathAttr);
    }

    public getType(): string {
        return WfConstants.NODE_Gateway;
    }

    public newInstance(xmlNode: ITagNode): AbstractWfElement {
        return new GatewayNode(xmlNode);
    }
}