import OperationDispatcher from "../../../common/operation/OperationDispatcher";
import SizeInfo from "../../../common/struct/SizeInfo";
import AbstractDesignView from "../../base/AbstractDesignView";
import PropertyUIContainer from "../../plugin/property/ui/PropertyUIContainer";
import WfConstants from "../base/WfConstants";
import WfDefines from "../base/WfDefines";
import WfUserPropertyDefine from "../base/WfUserPropertyDefine";
import BPMPropertyPlugin from "../property/BPMPropertyPlugin";
import ComplexDesignView from "../../base/ComplexDesignView";
import WfGraphicView from './WfGraphicView';
import Toolbar from "../../../common/component/toolbar/Toolbar";

export default class UserDesignView extends AbstractDesignView<BPMPropertyPlugin> {

    private viewContainer: ComplexDesignView<WfGraphicView, Toolbar>;

    private propertyPlugin: BPMPropertyPlugin;

    constructor(viewContainer: ComplexDesignView<WfGraphicView, Toolbar>, operationDispatcher: OperationDispatcher) {
        super(WfDefines.USER_PROPERTY_WIDTH, new PropertyUIContainer(new BPMPropertyPlugin(operationDispatcher)));
        this.viewContainer = viewContainer;
        this.propertyPlugin = this.propertyUIContainer.getPropertyPlugin();
   
        this.propertyUIContainer.setStyle('float', 'right');
        this.setCenter(viewContainer);
        this.setRight(this.propertyUIContainer);
        
        var PD = WfUserPropertyDefine.getInstance();
        this.propertyPlugin.register(WfConstants.NODE_Process, PD.getPropertyDefines(WfConstants.NODE_Process));
        this.propertyPlugin.register(WfConstants.NODE_Flow_Sequence, PD.getPropertyDefines(WfConstants.NODE_Flow_Sequence));

        this.propertyPlugin.register(WfConstants.NODE_Event_Begin, PD.getPropertyDefines(WfConstants.NODE_Event_Begin));
        this.propertyPlugin.register(WfConstants.NODE_Event_State, PD.getPropertyDefines(WfConstants.NODE_Event_State));
        this.propertyPlugin.register(WfConstants.NODE_Event_End, PD.getPropertyDefines(WfConstants.NODE_Event_End));
        this.propertyPlugin.register(WfConstants.NODE_Event_BranchEnd, PD.getPropertyDefines(WfConstants.NODE_Event_BranchEnd));
        
        this.propertyPlugin.register(WfConstants.NODE_Gateway_GateWay, PD.getPropertyDefines(WfConstants.NODE_Gateway_GateWay));
        this.propertyPlugin.register(WfConstants.NODE_Gateway_ComplexJoin, PD.getPropertyDefines(WfConstants.NODE_Gateway_ComplexJoin));
        this.propertyPlugin.register(WfConstants.NODE_Gateway_Decision, PD.getPropertyDefines(WfConstants.NODE_Gateway_Decision));
        this.propertyPlugin.register(WfConstants.NODE_Gateway_ExclusiveFork, PD.getPropertyDefines(WfConstants.NODE_Gateway_ExclusiveFork));
        this.propertyPlugin.register(WfConstants.NODE_Gateway_Fork, PD.getPropertyDefines(WfConstants.NODE_Gateway_Fork));
        this.propertyPlugin.register(WfConstants.NODE_Gateway_Join, PD.getPropertyDefines(WfConstants.NODE_Gateway_Join));

        this.propertyPlugin.register(WfConstants.NODE_Task_Audit, PD.getPropertyDefines(WfConstants.NODE_Task_Audit));
        this.propertyPlugin.register(WfConstants.NODE_Task_Service, PD.getPropertyDefines(WfConstants.NODE_Task_Service));
        this.propertyPlugin.register(WfConstants.NODE_Task_Manual, PD.getPropertyDefines(WfConstants.NODE_Task_Manual));
        this.propertyPlugin.register(WfConstants.NODE_Task_User, PD.getPropertyDefines(WfConstants.NODE_Task_User));
        this.propertyPlugin.register(WfConstants.NODE_Task_DataMap, PD.getPropertyDefines(WfConstants.NODE_Task_DataMap));
        this.propertyPlugin.register(WfConstants.NODE_Task_CounterSign, PD.getPropertyDefines(WfConstants.NODE_Task_CounterSign));
        this.propertyPlugin.register(WfConstants.NODE_Task_MultiUser, PD.getPropertyDefines(WfConstants.NODE_Task_MultiUser));
        this.propertyPlugin.register(WfConstants.NODE_Task_MultiAudit, PD.getPropertyDefines(WfConstants.NODE_Task_MultiAudit));
        this.propertyPlugin.register(WfConstants.NODE_Task_StateAction, PD.getPropertyDefines(WfConstants.NODE_Task_StateAction));

        this.propertyPlugin.register(WfConstants.NODE_SubProcess, PD.getPropertyDefines(WfConstants.NODE_SubProcess));
        this.propertyPlugin.register(WfConstants.NODE_Inline, PD.getPropertyDefines(WfConstants.NODE_Inline));
    }

    resize(parentWidth: number, parentHeight: number) {
        var width = parentWidth -  WfDefines.USER_PROPERTY_WIDTH;
        this.viewContainer.resize(width, parentHeight);
        this.propertyUIContainer.setHeight(SizeInfo.valueOfPX(parentHeight));
    }

}