import ArrayList from "../../../common/struct/ArrayList";
import IGElement from "../../../common/ui/graphic/IGElement";
import WfDefines from "../base/WfDefines";
import AbstractWfElement from "../view/element/AbstractWfElement";
import WfGraphicView from "../view/WfGraphicView";
import AbstractWfOptState from "./AbstractWfOptState";
import OptStateDelegate from "./OptStateDelegate";

export default class NormalState extends AbstractWfOptState {

    private offsetX = 0;
    private offsetY = 0;

    private dragVirtuals: ArrayList<IGElement> = new ArrayList<IGElement>();

    constructor(view: WfGraphicView, delegate: OptStateDelegate) {
        super(view, delegate);
    }

    dragstart(x: number, y: number, event: MouseEvent): void {
        this.offsetX = 0;
        this.offsetY = 0;
        var selectItems = this.view.getSelectionModel().getSelectionItems();
        for (let item of selectItems) {
            var node = this.view.findElement(item.getTagNode());
            if (node instanceof AbstractWfElement) {
                var wfNode = <AbstractWfElement> node;
                var bound = wfNode.getBounds()
                var rect = this.view.getPaper().rect(bound.x, bound.y, bound.width, bound.height, WfDefines.G_RECT_R);
                rect.attr({
                    fill: 'none',
                    stroke: '#0095ff',
                    'fill-opacity': '0.1',
                    'strokeWidth': 1
                });
                this.dragVirtuals.add(rect);
            }
        }
    }

    dragmove(dx: number, dy: number, x: number, y: number, event: MouseEvent): void {
        if (Math.abs(dx) < 1 || Math.abs(dy) < 1) {
            return;
        }
        this.offsetX = dx;
        this.offsetY = dy;
        this.view.drawDragVirtual(this.dragVirtuals.getList(), dx, dy);
    }

    dragend(event: MouseEvent): void {
        if (Math.abs(this.offsetX) < 1 && Math.abs(this.offsetY) < 1) return;
        
        this.view.doMoveNodeCmd(this.offsetX, this.offsetY);
        this.reset();
    }

    mousedown(e: MouseEvent): void {
        var el = <HTMLElement> e.target;
        var node = this.view.hitHtmlElement(el);
        this.view.unSelectAllDenyFlows();
        this.view.getSelectionModel().select(node?.getTagNode());
    }

    mousemove(e: MouseEvent): void {
        // throw new Error("Method not implemented.");
    }
    
    mouseup(e: MouseEvent): void {
        this.reset();
    }

    reset() {
        for(let elem of this.dragVirtuals.getList()) {
            elem.remove();
        }
        this.dragVirtuals.clearAll();
    }
}
