import GlobalConstants from "../../../common/struct/GlobalConstants";
import TagNode from "../../../common/xml/node/TagNode";

/**
 * 适用于用户模式下的节点
 */
export class UserTagNode extends TagNode {
    constructor(tagName: string, isUserDefine: boolean) {
        super(tagName);
        isUserDefine && this.setAttributeValue(GlobalConstants.S_IsUserDefine, 'true');
    }
}

export class DictionaryTagNode extends UserTagNode {
    constructor(itemKey: string, isUserDefine: boolean = true) {
        super(GlobalConstants.S_Dictionary, isUserDefine);
        this.setAttributeValue(GlobalConstants.S_ItemKey, itemKey);
    }

    addCode(code: string) {
        var curValue = this.getAttributeValue(GlobalConstants.S_Code);
        this.setAttributeValue(GlobalConstants.S_Code, curValue ? `${curValue}:${code}` : code);
    }

    hasData() {
        return !!this.getAttributeValue(GlobalConstants.S_Code);
    }
}

export class FormulaTagNode extends UserTagNode {
    constructor(tagName: string, key: string, isUserDefine: boolean = true) {
        super(tagName, isUserDefine);
        this.setAttributeValue(GlobalConstants.S_Key, key);
    }

    setFormula(formula: string) {
        this.setCDATAValue(formula);
    }
}


export class OperationTagNode extends UserTagNode {
    constructor(key: string, caption: string, isUserDefine: boolean = true) {
        super(GlobalConstants.S_Operation, isUserDefine);
        this.setAttributeValue(GlobalConstants.S_Key, key);
        this.setAttributeValue(GlobalConstants.S_Caption, caption);
    }

    setAction(action: string) {
        this.clearChildren();
        var actionTag = new ActionTagNode(action);
        this.addChild(actionTag);
    }
}

export class ActionTagNode extends TagNode {
    constructor(action: string) {
        super(GlobalConstants.S_Action);
        this.setCDATAValue(action);
    }
}
