import WfConstants from "./WfConstants";

export default class SVG {

    private static map: Map<string, string> = new Map([
        [WfConstants.NODE_Gateway_GateWay, `<svg viewBox="0 0 70 70" style="padding-left: 8px; padding-top: 8px">
                                                <g style="stroke-width: 1;">
                                                    <polygon points="0,25,25,0,50,25,25,50,0,25" style="fill-opacity: 0.1;"/>
                                                    <circle cx="25" cy="25" r="12.5"/>
                                                </g>
                                            </svg>`],
        [WfConstants.NODE_Gateway_Decision, `<svg viewBox="0 0 70 70" style="padding-left: 8px; padding-top: 8px">
                                                <g style="stroke-width: 1;">
                                                    <polygon points="0,25,25,0,50,25,25,50,0,25" style="fill-opacity: 0.1;"/>
                                                    <text x="25" y="30" style="text-anchor: middle; font-weight: bold; font-size: 20px;">?</text>
                                                </g>
                                            </svg>`],
        [WfConstants.NODE_Gateway_Join, `<svg viewBox="0 0 70 70" style="padding-left: 8px; padding-top: 8px">
                                            <g style="stroke-width: 1;">
                                                <polygon points="0,25,25,0,50,25,25,50,0,25" style="fill-opacity: 0.1;"/>
                                                <path d="M10 25L40 25"/>
                                                <path d="M20 35L31 25"/>
                                                <path d="M20 15L31 25"/>
                                            </g>
                                        </svg>`],
        [WfConstants.NODE_Gateway_Fork, `<svg viewBox="0 0 70 70" style="padding-left: 8px; padding-top: 8px">
                                            <g style="stroke-width: 1;">
                                                <polygon points="0,25,25,0,50,25,25,50,0,25" style="fill-opacity: 0.1;"/>
                                                <path d="M10 25L40 25"/>
                                                <path d="M30 35L19 25"/>
                                                <path d="M30 15L19 25"/>
                                            </g>
                                        </svg>`],
        [WfConstants.NODE_Gateway_ExclusiveFork, `<svg viewBox="0 0 70 70" style="padding-left: 8px; padding-top: 8px">
                                                        <g style="stroke-width: 1;">
                                                            <polygon points="0,25,25,0,50,25,25,50,0,25" style="fill-opacity: 0.1;"/>
                                                            <path d="M20 20L30 30"/>
                                                            <path d="M20 30L30 20"/>
                                                        </g>
                                                    </svg>`],
        [WfConstants.NODE_Gateway_ComplexJoin, `<svg viewBox="0 0 70 70" style="padding-left: 8px; padding-top: 8px">
                                                    <g style="stroke-width: 1;">
                                                        <polygon points="0,25,25,0,50,25,25,50,0,25" style="fill-opacity: 0.1;"/>
                                                        <path d="M20 20L30 30"/>
                                                        <path d="M20 30L30 20"/>
                                                        <path d="M18 25L32 25"/>
                                                        <path d="M25 18L25 32"/>
                                                    </g>
                                                </svg>`]


    ]);

    public static get(key: string): string {
        var v = SVG.map.get(key);
        if (!v) return key;
        return v;
    }
}
