import ActionNames from "../../../common/event/ActionNames";
import GlobalConstants from "../../../common/struct/GlobalConstants";
import WfConstants from "./WfConstants";

export default class I18N {

    private static map: Map<string, string> = new Map([
        [WfConstants.NODE_Process, WfConstants.C_Process],

        [WfConstants.NODE_Hand, WfConstants.C_Hand],
        [WfConstants.NODE_Flow_Sequence, WfConstants.C_Flow_Sequence],

        [WfConstants.NODE_Event_Begin, WfConstants.C_Event_Begin],
        [WfConstants.NODE_Event_BranchEnd, WfConstants.C_Event_BranchEnd],
        [WfConstants.NODE_Event_End, WfConstants.C_Event_End],
        [WfConstants.NODE_Event_State, WfConstants.C_Event_State],

        [WfConstants.NODE_Gateway, WfConstants.C_Gateway],
        [WfConstants.NODE_Gateway_GateWay, WfConstants.C_Gateway_GateWay],
        [WfConstants.NODE_Gateway_Decision, WfConstants.C_Gateway_Decision],
        [WfConstants.NODE_Gateway_Join, WfConstants.C_Gateway_Join],
        [WfConstants.NODE_Gateway_Fork, WfConstants.C_Gateway_Fork],
        [WfConstants.NODE_Gateway_ExclusiveFork, WfConstants.C_Gateway_ExclusiveFork],
        [WfConstants.NODE_Gateway_ComplexJoin, WfConstants.C_Gateway_ComplexJoin],

        [WfConstants.NODE_Task, WfConstants.C_Task],
        [WfConstants.NODE_Task_Audit, WfConstants.C_Task_Audit],
        [WfConstants.NODE_Task_Service, WfConstants.C_Task_Service],
        [WfConstants.NODE_Task_Manual, WfConstants.C_Task_Manual],
        [WfConstants.NODE_Task_User, WfConstants.C_Task_User],
        [WfConstants.NODE_Task_DataMap, WfConstants.C_Task_DataMap],
        [WfConstants.NODE_Task_CounterSign, WfConstants.C_Task_CounterSign],
        [WfConstants.NODE_Task_MultiUser, WfConstants.C_Task_MultiUser],
        [WfConstants.NODE_Task_StateAction, WfConstants.C_Task_StateAction],
        [WfConstants.NODE_Task_MultiAudit, WfConstants.C_Task_MultiAudit],

        [WfConstants.NODE_SubProcess, WfConstants.C_SubProcess],
        [WfConstants.NODE_Inline, WfConstants.C_Inline],

        [ActionNames.model_node_remove, WfConstants.C_Remove],

        [GlobalConstants.S_TRUE, '是'],
        [GlobalConstants.S_FALSE, '否']
    ]);

    public static register(key: string, text: string) {
        I18N.map.set(key, text);
    }

    public static getString(key: string): string {
        var v = I18N.map.get(key);
        if (!v)  {
            v = I18N.map.get(key.toLowerCase());
            if (!v) {
                return key;
            }
        }
        return v;
    }
}