import { ENodeType } from "../../enum/Enums";
import Var from "../../struct/Var";
import StringBuilder from "../../util/StringBuilder";
import IXmlNodeVisitor from "../IXmlNodeVisitor";
import INodeOutput from "../output/INodeOutput";
import ITagNode from "./ITagNode";

export default interface INode {

	setParent(parent: ITagNode): void;

	getParent(): ITagNode | undefined;

	findNodeByLine(line: number): INode | null;

	getStartLine(): number;

	getEndLine(): number;

	setContent(content: string): void;
	
	getContent(): string;

 	getNodeType(): ENodeType;

	accept(visitor: IXmlNodeVisitor): void;

	writeXml(level: number, sb: StringBuilder, bSimple: boolean): boolean;

	writeJSON(sb: StringBuilder): void;

	outputLevel(level: number, outputHandler: INodeOutput): void;

	getMaxNodeID(): number;

	resetLineIndex(varIndex: Var<number>): void;
	
}
