import GBox from "./GBox";

export default interface IGElement {
    /**
     * 获取第三方节点对象
     */
    getGNode(): any;

    add(el:IGElement): IGElement;

    remove(): IGElement;

    transformTo(x: number, y: number): IGElement;

    transform(a:number,x?:number,y?:number):IGElement;

    attr(params:{[attr:string]:string|number|boolean|any}):IGElement;

    click(handler: (event: MouseEvent) => void, thisArg?: any): IGElement;
    dblclick(handler: (event: MouseEvent) => void, thisArg?: any): IGElement;
    mousedown(handler: (event: MouseEvent) => void, thisArg?: any): IGElement;
    mousemove(handler: (event: MouseEvent) => void, thisArg?: any): IGElement;
    mouseout(handler: (event: MouseEvent) => void, thisArg?: any): IGElement;
    mouseover(handler: (event: MouseEvent) => void, thisArg?: any): IGElement;
    mouseup(handler: (event: MouseEvent) => void, thisArg?: any): IGElement;
    touchstart(handler: (event: MouseEvent) => void, thisArg?: any): IGElement;
    touchmove(handler: (event: MouseEvent) => void, thisArg?: any): IGElement;
    touchend(handler: (event: MouseEvent) => void, thisArg?: any): IGElement;
    touchcancel(handler: (event: MouseEvent) => void, thisArg?: any): IGElement;

    hover(hoverInHandler: (event: MouseEvent) => void, hoverOutHandler: (event: MouseEvent) => void, inThisArg?: any, outThisArg?: any): IGElement;

    drag():IGElement;

    drag(onMove:  (dx: number, dy: number, x: number, y: number, event: MouseEvent) => void,
         onStart: (x: number, y: number, event: MouseEvent) => void,
         onEnd:   (event: MouseEvent) => void,
         moveThisArg?: any,
         startThisArg?: any,
         endThisArg?: any):IGElement;

    getBBox(): GBox;

    getHtmlElement(): HTMLElement;

    getChildren(): IGElement[];

    setVisiable(visible: boolean): void;

    isVisiable(): boolean;

}