import BaseStyleFactory from "./BaseStyleFactory";
import IStyleFactory from "./IStyleFactory";

export default class StyleFactoryMananger {

    private styleFactory: IStyleFactory = new BaseStyleFactory();

    private static instance: StyleFactoryMananger = new StyleFactoryMananger();
    
    public getStyleFactory(): IStyleFactory {
        return this.styleFactory;
    }

    public static getInstance(): StyleFactoryMananger {
        return StyleFactoryMananger.instance;
    }
}