
/**
 * 列表对象
 * for (let child of this.children.getList()) {
 * }
 */
export default class ArrayList<T> {

    private items: T[];

    constructor() {
        this.items = [];
    }

    public add(item: T) {
        this.items.push(item);
    }

    public get(index: number): T {
        if (index < 0 || index > this.items.length - 1) {
            throw new Error(index + " out range:" + this.items.length);
        }
        return this.items[index];
    }

    public clearAll(): void {
        this.items = [];
    }

    public contain(item: T): boolean {
        return this.items.indexOf(item) > -1;
    }

    public getList(): T[] {
        return this.items;
    }

    /**
     * 返回删除元素所在位置
     * @param item 
     */
    public remove(item: T): number {
        var index = this.items.indexOf(item); 
        if (index>= 0) { 
            this.items.splice(index, 1); 
        }
        return index;
    }

    public removeByIndex(index: number): void {
        this.items.splice(index, 1); 
    }

    public getSize(): number {
        return this.items.length;
    }
}