import AbstractControl from "../component/control/AbstractControl";
import { EDesignMode } from "../enum/Enums";
import IWorkSpace from "../workspace/IWorkSpace";
import BaseOperationExecutor from "./BaseOperationExecutor";
import IOperatioExecutor from "./IOperatioExecutor";

/**
 * 操作行为派发
 * 
 */

export default class OperationDispatcher implements IOperatioExecutor {

    private curExecutor: IOperatioExecutor;

    constructor() {
        this.curExecutor = new BaseOperationExecutor();
    }
    getMode(): EDesignMode {
        return this.curExecutor.getMode();
    }

    createYigoControl(key: string, type: string, component: any): AbstractControl<any> {
        return this.curExecutor.createYigoControl(key, type, component);
    }

    isDevFormulaID(devFormulaID: number): boolean {
        return this.curExecutor.isDevFormulaID(devFormulaID);
    }

    async queryDictID(dictKey: string, code: string): Promise<number> {
        return await this.curExecutor.queryDictID(dictKey, code);
    }

    async queryFormulaDictName(dictID: number): Promise<string> {
        return await this.curExecutor.queryFormulaDictName(dictID);
    }

    async queryFormulaDictID(code: string): Promise<number> {
        return await this.curExecutor.queryFormulaDictID(code);
    }

    setExecutor(executor: IOperatioExecutor): void {
        this.curExecutor = executor;
    }

    setEditable(b: boolean): void {
        this.curExecutor.setEditable(b);
    }

    isEditable(): boolean {
        return this.curExecutor.isEditable();
    }

    getForm(): any {
        return this.curExecutor.getForm();
    }

    getComponent(key: string): any {
        return this.curExecutor.getComponent(key);
    }

    async eval(exp: string): Promise<any> {
        if (exp == null || exp == undefined) return null;
        if (exp.toUpperCase() == 'TRUE') return true;
        if (exp.toUpperCase() == 'FALSE') return false;

        return await this.curExecutor.eval(exp);
    }

    async asyncEval(exp: string): Promise<any> {
        if (exp == null || exp == undefined) return null;
        if (exp.toUpperCase() == 'TRUE') return true;
        if (exp.toUpperCase() == 'FALSE') return false;

        return await this.curExecutor.asyncEval(exp);
    }

    create(): void {
        this.curExecutor.create();
    }

    save(xml: string): void {
        this.curExecutor.save(xml);
    }

    load(xml: string): void {
        this.curExecutor.load(xml);
    }

    delete(): void {
        this.curExecutor.delete();
    }

}