import { IPropertyContainer, IPropertyIO } from "../../design/plugin/property/base/PropertyDefine";
import { ISelectionChangedListener} from "../dom/listener/Listeners";
import ISelectable from "../selection/ISelectable";

export default class SelectionChangeListener implements ISelectionChangedListener {

    private propertyContainer: IPropertyContainer<any>;

    private propertyIO: IPropertyIO;

    constructor(propertyContainer: IPropertyContainer<any>, propertyIO: IPropertyIO) {
        this.propertyContainer = propertyContainer;
        this.propertyIO = propertyIO;
    }

    changeSelection(selectable: ISelectable): void {
        if (!selectable.isSelected()) return;
        var propertyUIContainer = this.propertyContainer.getPropertyUIContainer();
        var propertyPlugin = propertyUIContainer.getPropertyPlugin();
        propertyPlugin.commit();
        this.propertyIO.prepare(selectable);
        propertyPlugin.display(this.propertyIO.getTagName(), this.propertyIO, propertyUIContainer.getEl());
    }
}