import EventHub from "./EventHub";

export default class EventManager {

    private static instance: EventManager = new EventManager();

    private hub: EventHub<any> = new EventHub();

    constructor() {
    }

    register(key: string, fn: any): void {
        this.hub.on(key, fn);
    }

    emit(key: string | undefined): any {
        if (!key) return undefined;
        return this.hub.emit(key, undefined);
    }

    public static getInstance(): EventManager {
        return EventManager.instance;
    }
}