import IXElement from "../IXElement";

export default class HtmlXElement implements IXElement {

    private htmlElement: HTMLElement | any;

    constructor(data: string | Element) {
        if (data instanceof Element) {
            this.htmlElement = data;
        } else {
            this.htmlElement = document.createElement(data);
        }
    }

    click(): void {
        this.getHtmlElement().click();
    }

    getHtmlElement(): HTMLElement {
        return this.htmlElement;
    }

    setInnerText(text: string): void {
        this.htmlElement.innerText = text;
    }

    getInnerText(): string {
        return this.htmlElement.innerText;
    }

    setAttribute(name: string, value: any): void {
        this.htmlElement.setAttribute(name, value);
    }
    getAttribute(name: string): any {
        return this.htmlElement.getAttribute(name);
    }
    
    removeAttribute(name: string): void {
        this.getHtmlElement().removeAttribute(name);
    }

    setStyle(key: any, value: any): void {
        this.htmlElement.style[key] = value;
    }

    addClass(cls: string): void {
        this.htmlElement.classList.add(cls);
    }

    removeClass(cls: string): void {
        this.htmlElement.classList.remove(cls);
    }

    toggleClass(cls: string): void {
        this.htmlElement.classList.toggle(cls);
    }  

    hasClass(cls: string): boolean {
        return this.htmlElement.classList.contains(cls);
    }

    contains(child: IXElement): boolean {
        return this.htmlElement.contains(child.getHtmlElement());
    }

    appendChild(child: IXElement): void {
        this.getHtmlElement().appendChild(child.getHtmlElement());
    }

    appendTo(parent: IXElement): void {
        parent.getHtmlElement().appendChild(this.getHtmlElement());
    }

    removeChild(child: IXElement): void {
        this.htmlElement.removeChild(child.getHtmlElement());
    }

    addEventListener(name: string, fun: any, useCapture: boolean): void {
        this.htmlElement.addEventListener(name, fun, useCapture);
    }

    removeEventListener(name: string, fun: any, useCapture: boolean): void {
        this.htmlElement.removeEventListener(name, fun, useCapture);
    }

    blur(): void {
        this.htmlElement.blur();
    }

    parentEl(): IXElement | null {
        if (!this.htmlElement.parentElement) return null;
        return new HtmlXElement(this.htmlElement.parentElement);
    }

    focus(): void {
        this.htmlElement.focus();
    }
    
    getImpl(): HTMLElement {
        return this.htmlElement;
    }

    getScrollTop(): number {
        return this.getHtmlElement().scrollTop;
    }

    setScrollTop(top: number): void {
        this.getHtmlElement().scrollTop = top;
    }

    getScrollLeft(): number {
        return this.getHtmlElement().scrollLeft;
    }

    setScrollLeft(left: number): void {
        this.getHtmlElement().scrollLeft = left;
    }

    getNodeType(): number {
        return this.getHtmlElement().nodeType;
    }

    getOffsetLeft(): number {
        return this.getHtmlElement().offsetLeft;
    }
    
    getOffsetTop(): number {
        return this.getHtmlElement().offsetTop;
    }

    getHtmlClientHeight(): number {
        return this.getHtmlElement().clientHeight;
    }

    getHtmlClientWidth(): number {
        return this.getHtmlElement().clientWidth;
    }

    getHtmlOffsetWidth(): number {
        return this.getHtmlElement().offsetWidth;
    }

    getBoundingClientRect(): any {
        return this.getHtmlElement().getBoundingClientRect();
    }

    setOncontextmenu(fn: any): void {
        this.getHtmlElement().oncontextmenu = fn;
    }

    getChildren(): [] {
        var children: any = [];
        var len = this.getHtmlElement().childNodes.length;
        for (var i=0; i < len; i++){
            var child = <HTMLElement>this.getHtmlElement().childNodes[i];
            children.push(new HtmlXElement(child))

        }
        return children;
    }
}