import AbstractDomElement from "../AbstractDomElement";

export default class InputElement extends AbstractDomElement {
    
    protected createEl(): HTMLElement {
        return document.createElement('input');
    }

    getValue(): string {
        var input: HTMLInputElement = <HTMLInputElement> this.getEl();
        return input.value;
    }

    setValue(value: string) {
        var input: HTMLInputElement = <HTMLInputElement> this.getEl();
        input.value = value;
    }

    setPlaceholder(placehoder: string): void {
        var input: HTMLInputElement = <HTMLInputElement> this.getEl();
        input.placeholder = placehoder;
    }
}