import { EComponentType } from "../component/EComponentType";
import { XMLElementType } from "../enum/Enums";

export default class PropertyDefine {

    private key: string;

    private caption: string = "";

    private control: string;

    private onbuttonclick: string = "";

    private editable: string = 'true';

    private visible: string = 'true';

    private oninitialize: string = "";

    private onvaluechanged: string = "";

    private defaultValue: string = "";

    private group: string = "";

    private node: string = "";

    private textAttributeKey: string = "";

    private bUpdateAttributeOnly = false;

    private elementType: string = XMLElementType.ATTRIBUTE;

    constructor(key: string, control: string = EComponentType.TextEditor) {
        this.key = key;
        this.control = control;
    }

    getKey(): string {
        return this.key;
    }

    setCaption(caption: string): void {
        this.caption = caption;
    }

    getCaption(): string {
        return this.caption;
    }

    setXmlElementType(elementType: string): void {
        if (elementType) {
            this.elementType = elementType;
        }
    }

    getXmlElementType(): string {
        return this.elementType;
    }

    setNode(node: string): void {
        this.node = node;
    }

    getNode(): string {
        return this.node;
    }

    setControlType(control: string): void {
        this.control = control;
    }

    getControlType(): string {
        return this.control;
    }

    setUpdateAttributeOnly(bUpdateAttributeOnly: boolean): void {
        this.bUpdateAttributeOnly = bUpdateAttributeOnly;
    }

    isUpdateAttributeOnly(): boolean {
        return this.bUpdateAttributeOnly;
    }

    getTextAttributeKey(): string {
        return this.textAttributeKey;
    }

    setTextAttributeKey(textAttributeKey: string): void {
        this.textAttributeKey = textAttributeKey;
    }

    setOnButtonClick(event: string): void {
        this.onbuttonclick = event;
    }

    getOnButtonClick(): string {
        return this.onbuttonclick;
    }

    setEditable(editable: string): void {
        this.editable = editable;
    }

    getEditable(): string {
        return this.editable;
    }

    setVisible(visible: string): void {
        this.visible = visible;
    }

    getVisible(): string {
        return this.visible;
    }

    setDefaultValue(defaultValue: string): void {
        this.defaultValue = defaultValue;
    }

    getDefaultValue(): string {
        return this.defaultValue;
    }

    setOnInitialize(oninitialize: string): void {
        this.oninitialize = oninitialize;
    }

    getOnInitialize(): string {
        return this.oninitialize;
    }

    setOnValueChanged(onvaluechanged: string): void {
        this.onvaluechanged = onvaluechanged;
    }

    getOnValueChanged(): string {
        return this.onvaluechanged;
    }

    setGroup(group: string) {
        this.group = group;
    }

    getGroup(): string {
        return this.group;
    }

}