/* package com.vico.vicosoft.client.base.ui.component.grid.column;

import com.vico.vicosoft.client.base.ui.component.grid.config.GridRowConfig;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

import java.util.ArrayList;
import java.util.List;

public class GridColumn {

    private GridColumn parent = null;

    private List<GridColumn> childColumns = null;

    private String key, caption;

    private IntegerProperty widthProperty;

    private int height = GridRowConfig.DEFAULT_ROW_HEIGHT;
    
    private int row = 0;
    private int col = 0;
    private int rowSpan = 1;
    private int colSpan = 1;

    public GridColumn() {
        this.childColumns = new ArrayList<>();
    }

    private void setParentColumn(GridColumn parent) {
        this.parent = parent;
    }
    
    public GridColumn getParentColumn() {
    	return this.parent;
    }

    public GridColumn addChildColumn() {
        GridColumn newGridColumn = new GridColumn();
        newGridColumn.setParentColumn(this);
        this.childColumns.add(newGridColumn);
        return newGridColumn;
    }

    public boolean hasChildColumn() {
        return this.childColumns.size() > 0;
    }

    public List<GridColumn> getChildColumns() {
        return this.childColumns;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setRow(int row) {
    	this.row = row;
    }
    
    public int getRow() {
    	return this.row;
    }
    
    public void setCol(int col) {
    	this.col = col;
    }
    
    public int getCol() {
    	return this.col;
    }
    
    public void setRowSpan(int rowSpan) {
    	this.rowSpan = rowSpan;
    }
    
    public int getRowSpan() {
    	return this.rowSpan;
    }
    
    public void setColSpan(int colSpan) {
    	this.colSpan = colSpan;
    }
    
    public int getColSpan() {
    	return this.colSpan;
    }


    public void setWidth(int width) {
        widthProperty().set(width);
    }

    private int _getWidth() {
        if (this.widthProperty == null) {
            return 0;
        }
        return widthProperty.get();
    }

    public IntegerProperty widthProperty() {
        if (widthProperty == null) {
            this.widthProperty = new SimpleIntegerProperty(0);
        }
        return this.widthProperty;
    }

    public int getWidth() {
        if (!this.hasChildColumn()) return this._getWidth();
        int totalWidth = 0;
        for (GridColumn child : this.childColumns) {
            totalWidth += child.getWidth();
        }
        return totalWidth;
    }

     // 获取所有叶子节点
    
    public List<GridColumn> getLeafColumns() {
        ArrayList<GridColumn> leafColumns = new ArrayList<>();
        if (!this.hasChildColumn()) {
            leafColumns.add(this);
        } else {
            for (GridColumn child: this.getChildColumns()) {
                List<GridColumn> childLeafs = child.getLeafColumns();
                leafColumns.addAll(childLeafs);
            }
        }
        return leafColumns;
    }

    public int getLeafCount() {
        if (!this.hasChildColumn()) {
            return 1;
        }
        int count = 0;
        for (GridColumn child: this.getChildColumns()) {
            count += child.getLeafCount();
        }
        return count;
    }

    public int getDeep() {
        if (!this.hasChildColumn()) {
            return 1;
        }
        int tmpDeep = 0;
        for (GridColumn child : this.getChildColumns()) {
            tmpDeep = Math.max(tmpDeep, child.getDeep() + 1);
        }
        return tmpDeep;
    }
}
 */