import ArrayList from "../../../../struct/ArrayList";
import SizeInfo from "../../../../struct/SizeInfo";
import { ESizeType } from "../../../../enum/Enums";


export default class ColumnConfig {
    
    public static DEFAULT_COLUMN_WIDTH: SizeInfo = SizeInfo.valueOf(120, ESizeType.px);

    private width: SizeInfo = ColumnConfig.DEFAULT_COLUMN_WIDTH;

    private key: string;

    private caption: string;

    private listChildColumns: ArrayList<ColumnConfig> | null = null;

    constructor(key: string, caption?: string) {
        this.key = key;
        this.caption = caption ? caption : key;
    }

    public getKey(): string {
        return this.key;
    }

    public setCaption(caption: string) {
        this.caption = caption;
    }

    public getCaption(): string {
        return this.caption;
    }

    public setWidth(width: SizeInfo) {
        this.width = width;
    }

    public getWidth(): SizeInfo {
        return this.width;
    }

    public getChildColumns(): ColumnConfig[] {
        return this.listChildColumns == null ? [] : this.listChildColumns.getList();
    }

    public addChildColumn(key: string, caption?: string): ColumnConfig {
        if (this.listChildColumns == null) {
            this.listChildColumns = new ArrayList<ColumnConfig>();
        }
        var childColumn = new ColumnConfig(key, caption);
        this.listChildColumns.add(childColumn);
        return childColumn;
    }

    public hasChildren(): boolean {
        return this.listChildColumns != null && this.listChildColumns.getSize() > 0;
    }
}