import DivElement from "../../dom/element/DivElement";
import LiElement from "../../dom/element/LiElement";
import UlElement from "../../dom/element/UlElement";
import { IClickListener } from "../../dom/listener/Listeners";
import Events from "../../event/Events";
import { IItemData } from "../../struct/DataStruct";
import TypeUtil from "../../util/TypeUtil";
import ControlFactory from "../factory/ControlFactory";
import JComponent from "../JComponent";
import IControlMeta from "../meta/IControlMeta";
import IListMeta from "../meta/IListMeta";

/**
 * 列表控件
 */
export default class JList extends JComponent<DivElement> {

    private clickListener: IClickListener<IItemData> | undefined;

    private metaControl: IControlMeta;

    private listData: IItemData[] = [];

    private ulElement: UlElement;

    constructor(meta: IListMeta) {
        super(new DivElement());
        this.metaControl = meta.control;
        this.ulElement = new UlElement();
        this.getDomElement().addChild(this.ulElement);
        this.addClassArray(this.styleFactory.getList());
        this.setStyle("overflow", "auto");
    }

    setOnClickListener(clickListener: IClickListener<IItemData>): void {
        this.clickListener = clickListener;
    }

    addItem(data: IItemData): void {
        this.listData.push(data);
    }

    clear(): void {
        this.listData = [];
        this.updateUI();
    }

    updateUI(): void {
        this.ulElement.clearChildren();
        var index = 0;
        for (let item of this.listData) {
            var liElement = new LiElement();
            this.ulElement.addChild(liElement);
            var control = ControlFactory.createControl(this.metaControl.type);
            control.setValue(item.data);
            control.setText(item.caption ? item.caption : item.data);
            control.getDomElement().setAttr('index', index);
            liElement.addChild(control.getDomElement());

            control.addEventListener(Events.Click, (e: any) => {
                var target = <HTMLElement> e.target;
                var index = target.getAttribute('index');
                if (index != undefined && index != null) {
                    var idx = TypeUtil.toNum(index);
                    idx >= 0 && this.fireItemClickEvent(this.listData[idx]);
                }
            }, true);
            index ++;
        }
    }

    fireItemClickEvent(item: IItemData): void {
        if (this.clickListener) {
            this.clickListener.fireEvent(item);
        } 
    }
}
