import SpanElement from "../../dom/element/SpanElement";
import AbstractControl from "./AbstractControl";

export default class Span extends AbstractControl<SpanElement> {

    constructor(caption: string) {
        super(new SpanElement());
        this.setText(caption);
    }

    setValue(caption: string) {
        super.setValue(caption);
        this.setText(caption);
    }

    protected createEl(): HTMLElement {
        return document.createElement("span");
    }

}
