//import IconElement from "../../../common/dom/element/defines/IconElement";
//import ISkinFactory from "../../skin/base/ISkinFactory";
//import { IconSkin } from "../../skin/base/SkinDefine";
//import SkinManager from "../../skin/SkinManager";
import IconElement from "../../dom/element/IconElement";
import JComponent from "../JComponent";


export default class Icon extends JComponent<IconElement> {

    private iconName: string;

    constructor(iconName: string) {
        super(new IconElement());
        this.iconName = iconName;
        this.initSkin();
    }

    protected initSkin() {
        var clsIcon = this.styleFactory.getIcon();
        this.addClass(clsIcon);
        this.addClass(clsIcon + '-' + this.iconName);
        
    }
}