import SizeInfo from "../../struct/SizeInfo";
import H5HFlexPanel from "../container/panel/H5HFlexPanel";
import JComponent from "../JComponent";
import Label from "./Label";
import TextEditor from './TextEditor';
import DivElement from "../../dom/element/DivElement";
import DivButton from "./DivButton";

export default class ContentSearchBox extends JComponent<DivElement> {

    static NO_RESULT: string = "No Result";

    private btnPrevious: DivButton;
    private btnNext: DivButton;
    private btnClose: DivButton;

    private inputBox: TextEditor;

    private lblInfo: Label;

    constructor() {
        super(new DivElement());
        var panel = new H5HFlexPanel();
        this.inputBox = new TextEditor();
        // @ts-ignore
        this.inputBox.setPlaceholder(YIUI.I18N.getString("BOX_FIND","查找"));
        panel.addOneComponent(this.inputBox, SizeInfo.valueOfPX(250));
        this.lblInfo = new Label("");
        this.lblInfo.addClass('yg_matches');
        panel.addOneComponent(this.lblInfo, SizeInfo.valueOfPX(75));
        this.btnPrevious = new DivButton("yg_button_previous");
        panel.addOneComponent(this.btnPrevious, SizeInfo.valueOfPX(25));
        this.btnNext = new DivButton("yg_button_next");
        panel.addOneComponent(this.btnNext, SizeInfo.valueOfPX(25));
        this.btnClose = new DivButton("yg_button_close");
        panel.addOneComponent(this.btnClose, SizeInfo.valueOfPX(25));
        panel.display();
        panel.addClass('yg_content_searchbox');
        this.getEl().appendChild(panel.getEl());
        this.reset();
    }

    setOnNextListener(fn: any): void {
        this.btnNext.setOnClickListener(fn)
    }

    setOnPreviousListener(fn: any): void {
        this.btnPrevious.setOnClickListener(fn)
    }

    setOnCloseListener(fn: any): void {
        this.btnClose.setOnClickListener(fn);
    }

    setOnValueChanged(fn: any): void {
        this.inputBox.setOnValueChanged(fn);
    }

    setOnEnterListener(fn: any): void {
        this.inputBox.addEventListener('keyup', fn);
    }

    getSearchText(): string {
        return this.inputBox.getValue();
    }

    updateResultLabel(text: string): void {
        this.lblInfo.setText(text);
    }

    reset(): void {
        this.inputBox.setValue("");
        this.updateResultLabel(ContentSearchBox.NO_RESULT);
    }

    setNextEnable(b: boolean): void {
        this.btnNext.setEnable(b);
    }

    setPreviousEnable(b: boolean): void {
        this.btnPrevious.setEnable(b);
    }

    caretLast(): void {
        this.inputBox.caretLast();
    }
}