/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webplugin.service.start;

import com.bokesoft.erp.webplugin.service.common.util.MetaUtil;
import com.bokesoft.erp.webplugin.service.start.DBMetaService;
import com.bokesoft.erp.webplugin.service.start.ProcessDefinitionDBProfile;
import com.bokesoft.erp.webplugin.service.workflow.WFConstants;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.meta.persist.dom.AbstractLoad;
import com.bokesoft.yes.meta.persist.dom.bpm.MetaBPMLoad;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.bpm.total.ProcessMapType;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.HashMap;

public class DBMetaBPMLoader {
    public void load(DefaultContext context) {
        try {
            this.loadWorkflows(context);
            this.loadWorkflowBinds(context);
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
        }
    }

    private void loadWorkflows(DefaultContext context) throws Throwable {
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        SqlString sqlString = new SqlString().append(new Object[]{"select oid,workflowkey,name,version,content from EBPMN_WorkflowConfig where nodetype="}).appendPara((Object)0).append(new Object[]{" and enable> "}).appendPara((Object)-1);
        DataTable table = context.getDBManager().execPrepareQuery(sqlString.getSql(), sqlString.getParameterList());
        table.beforeFirst();
        while (table.next()) {
            try {
                long oid = table.getLong("oid");
                String workflowKey = table.getString("workflowkey");
                String name = table.getString("name");
                int version = table.getInt("version");
                this.loadDeployInfo(workflowKey, version, metaFactory);
                this.loadDBProfile(workflowKey, name, version, table.getString("content"), metaFactory);
                DBMetaService.getWorkflowVesionCacheInstance().initItem(TypeConvertor.toString((Object)oid));
            }
            catch (Throwable e) {
                LogSvr.getInstance().error(e.getMessage(), e);
            }
        }
    }

    private void loadWorkflowBinds(DefaultContext context) throws Throwable {
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        SqlString sqlString = new SqlString().append(new Object[]{"select OID,BindType,FormKey,IsDynamic,StartCaption,StartAction,WorkflowKey,WorkflowKeyFormula,Perm from EBPMN_WorkflowBind where nodetype="}).appendPara((Object)0).append(new Object[]{" and enable= "}).appendPara((Object)1);
        DataTable table = context.getDBManager().execPrepareQuery(sqlString.getSql(), sqlString.getParameterList());
        table.beforeFirst();
        while (table.next()) {
            try {
                long oid = table.getLong("OID");
                int type = ProcessMapType.parse((String)table.getString("BindType"));
                boolean bDynamicBinding = TypeConvertor.toBoolean((Object)table.getInt("IsDynamic"));
                String billKey = table.getString("FormKey");
                this.loadWorkflowBind(type, billKey, table.getString("WorkflowKey"), table.getString("WorkflowKeyFormula"), bDynamicBinding, table.getString("StartAction"), table.getString("StartCaption"), table.getString("Perm"), metaFactory);
                DBMetaService.getWorkflowBindVesionCacheInstance().initItem(TypeConvertor.toString((Object)oid));
            }
            catch (Throwable e) {
                LogSvr.getInstance().error(e.getMessage(), e);
            }
        }
    }

    public void loadDeployInfo(String workflowKey, int version, IMetaFactory metaFactory) throws Throwable {
        MetaProcessDeployInfo deployInfo = new MetaProcessDeployInfo();
        deployInfo.setKey(workflowKey);
        deployInfo.setVersion(Integer.valueOf(version));
        metaFactory.getMetaBPM().getMetaBPMDeployInfoCollection().add((KeyPairMetaObject)deployInfo);
    }

    public void loadDBProfile(String workflowKey, String caption, int version, String xml, IMetaFactory metaFactory) throws Throwable {
        ProcessDefinitionDBProfile dbProfile = new ProcessDefinitionDBProfile();
        dbProfile.setKey(workflowKey);
        dbProfile.setCaption(caption);
        dbProfile.setVersion(version);
        dbProfile.setXml(xml);
        dbProfile.setProject((IMetaProject)DBMetaBPMLoader.getDefaultProject(metaFactory));
        String profileKey = WFConstants.getBpmProfileKey(workflowKey, version);
        HashMap map = metaFactory.getMetaBPM().getProfileMap();
        ProcessDefinitionProfile orgProfile = (ProcessDefinitionProfile)map.get(profileKey);
        if (orgProfile != null) {
            if (orgProfile instanceof ProcessDefinitionDBProfile) {
                orgProfile = ((ProcessDefinitionDBProfile)orgProfile).getOrgProcessFileProfile();
            }
            dbProfile.setOrgProcessFileProfile(orgProfile);
        }
        map.put(profileKey, dbProfile);
    }

    public void loadWorkflowBind(int type, String billKey, String workflowKey, String workflowKeyFormula, boolean bDynamicBinding, String startAction, String startCaption, String xmlPerm, IMetaFactory metaFactory) throws Throwable {
        MetaProcessMap processMap = new MetaProcessMap();
        processMap.setType(Integer.valueOf(type));
        processMap.setKey(billKey);
        processMap.setProcessKey(workflowKey);
        processMap.setProcessKeyFormula(workflowKeyFormula);
        processMap.setDynamicBinding(Boolean.valueOf(bDynamicBinding));
        processMap.setStartAction(startAction);
        processMap.setStartCaption(startCaption);
        if (!StringUtil.isBlankOrNull((String)xmlPerm)) {
            MetaBPMLoad load = new MetaBPMLoad(1);
            MetaPerm metaPerm = new MetaPerm();
            MetaUtil.loadMetaObject(xmlPerm, (AbstractMetaObject)metaPerm, (AbstractLoad)load);
            processMap.setPerm(metaPerm);
        }
        metaFactory.getMetaBPM().getMetaProcessMapCollection().add((AbstractMetaObject)processMap);
    }

    public void removeLoadWorkflow(String workflowKey, int version, IMetaFactory metaFactory) throws Throwable {
        metaFactory.getMetaBPM().getMetaBPMDeployInfoCollection().remove(workflowKey);
        String profileKey = WFConstants.getBpmProfileKey(workflowKey, version);
        metaFactory.getMetaBPM().getProfileMap().remove(profileKey);
    }

    public void removeLoadWorkflowBind(String billKey, IMetaFactory metaFactory) throws Throwable {
        MetaProcessMap find = null;
        for (MetaProcessMap processMap : metaFactory.getMetaBPM().getMetaProcessMapCollection()) {
            if (!processMap.getKey().equalsIgnoreCase(billKey)) continue;
            find = processMap;
        }
        if (find != null) {
            metaFactory.getMetaBPM().getMetaProcessMapCollection().remove(find);
        }
    }

    public void removeLoadWorkflowBindByProcessKey(String processKey, IMetaFactory metaFactory) throws Throwable {
        MetaProcessMap find = null;
        for (MetaProcessMap processMap : metaFactory.getMetaBPM().getMetaProcessMapCollection()) {
            if (!processMap.getProcessKey().equalsIgnoreCase(processKey)) continue;
            find = processMap;
        }
        if (find != null) {
            metaFactory.getMetaBPM().getMetaProcessMapCollection().remove(find);
        }
    }

    private static MetaProject getDefaultProject(IMetaFactory metaFactory) throws Throwable {
        MetaProjectCollection metaProjectList = metaFactory.getSolution().getProjectCollection();
        if (metaProjectList.size() > 0) {
            return ((MetaProjectProfile)metaProjectList.get(0)).getProject();
        }
        return null;
    }
}

