/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webplugin.service.dictformula;

import com.bokesoft.erp.webplugin.service.dictformula.DictFormula;
import com.bokesoft.erp.webplugin.service.dictformula.EDictFormulaType;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.struct.dict.ItemRow;
import com.bokesoft.yes.struct.dict.ItemTableBase;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.dict.Item;
import java.util.HashMap;

public class DictFormulaManager {
    public static final String ITEMKEY = "BPMN_FormulaDefine";
    public static final String TABLE_PARA_DTL = "EBPMN_FormulaParaDtl";
    public static final String TABLE_OPERATOR_DTL = "EBPMN_FormulaOperatorDtl";
    public static HashMap<String, DictFormula> mapDictFormula = new HashMap();

    public static DictFormula getDictFormula(String code, RichDocumentContext context) throws Throwable {
        if (mapDictFormula.containsKey(code)) {
            return mapDictFormula.get(code);
        }
        DictFormula dictFormula = null;
        Item item = context.getDictCache().locate(ITEMKEY, "Code", (Object)code, null, null, 7, null, null, 0);
        if (item != null) {
            dictFormula = new DictFormula(code);
            String formulaType = TypeConvertor.toString((Object)item.getValue("FormulaType"));
            dictFormula.setFormulaType(EDictFormulaType.valueOf(formulaType));
            int formulaSourceType = TypeConvertor.toInteger((Object)item.getValue("SourceType"));
            dictFormula.setFormulaSourceType(formulaSourceType);
            String define = TypeConvertor.toString((Object)item.getValue("Define"));
            dictFormula.setDefine(define);
            ItemTableBase table = item.getItemTable(TABLE_PARA_DTL);
            if (table != null && table.getRowCount() > 0) {
                for (ItemRow row : table.getRows()) {
                    boolean isFormulaPara = TypeConvertor.toBoolean((Object)row.getValue("IsFormula"));
                    String para = TypeConvertor.toString((Object)row.getValue("Para"));
                    if (isFormulaPara) {
                        Object result = context.evalFormula(para, "");
                        dictFormula.addPara(result);
                        continue;
                    }
                    dictFormula.addPara(para);
                }
            }
            if ((table = item.getItemTable(TABLE_OPERATOR_DTL)) != null && table.getRowCount() > 0) {
                for (ItemRow row : table.getRows()) {
                    Long operatorID = TypeConvertor.toLong((Object)row.getValue("OperatorID"));
                    if (operatorID <= 0L) continue;
                    dictFormula.addOperator(operatorID);
                }
            }
            mapDictFormula.put(code, dictFormula);
        }
        return dictFormula;
    }
}

