CodeMirror.registerHelper("textHover", "yigo", function (cm, data, node) {
    let component = null;
    let type = "normalWin";
    try {
        if ($("iframe").contents().find("#description")) {
            component = $("span[id$=_ForumlaContent]").children('input')[0];
            type = "popupWin";
        } else {
            // 设置编辑器选中内容的提醒
            let id = DESIGNER.UI.propertyForm.getParentForm().formID;
            component = $('#' + id + "_FormulaEditorFooter").children('textArea')[0];
        }
    } catch (e) {
        console.log(e);
    }

    if (!component && DESIGNER.UI.propertyForm) {
        let id = DESIGNER.UI.propertyForm.getParentForm().formID;
        component = $('#' + id + "_FormulaEditorFooter").children('textArea')[0];
        type = "normalWin";
        if (!component) {
            console.log("组件为空或未定义");
            return;
        }
    }

    if (data) {
        let html = "";
        let token = data.token;
        if (!token || !token.string) {
            return false;
        }

        // 函数名或组件名
        const functionName = token.string;
        
        // 获取操作系统类型
    	function getOperationSysemType() {
    		if (navigator.userAgent.indexOf("Window") > 0) {
    			return "Windows";
    		} else if (navigator.userAgent.indexOf("Mac OS X") > 0) {
    			return "Mac";
    		} else if (navigator.userAgent.indexOf("Linux") > 0) {
    			return "Linux";
    		} else {
    			return "NUll";
    		}
    	}
    	
    	let enterChar = "\r\n";
    	if (getOperationSysemType() === "Mac") {
    		enterChar = "\r";
    	} else if (getOperationSysemType() === "Linux") {
    		enterChar = "\n";
    	} else {
    		enterChar = "\r\n";
    	}
    	var macroTreeContent;
		//宏公式树层级结构
		let params = {
			cmd: "fillMacro",
			service: "DesignService",
			formula: functionName,
			key: DESIGNER.UI.activeERPFormKey
		};
		var result = new Svr.Request().getSyncData(Svr.SvrMgr.ServletURL, params);
		if (result){
			macroTreeContent = result.macroTreeContent;
		}
		// 组件关键字提示
		if (data.componentIdList && data.componentIdList.length > 0) {
			for (let i = 0; i < data.componentIdList.length; i++) {
				if (data.componentIdList[i] === functionName) {
					if (type == "popupWin") {
						html = "<br/><b>名称：</b>" + functionName +
							"<br/><br/><b>描述：</b>" + data.componentDescList[i];
					} else {
						html = "<b>标识(Key)：</b>" + functionName
							+ enterChar + enterChar + "<b>名称(Caption):</b>" + data.componentDescList[i];
						component.value = html;
						component.style.wordWrap = "break-word";
					}
				}
			}
			if (html) {
				return html;
			}
		}
        // 所有函数列表
        if (data.funcList && data.funcList.length > 0) {
            for (let i = 0; i < data.funcList.length; i++) {
                if (data.funcList[i].substring(0, data.funcList[i].indexOf("(")) === functionName) {
                    if (type == "popupWin") {
                        if (functionName.toLowerCase().startsWith("com.bokesoft")) {
							html += "<br/><b>函数名：</b>" + functionName
                                   +"<br/><b>功能描述：</b>" + data.funcDescList[i]
                                   +"<br/><b>参数说明：</b>" + data.paramDescList[i]
                                   +"<br/><b>返回值类型说明：</b>" + data.returnValueDescList[i] + "<br/>";
                        } else {
							html = "<br/><b>函数名：</b>" + functionName
                                +"<br/><b>功能描述：</b>" + data.funcDescList[i]
                                +"<br/><b>参数说明：</b>" + data.paramDescList[i]
                                +"<br/><b>返回值类型说明：</b>" + data.returnValueDescList[i];
                        }
                    } else {
                        if (functionName.toLowerCase().startsWith("com.bokesoft")) {
							html += enterChar + "<b>函数名：</b>" + functionName
                                   + enterChar + "<b>功能描述：</b>" + data.funcDescList[i]
                                   + enterChar + "<b>参数说明：</b>" + data.paramDescList[i]
                                   + enterChar + "<b>返回值类型说明：</b>" + data.returnValueDescList[i] + enterChar;
                        } else {
							html = enterChar + "<b>函数名：</b>" + functionName
                                + enterChar + "<b>功能描述：</b>" + data.funcDescList[i]
                                + enterChar + "<b>参数说明：</b>" + data.paramDescList[i]
                                + enterChar + "<b>返回值类型说明：</b>" + data.returnValueDescList[i];
                        }
                        component.value = html;
                        component.style.wordWrap = "break-word";
                    }
                }
            }
        }

			// 所有宏公式列表
			if (data.macroIdList && data.macroIdList.length > 0) {
				for (let i = 0; i < data.macroIdList.length; i++) {
					if (data.macroIdList[i].substring(0, data.macroIdList[i].indexOf("(")) === functionName) {
						if (type == "popupWin") {
							html = "<br/><b>函数名：</b>" + functionName
								+"<br/><b>功能描述：</b>" + data.macroDescList[i]
								+"<br/><b>参数说明：</b>" + ""
								+"<br/><b>返回值类型说明：</b>" + "";
						} else {
							html = enterChar + "<b>函数名：</b>" + functionName
								+ enterChar + "<b>功能描述：</b>" + data.macroDescList[i]
								+ enterChar + "<b>参数说明：</b>" + ""
								+ enterChar + "<b>返回值类型说明：</b>" + "";
							component.value = html;
							component.style.wordWrap = "break-word";
						}
					}
				}
			}
		// 根据表单Key后台查询Caption
		// 表单数组
		let metaFormList = [];
		let url = parent.Svr.SvrMgr.ServletURL;
		let params1= {
			cmd: "FormulaServiceCmd",
			service: "DesignService",
			type: "searchFormCaptionByKey",
			searchKey : functionName
		};
		new parent.Svr.Request().getSyncData(url, params1, function (data) {
			metaFormList = JSON.parse(data);
			if (metaFormList && metaFormList.length > 0) {
				metaFormList.forEach(function (metaForm) {
					let key = metaForm.FormKey;
					let caption = metaForm.FormCaption;
					if (type == "popupWin") {
						html = "<br/><b>名称：</b>" + key +
							"<br/><br/><b>描述：</b>" + caption;
					} else {
						html = "<b>标识(Key)：</b>" + key
							+ enterChar + enterChar + "<b>名称(Caption):</b>" + caption;
						component.value = html;
						component.style.wordWrap = "break-word";
					}
					return html;
				});
			}
		});
		if (macroTreeContent){
			return html+"<br/><b>宏公式树层级：</b><br/>" + macroTreeContent
		}else {
			return html;
		}

    } else {
        return false;
    }
});