package com.bokesoft.yes.tool;

import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Parser;
import com.bokesoft.yes.parser.Rule;
import com.bokesoft.yes.parser.SyntaxTree;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.parser.IEvalContext;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;

public class FormulaUtil {
	
	/**
	 * 判断是否是SetValue函数<br>
	 * SetValue('MaterialPlantStatusID', PPMaterialPlantStatusID, false)<br>
	 * IIF(IsPurchase_NODB4Other == 1, SetValue('MaterialPlantStatusID', PPMaterialPlantStatusID, false), true)
	 * @param item
	 * @return
	 */
	public static boolean isSetValueFunction(Item item) {		
		return isSetValueFunctionSimple(item) || isSetValueFunctionIf(item) || isSetValueFunctionPreIIF(item) || isSetValueFunctionPreIIF2(item);
	}
	
	/**
	 * 判断是否是SetValue函数，SetValue('MaterialPlantStatusID', PPMaterialPlantStatusID, false)
	 * @param item
	 * @return
	 */
	private static boolean isSetValueFunctionSimple(Item item) {
		if (item.getRule().getIndex() != FormulaDeparser.RuleIndex_19_Function
				|| !item.getFactor(0).getFullLexValue().equalsIgnoreCase("setValue")) {
			return false;
		}
		Item item_2 = item.getFactor(2);
		if (item_2.getRule().getIndex() != FormulaDeparser.RuleIndex_17_Const) {
			return false;
		}
		
		return item.getChildCount() >= 6; //配置中有这样的错误表达式IIF(PayType == 1, SetValue('PayDateRole'), 0);
	}
	
	/**
	 * 判断是否是SetValue函数<br>
	 * if(Macro_CmbAna_Trigger()) {SetValue('AnalysisID', 0)}<br>
	 * if(HUID <= 0) {SetValue('HUID', GetAutoID())} else {true}
	 * @param item
	 * @return
	 */
	private static boolean isSetValueFunctionIf(Item item) {
		int ruleIndex = item.getRule().getIndex();
		if (ruleIndex == FormulaDeparser.RuleIndex_26_IfHead || ruleIndex == FormulaDeparser.RuleIndex_28_IfHead) {
			Item item_5 = item.getFactor(5);
			Item tmp = (item_5.getRule().getIndex() == FormulaDeparser.RuleIndex_0_Statement) ? item_5.getFactor(0) : item_5;
			return isSetValueFunctionSimple(tmp);
		} else if (ruleIndex == FormulaDeparser.RuleIndex_27_IfElse) {
			Item item_5 = item.getFactor(5);
			Item tmp = (item_5.getRule().getIndex() == FormulaDeparser.RuleIndex_0_Statement) ? item_5.getFactor(0) : item_5;
			if (!isSetValueFunctionSimple(tmp)) {
				return false;
			}
			Item item_9 = item.getFactor(9);
			tmp = (item_9.getRule().getIndex() == FormulaDeparser.RuleIndex_0_Statement) ? item_9.getFactor(0) : item_9;
			return tmp.getRule().getIndex() == FormulaDeparser.RuleIndex_17_Const;
		}
		return false;
	}
	
	/**
	 * 判断是否是SetValue函数<br>
	 * IIF(IsPurchase_NODB4Other == 1, SetValue('MaterialPlantStatusID', PPMaterialPlantStatusID, false), true)<br>
	 * IIFS(AccountAssignmentMeans == 0, SetValue('InvoiceAssignment', 0))
	 * @param item
	 * @return
	 */
	private static boolean isSetValueFunctionPreIIF(Item item) {
		if (item.getRule().getIndex() != FormulaDeparser.RuleIndex_19_Function
				|| !(item.getFactor(0).getFullLexValue().equalsIgnoreCase("IIF")
						|| item.getFactor(0).getFullLexValue().equalsIgnoreCase("IIFS"))) {
			return false;
		}
		Item item_4 = item.getFactor(4);
		if (!isSetValueFunctionSimple(item_4)) {
			return false;
		}
		return item.getChildCount() <= 8;
	}
	
	/**
	 * 判断是否是SetValue函数<br>
	 * IIF(IsDtlNoRemainWork == 0, true, SetValue('DtlRemainingWork', 0))
	 * @param item
	 * @return
	 */
	private static boolean isSetValueFunctionPreIIF2(Item item) {
		if (item.getRule().getIndex() != FormulaDeparser.RuleIndex_19_Function
				|| !item.getFactor(0).getFullLexValue().equalsIgnoreCase("IIF")) {
			return false;
		}
		if (item.getFactor(4).getRule().getIndex() != FormulaDeparser.RuleIndex_17_Const) {
			return false;
		}
		return isSetValueFunctionSimple(item.getFactor(6));
	}
	
	/**
	 * 取SetValue函数的目标字段名
	 * @param item
	 * @return
	 */
	public static String getSetValueFieldKey(Item item) {
		if (isSetValueFunctionSimple(item)) {
			return item.getFactor(2).getFactor(0).getLexValue();
		} else if (isSetValueFunctionIf(item)) {
			Item item_5 = item.getFactor(5);
			Item tmp = (item_5.getRule().getIndex() == FormulaDeparser.RuleIndex_0_Statement) ? item_5.getFactor(0) : item_5;
			return tmp.getFactor(2).getFactor(0).getLexValue();
		} else if (isSetValueFunctionPreIIF(item)) {
			return item.getFactor(4).getFactor(2).getFactor(0).getLexValue();
		} else if (isSetValueFunctionPreIIF2(item)) {
			return item.getFactor(6).getFactor(2).getFactor(0).getLexValue();
		}
		throw new RuntimeException("调用错误，isSetValueFunction()为False。");
	}
	
	/**
	 * 取setValue的值表达式（即参数1，注意从0开始）<br>
	 * IIF(IsCurrentAsset == 1, SetValue('IsNewAsset', 0), true) 返回 IIF(IsCurrentAsset == 1, 0, IsNewAsset)
	 * @param item
	 * @return
	 */
	public static String getSetValueFormula(Item item) {
		if (isSetValueFunctionSimple(item)) {
			return FormulaDeparser.deParse(item.getFactor(4));
		} else if (isSetValueFunctionIf(item)) {
			Item item_5 = item.getFactor(5);
			Item tmp = (item_5.getRule().getIndex() == FormulaDeparser.RuleIndex_0_Statement) ? item_5.getFactor(0) : item_5;
			return "IIF(" + FormulaDeparser.deParse(item.getFactor(2)) + ", "
					+ FormulaDeparser.deParse(tmp.getFactor(4)) + ", " + getSetValueFieldKey(item) + ")";
		} else if (isSetValueFunctionPreIIF(item)) {
			return "IIF(" + FormulaDeparser.deParse(item.getFactor(2)) + ", "
					+ FormulaDeparser.deParse(item.getFactor(4).getFactor(4)) + ", " + getSetValueFieldKey(item) + ")";
		} else if (isSetValueFunctionPreIIF2(item)) {
			return "IIF(!(" + FormulaDeparser.deParse(item.getFactor(2)) + "), "
					+ FormulaDeparser.deParse(item.getFactor(6).getFactor(4)) + ", " + getSetValueFieldKey(item) + ")";
		}
		throw new RuntimeException("调用错误，isSetValueFunction()为False。");
	}
	
//	/**
//	 * 取setValue的值表达式（即参数1，注意从0开始），不考虑IIF条件<br>
//	 * IIF(IsCurrentAsset == 1, SetValue('IsNewAsset', 0), true) 返回 0
//	 * @param item
//	 * @return
//	 */
//	public static String getSetValueFormulaNoCondition(Item item) {
//		if (isSetValueFunctionSimple(item)) {
//			return FormulaDeparser.deParse(item.getFactor(4));
//		} else if (isSetValueFunctionIf(item)) {
//			Item item_5 = item.getFactor(5);
//			Item tmp = (item_5.getRule().getIndex() == FormulaDeparser.RuleIndex_0_Statement) ? item_5.getFactor(0) : item_5;
//			return FormulaDeparser.deParse(tmp.getFactor(4));
//		} else if (isSetValueFunctionPreIIF(item)) {
//			return FormulaDeparser.deParse(item.getFactor(4).getFactor(4));
//		} else if (isSetValueFunctionPreIIF2(item)) {
//			return FormulaDeparser.deParse(item.getFactor(6).getFactor(4));
//		}
//		throw new RuntimeException("调用错误，isSetValueFunction()为False。");
//	}
	
	/**
	 * 返回SetValue函数是否触发目标字段的ValueChanged属性，默认是false
	 * @param item
	 * @return
	 */
	public static boolean getSetValueIsValueChanged(Item item) {
		if (isSetValueFunctionSimple(item)) {
			return item.getChildCount() < 7 ? false : TypeConvertor.toBoolean(item.getFactor(6).getFactor(0).getLexValue());
		} else if (isSetValueFunctionIf(item)) {
			Item item_5 = item.getFactor(5);
			Item tmp = (item_5.getRule().getIndex() == FormulaDeparser.RuleIndex_0_Statement) ? item_5.getFactor(0) : item_5;
			return tmp.getChildCount() < 7 ? false : TypeConvertor.toBoolean(tmp.getFactor(6).getFactor(0).getLexValue());
		} else if (isSetValueFunctionPreIIF(item)) {
			Item tmp = item.getFactor(4);
			return tmp.getChildCount() < 7 ? false : TypeConvertor.toBoolean(tmp.getFactor(6).getFactor(0).getLexValue());
		} else if (isSetValueFunctionPreIIF2(item)) {
			Item tmp = item.getFactor(6);
			return tmp.getChildCount() < 7 ? false : TypeConvertor.toBoolean(tmp.getFactor(6).getFactor(0).getLexValue());
		}
		throw new RuntimeException("调用错误，isSetValueFunction()为False。");
	}
	
	/**
	 * 将语法结构分解成句子
	 * @param item
	 * @return
	 */
	public static List<Item> getStatements(Item item) {
		List<Item> result = new ArrayList<Item>();
		if (item.getRule().getIndex() == FormulaDeparser.RuleIndex_1_Statements) {
			for (int i = 0, size = item.getChildCount(); i < size; i += 2) {
				result.add(item.getFactor(i));
			}
		} else {
			result.add(item);
		}
		return result;
	}
	
	public static String addDefaultFormulaValue(Item item, String srcFieldKey, String srcFieldCheckRule,
			String tgtFieldKey, String tgtOrginalDefaultFormulaValue, String tgtValueChanged, Stack<String> path) {
		if (isCheckRuleEmpty(srcFieldCheckRule)) {
			if (isEmpty(tgtOrginalDefaultFormulaValue)) {
				throw new RuntimeException(FormulaDeparser.deParse(item) + "转化为默认值不对，触发字段的检查和目标字段的原默认值都为空。" + path.toString());
			}
			if (getSetValueIsValueChanged(item) && !isEmpty(tgtValueChanged)) {
				return null;
			}
			return FormulaDeparser.deParse(item);
		} else {
			// 下面的写法不等价！！！
			if (srcFieldCheckRule.length() > 30) {
				return "IIF(isCheck('" + srcFieldKey + "'), " + FormulaDeparser.deParse(item) + ", " + tgtFieldKey + ")";
			} else {
				return "IIF(" + srcFieldCheckRule + ", " + FormulaDeparser.deParse(item) + ", " + tgtFieldKey + ")";
			}
		}
	}
	
	private static boolean isCheckRuleEmpty(String checkRule) {
		return StringUtils.isBlank(checkRule) || checkRule.equalsIgnoreCase("true");
	}
	
	private static boolean isEmpty(String formula) {
		return StringUtils.isBlank(formula);
	}
	
	public static void main(String[] args) {
		String f = "setValue('AA', 1+ 2, true)";
		Parser<IEvalContext> parser = new Parser<IEvalContext>(null);
		SyntaxTree syntaxTree = parser.parse(f);
		System.out.println(isSetValueFunction(syntaxTree.getRoot()));
		f = "setValue('AA', 1+ 2, true);Hi( 1+2);SEtValue('BB', 2);SEtValue('BB', 2, false)";
		syntaxTree = parser.parse(f);
		System.out.println(FormulaDeparser.deParse(syntaxTree.getRoot()));
		for (Item item : getStatements(syntaxTree.getRoot())) {
			System.out.println(FormulaDeparser.deParse(item) + ":" + isSetValueFunction(item));
			if (isSetValueFunction(item)) {
				System.out.println(getSetValueIsValueChanged(item));
			}
		}
	}

	/**
	 * 格式化表达式
	 * @param formula
	 * @return
	 */
	public static String format(String formula) {
		if (StringUtils.isBlank(formula)) {
			return null;
		}
		Parser<IEvalContext> parser = new Parser<IEvalContext>(null);
		SyntaxTree syntaxTree = parser.parse(formula);
		return Objects.isNull(syntaxTree) ? formula : FormulaDeparser.deParse(syntaxTree.getRoot());
	}
	
	/**
	 * 判断两个表达式是否等价
	 * @param formula0
	 * @param formula1
	 * @return
	 */
	public static boolean isSame(String formula0, String formula1) {
		if (formula0.equals(formula1)) {
			return true;
		}
		if (StringUtils.isBlank(formula0)) {
			if (StringUtils.isBlank(formula1)) {
				return true;
			}
		} else if (StringUtils.isBlank(formula1)) {
			return false;
		}
		Parser<IEvalContext> parser = new Parser<IEvalContext>(null);
		SyntaxTree syntaxTree0 = parser.parse(formula0);
		SyntaxTree syntaxTree1 = parser.parse(formula1);
		if (syntaxTree0 == syntaxTree1) { // 都是null
			return true;
		}
		if (Objects.isNull(syntaxTree0) || Objects.isNull(syntaxTree1)) {
			return false;
		}
		return isSame(syntaxTree0.getRoot(), syntaxTree1.getRoot());
	}

	private static boolean isSame(Item item0, Item item1) {
		if (item0 == item1) {
			return true;
		}
		if (Objects.isNull(item0) || Objects.isNull(item1)) {
			return false;
		}
		if (item0.getRule() != item1.getRule() || !StringUtils.equals(item0.getLexValue(), item1.getLexValue())
				|| !StringUtils.equals(item0.getFullLexValue(), item1.getFullLexValue())
				|| item0.getChildCount() != item1.getChildCount()) {
			return false;
		}
		Rule rule = item0.getRule();
		if (rule != null) {
			int ruleIndex = rule.getIndex();
			if (ruleIndex == FormulaDeparser.RuleIndex_2_Addition
					|| ruleIndex == FormulaDeparser.RuleIndex_4_Multiplication) {
				if ((isSame(item0.getFactor(0), item1.getFactor(0)) && isSame(item0.getFactor(2), item1.getFactor(2)))
						|| (isSame(item0.getFactor(0), item1.getFactor(2))
								&& isSame(item0.getFactor(2), item1.getFactor(0)))) {
					return true;
				}
			}
		}
		int childCount = item0.getChildCount();
		for (int i = 0; i < childCount; i++) {
			if (!isSame(item0.getFactor(i), item1.getFactor(i))) {
				return false;
			}
		}
		return true;
	}

	/**
	 * 将语句生成字符串
	 * @param items
	 * @param format 
	 * @return
	 */
	public static String deParseStatements(List<Item> items, FormulaFormat format) {
		if (items.size() == 0) {
			return null;
		}
		StringBuilder sb = new StringBuilder(512);
		sb.append(FormulaDeparserWithFormat.deParse(items.get(0), format));
		for (int i = 1, size = items.size(); i < size; i++) {
			sb.append(";").append(FormulaDeparserWithFormat.deParse(items.get(i), format));
		}
		return sb.toString();
	}

	/**
	 * 取所有的叶子语法树项目
	 * @param item
	 * @return
	 */
	public static List<Item> getLeafItems(Item item) {
		List<Item> result = new ArrayList<Item>();
		return getLeafItems(item, result);
	}
	
	private static List<Item> getLeafItems(Item item, List<Item> result) {
		if (item.getChildCount() == 0) {
			// if(1){return 0;}return 2; 如前例，return 2前解析时会增加一个;号
			if (item.getLexValue() == ";" && item.getFullLexValue() != null && item.getFullLexValue().length() > 0) {
				return result;
			}
			result.add(item);
		} else {
			for (Item subItem : item.getAllChild()) {
				getLeafItems(subItem, result);
			}
		}
		return result;
	}
	
	/**
	 * 判断表达式对字段的依赖
	 * @param formula
	 * @param fieldKey
	 * @return
	 */
	public static boolean isDependFieldKey(String formula, String fieldKey) {
		Parser<IEvalContext> parser = new Parser<IEvalContext>(null);
		SyntaxTree syntaxTree = parser.parse(formula);
		List<Item> leafItems = getLeafItems(syntaxTree.getRoot());
		for (Item item : leafItems) {
			if (fieldKey.equals(item.getLexValue()) && "id".equals(item.getRuleFactor().getName())) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * 判断一个表达式是否是计算结果，这只是用于猜测配置中可能的不合理性
	 * @param formula
	 * @return
	 */
	public static boolean isCalcFormula(String formula) {
		if (StringUtils.isBlank(formula)) {
			return false;
		}
		Parser<IEvalContext> parser = new Parser<IEvalContext>(null);
		SyntaxTree syntaxTree = parser.parse(formula);
		return isCalcItem(syntaxTree.getRoot());
	}
	
	private static boolean isCalcItem(Item item) {
		Rule rule = item.getRule();
		if (Objects.isNull(rule)) {
			return false;
		}
		int ruleIndex = rule.getIndex();
		if (ruleIndex == FormulaDeparser.RuleIndex_2_Addition || ruleIndex == FormulaDeparser.RuleIndex_3_Subtraction
				|| ruleIndex == FormulaDeparser.RuleIndex_4_Multiplication
				|| ruleIndex == FormulaDeparser.RuleIndex_5_Division) {
			return true;
		}
		if (ruleIndex == FormulaDeparser.RuleIndex_19_Function) {
			String functionName = item.getFactor(0).getLexValue();
			if (functionName.equalsIgnoreCase("GetDictOID") || functionName.equalsIgnoreCase("GetDictValue")) {
				return true;
			} else if (functionName.startsWith("com.bokesoft.")) {
				return true;
			}
		}
		List<Item> children = item.getAllChild();
		if (children != null) {
			for (Item childItem : children) {
				if (isCalcItem(childItem)) {
					return true;
				}
			}
		}
		return false;
	}
}