package com.bokesoft.yes.tool;

import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Rule;
import com.bokesoft.yes.parser.SyntaxTree;
import org.apache.commons.lang3.NotImplementedException;

/**
 * 表达式反向解析，由对象生成字段符
 */
public class FormulaDeparser {
	public static final int RuleIndex_0_Statement = 0;
	public static final int RuleIndex_1_Statements = 1;
	public static final int RuleIndex_2_Addition = 2;
	public static final int RuleIndex_3_Subtraction = 3;
	public static final int RuleIndex_4_Multiplication = 4;
	public static final int RuleIndex_5_Division = 5;
	public static final int RuleIndex_6_Concat = 6;
	public static final int RuleIndex_7_Parenthesis = 7;
	public static final int RuleIndex_8_Not = 8;
	public static final int RuleIndex_9_Or = 9;
	public static final int RuleIndex_10_And = 10;
	public static final int RuleIndex_11_EqualsTo = 11;
	public static final int RuleIndex_12_NotEqualsTo = 12;
	public static final int RuleIndex_13_GreaterThan = 13;
	public static final int RuleIndex_14_GreaterThanEquals = 14;
	public static final int RuleIndex_15_MinorThan = 15;
	public static final int RuleIndex_16_MinorThanEquals = 16;
	public static final int RuleIndex_17_Const = 17;
	public static final int RuleIndex_18_ID = 18;
	public static final int RuleIndex_19_Function = 19;
	public static final int RuleIndex_20_ = 20;
	public static final int RuleIndex_21_ = 21;
	public static final int RuleIndex_22_ = 22;
	public static final int RuleIndex_23_ = 23;
	public static final int RuleIndex_24_ = 24;
	public static final int RuleIndex_25_Var = 25;
	public static final int RuleIndex_26_IfHead = 26;
	public static final int RuleIndex_27_IfElse = 27;
	public static final int RuleIndex_28_IfHead = 28;
	public static final int RuleIndex_29_ = 29;
	public static final int RuleIndex_30_While = 30;
	public static final int RuleIndex_31_SetValue = 31;
	public static final int RuleIndex_32_Return = 32;
	public static final int RuleIndex_33_ = 33;
	public static final int RuleIndex_34_ = 34;
	public static final int RuleIndex_35_ = 35;
	public static final int RuleIndex_36_ = 36;
	public static final int RuleIndex_37_ = 37;
	public static final int RuleIndex_38_ = 38;
	public static final int RuleIndex_39_ = 39;
	
	public static final FormulaDeparser instance = new FormulaDeparser();
	
	public static String deParse(SyntaxTree syntaxTree) {
		StringBuilder sb = new StringBuilder(128);
		return instance.deParse(syntaxTree.getRoot(), sb).toString();
	}

	public static String deParse(Item item) {
		StringBuilder sb = new StringBuilder(128);
		return instance.deParse(item, sb).toString();
	}

	private StringBuilder deParse(Item item, StringBuilder sb) {
		Rule rule = item.getRule();
		if (rule != null) {
			int ruleIndex = rule.getIndex();
			switch (ruleIndex) {
			case RuleIndex_0_Statement:
				// SL -> E
				return deParse0Statement(item, sb);
			case RuleIndex_1_Statements:
				// SL -> E ; SL
				return deParse1Statements(item, sb);
			case RuleIndex_2_Addition:
				// E -> E + E
				return deParse2Addition(item, sb);
			case RuleIndex_3_Subtraction:
				// E -> E - E
				return deparse3Subtraction(item, sb);
			case RuleIndex_4_Multiplication:
				// E -> E * E
				return deParse4Multiplication(item, sb);
			case RuleIndex_5_Division:
				// E -> E / E
				return deParse5Division(item, sb);
			case RuleIndex_6_Concat:
				// E -> E & E
				return deParse6Concat(item, sb);
			case RuleIndex_7_Parenthesis:
				// E -> ( E )
				return deParse7Parenthesis(item, sb);
			case RuleIndex_8_Not:
				// E -> ! E
				return deParse8Not(item, sb);
			case RuleIndex_9_Or:
				// E -> E || E
				return deParse9Or(item, sb);
			case RuleIndex_10_And:
				// E -> E && E
				return deParse10And(item, sb);
			case RuleIndex_11_EqualsTo:
				// E -> E == E
				return deParse11EqualsTo(item, sb);
			case RuleIndex_12_NotEqualsTo:
				// E -> E <> E
				return deParse12NotEqualsTo(item, sb);
			case RuleIndex_13_GreaterThan:
				// E -> E > E
				return deParse13GreaterThan(item, sb);
			case RuleIndex_14_GreaterThanEquals:
				// E -> E >= E
				return deParse14GreaterThanEquals(item, sb);
			case RuleIndex_15_MinorThan:
				// E -> E < E
				return deParse15MinorThan(item, sb);
			case RuleIndex_16_MinorThanEquals:
				// E -> E <= E
				return deParse16MinorThanEquals(item, sb);
			case RuleIndex_17_Const:
				// E -> const
				return deParse17Const(item, sb);
			case RuleIndex_18_ID:
				// E -> id
				return deParse18ID(item, sb);
			case RuleIndex_19_Function:
				// E -> FUNC_HEAD FUNC_TAIL
				return deParse19Function(item, sb);
			case RuleIndex_20_:
				// FUNC_HEAD -> function (
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_21_:
				// FUNC_TAIL -> )
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_22_:
				// FUNC_TAIL -> PL )
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_23_:
				// PL -> E
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_24_:
				// PL -> E , PL
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_25_Var:
				// E -> var id = E
				return deParse25Var(item, sb);
			case RuleIndex_26_IfHead:
				// E -> IF_HEAD
				return deParse26IfHead(item, sb);
			case RuleIndex_27_IfElse:
				// E -> IF_HEAD IF_TAIL
				return deParse27IfElse(item, sb);
			case RuleIndex_28_IfHead:
				// IF_HEAD -> if ( E ) { SL }
				return deParse26IfHead(item, sb);
			case RuleIndex_29_:
				// IF_TAIL -> else { SL }
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_30_While:
				// E -> while ( E ) { SL }
				return deParse30While(item, sb);
			case RuleIndex_31_SetValue:
				// E -> E = E
				return deParse31SetValue(item, sb);
			case RuleIndex_32_Return:
				// E -> return E
				return deParse32Return(item, sb);
			case RuleIndex_33_:
				// E -> break
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_34_:
				// E -> loop E ( E ) { SL }
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_35_:
				// E -> RANGE
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_36_:
				// E -> switch ( E ) { CASE_SL }
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_37_:
				// CASE_SL -> CASE_S
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_38_:
				// CASE_SL -> CASE_S ; CASE_SL
				throw new NotImplementedException("Code is not implemented");
			case RuleIndex_39_:
				// CASE_S -> casprivate StringBuilder  E : { SL }
				throw new NotImplementedException("Code is not implemented");
			}
		}
		throw new NotImplementedException("Code is not implemented");
	}


	// SL -> E
	private StringBuilder deParse0Statement(Item factor, StringBuilder sb) {
		return deParse(factor.getFactor(0), sb);
	}

	// SL -> E ; SL
	private StringBuilder deParse1Statements(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb);
		for (int i = 2, size = factor.getChildCount(); i < size; i += 2) {
			sb.append("; ");
			deParse(factor.getFactor(i), sb);
		}
		return sb;
	}

	// E -> E + E
	private StringBuilder deParse2Addition(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" + ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> E - E
	private StringBuilder deparse3Subtraction(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" - ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> E * E
	private StringBuilder deParse4Multiplication(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" * ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> E / E
	private StringBuilder deParse5Division(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" / ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> E & E
	private StringBuilder deParse6Concat(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" & ");
		return deParse(factor.getFactor(2), sb);
	}
	
	// E -> ( E )
	private StringBuilder deParse7Parenthesis(Item factor, StringBuilder sb) {
		sb.append("(");
		deParse(factor.getFactor(1), sb);
		return sb.append(")");
	}

	// E -> ! E
	private StringBuilder deParse8Not(Item factor, StringBuilder sb) {
		sb.append("!");
		return deParse(factor.getFactor(1), sb);
	}

	// E -> E || E
	private StringBuilder deParse9Or(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" || ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> E && E
	private StringBuilder deParse10And(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" && ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> E == E
	private StringBuilder deParse11EqualsTo(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" == ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> E <> E
	private StringBuilder deParse12NotEqualsTo(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" <> ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> E > E
	private StringBuilder deParse13GreaterThan(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" > ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> E >= E
	private StringBuilder deParse14GreaterThanEquals(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" >= ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> E < E
	private StringBuilder deParse15MinorThan(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" < ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> E <= E
	private StringBuilder deParse16MinorThanEquals(Item factor, StringBuilder sb) {
		deParse(factor.getFactor(0), sb).append(" <= ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> const
	private StringBuilder deParse17Const(Item factor, StringBuilder sb) {
		Object value = factor.getFactor(0).getValue();
		if (value instanceof String) {
			return sb.append("'").append(value).append("'");
		} else {
			return sb.append(value);
		}
	}

	// E -> id
	private StringBuilder deParse18ID(Item factor, StringBuilder sb) {
		return sb.append(factor.getFactor(0).getFullLexValue());
	}

	// E -> FUNC_HEAD FUNC_TAIL
	private StringBuilder deParse19Function(Item factor, StringBuilder sb) {
		sb.append(factor.getFactor(0).getFullLexValue()).append("(");
		int size = factor.getChildCount();
		if (size >=4 ) {
			deParse(factor.getFactor(2), sb);
		}
		for (int i = 4; i < size; i += 2) {
			sb.append(", ");
			deParse(factor.getFactor(i), sb);
		}
		return sb.append(")");
	}

	// E -> var id = E
	private StringBuilder deParse25Var(Item factor, StringBuilder sb) {
		sb.append(factor.getFactor(0).getFullLexValue()).append(" ");
		sb.append(factor.getFactor(1).getFullLexValue()).append(" = ");
		return deParse(factor.getFactor(3), sb);
	}

	// E -> IF_HEAD
	private StringBuilder deParse26IfHead(Item factor, StringBuilder sb) {
		sb.append(factor.getFactor(0).getFullLexValue()).append("(");
		deParse(factor.getFactor(2), sb).append(") {");
		return deParse(factor.getFactor(5), sb).append("}");
	}

	// E -> IF_HEAD IF_TAIL
	private StringBuilder deParse27IfElse(Item factor, StringBuilder sb) {
		sb.append(factor.getFactor(0).getFullLexValue()).append("(");
		deParse(factor.getFactor(2), sb).append(") {");
		deParse(factor.getFactor(5), sb).append("} ");
		sb.append(factor.getFactor(7).getFullLexValue()).append(" {");
		return deParse(factor.getFactor(9), sb).append("}");
	}

	// E -> while ( E ) { SL }
	private StringBuilder deParse30While(Item factor, StringBuilder sb) {
		sb.append(factor.getFactor(0).getFullLexValue()).append(" (");
		deParse(factor.getFactor(2), sb).append(") {");
		return deParse(factor.getFactor(5), sb).append("}");
	}

	// E -> E = E
	private StringBuilder deParse31SetValue(Item factor, StringBuilder sb) {
		sb.append(factor.getFactor(0).getFullLexValue()).append(" = ");
		return deParse(factor.getFactor(2), sb);
	}

	// E -> return E
	private StringBuilder deParse32Return(Item factor, StringBuilder sb) {
		sb.append(factor.getFactor(0).getFullLexValue()).append(" ");
		return deParse(factor.getFactor(1), sb);
	}
}
