package com.bokesoft.yes.helper;

import com.bokesoft.yes.meta.persist.dom.AbstractSave;
import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaActionMap;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public final class MetaObjectHelper {

    private static Function<String, IMetaResolver> resolverCreator = basePath -> new IMetaResolver() {
        @Override
        public InputStream read(String resource, int type) throws Exception {
            String resourcePath = this.getPath(resource);
            File resourceFile = FileUtils.getFile(resourcePath);
            return FileUtils.openInputStream(resourceFile);
        }

        @Override
        public boolean write(String resource, byte[] data) throws Exception {
            String resourcePath = this.getPath(resource);
            File resourceFile = FileUtils.getFile(resourcePath);
            if (!resourceFile.exists()) {
                //noinspection ResultOfMethodCallIgnored
                resourceFile.createNewFile();
            }
            FileUtils.writeByteArrayToFile(resourceFile, data);
            return true;
        }

        @Override
        public int listResource(String resource, String flag, List<String> resources, List<String> names, List<Boolean> flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isListAbsolutePath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPath(String resource) {
            return basePath + File.separatorChar + resource;
        }

        @Override
        public URI getURI(String resource, int type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char getSeparator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JSONObject readProfile(String resource, int type) {
            throw new UnsupportedOperationException();
        }
    };

    public static <T extends Serializable> T clone(final T object) throws Exception {
        //noinspection unchecked
        T copyObject = (T) object.getClass().newInstance();
        BeanUtils.copyProperties(object, copyObject);
        return copyObject;
    }

    public static <T extends AbstractMetaObject> T deptClone(final T object) {
        return (T) object.depthClone();
    }

    public static <T extends AbstractSave> void saveToXml(AbstractMetaObject metaObject, String basePath, String resource, Class<T> saverClass) throws Exception {
        IMetaResolver metaResolver = resolverCreator.apply(basePath);
        Constructor<T> constructor = saverClass.getConstructor(AbstractMetaObject.class);
        T metaSaver = constructor.newInstance(metaObject);
        metaSaver.save(metaResolver, resource);
    }

    public static <T extends AbstractSave> void saveToXml(AbstractMetaObject metaObject, String basePath, String resource, MetaActionMap metaActionMap) throws Exception {
        Supplier<AbstractSave> saverSupplier = () -> new AbstractSave(metaObject) {
            @Override
            protected IMetaActionMap getActionMap() {
                return metaActionMap;
            }
        };

        IMetaResolver resolver = resolverCreator.apply(basePath);
        AbstractSave metaSaver = saverSupplier.get();
        metaSaver.save(resolver, resource);
    }
}