package com.bokesoft.yes.helper;

import com.bokesoft.yes.mid.base.CoreSetting;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.io.IOException;

public final class FilePathHelper {
    private static String workspacePath;
    private static String coreSolutionPath;
    
    private static String targetSolutionPath;
    public static final void setTargetSolutionPath(String targetSolutionPath){
        FilePathHelper.targetSolutionPath = targetSolutionPath;
    }

    public static String toBackFilePath(String filePath) {
        if (StringUtils.isBlank(filePath)) {
            return "";
        }
        return filePath.replace("\\\\", File.separator)
                .replace('\\', File.separatorChar)
                .replace('/', File.separatorChar);
    }

    public static String toFrontFilePath(String filePath) {
        if (StringUtils.isBlank(filePath)) {
            return "";
        }
        return filePath.replace("/", File.separator)
                .replace("\\\\", File.separator)
                .replace(File.separator, "\\");
    }

    public static String getCoreSolutionPath() throws IOException {
        if (StringUtils.isBlank(coreSolutionPath)) {
            initPath();
        }
        return coreSolutionPath;
    }

    public static String getWorkspacePath() throws IOException {
        if (StringUtils.isBlank(workspacePath)) {
            initPath();
        }
        return workspacePath;
    }

    private static void initPath() throws IOException {
        String solutionPath;
        if (null==targetSolutionPath){
            solutionPath = FilePathHelper.toBackFilePath(CoreSetting.getInstance().getSolutionPath());
        }else{
            solutionPath = targetSolutionPath;
        }
        File solutionFile = FileUtils.getFile(solutionPath);

        coreSolutionPath = solutionFile.getCanonicalPath();
        workspacePath = solutionFile.getParentFile().getCanonicalPath();
    }
}
