package com.bokesoft.yes.design.xml.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.bokesoft.yes.common.util.StringUtil;

public class Util {
	public static int getBeginIndex(String xml) {
		return Ignorer.getXmlBeginIndex(xml);
	}

	public static String deleteXmlHead(String xml) {
		if (Objects.isNull(xml)) {
			return null;
		}

		int c = getBeginIndex(xml);
		if (c > 0) {
			return xml.substring(c);
		}
		return xml;
	}

	public static List<Element> getElements(String xml) {
		if (Objects.isNull(xml)) {
			return null;
		}

		// xml = deleteXmlHead(xml);

		List<Element> list = new ArrayList<Element>();
		int ix = getBeginIndex(xml);
		int maxIndex = xml.length();

		while (ix < maxIndex) {
			Element ele = getNextElement(xml, ix);
			list.add(ele);
			ix = ele.getEndIndex() + 1;
		}

		return list;
	}

	public static Element getNextElement(String xml, int bg) {
		for (int i = bg; i < xml.length(); i++) {
			char c = xml.charAt(i);

			if (c != '<') {
				continue;
			}
			if (i != bg) {
				Element ele = new Element();
				ele.setBgIndex(bg);
				ele.setType(1);
				ele.setText(xml.substring(bg, i));
				ele.setEndIndex((i - 1));
				return ele;
			}

			if (StringUtil.isString(xml, "</", i)) {
				return PrivateUtil.getEndTag(xml, i);
			}
			if (StringUtil.isString(xml, "<!--", i)) {
				return PrivateUtil.getComment(xml, i);
			}
			if (StringUtil.isString(xml, "<![CDATA[", i)) {
				return PrivateUtil.getCDATA(xml, i);
			}
			if (StringUtil.isString(xml, "<!DOCTYPE", i)) {
				return PrivateUtil.getDTD(xml, i);
			}

			return PrivateUtil.getStartTag(xml, i);
		}

		Element ele = new Element();
		ele.setBgIndex(bg);
		ele.setType(1);
		ele.setEndIndex((xml.length() - 1));
		ele.setText(xml.substring(bg));

		return ele;
	}

	public String deleteNotUse(String xml) {
		return xml;
	}
}