package com.bokesoft.yes.design.xml.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.xml.parse.Element;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractNode {

	protected String text = null;
	
	private TagNode parent = null;
	
	private final Element ele;
	
	public AbstractNode(String text, Element ele) {
		this.text = text;
		this.ele = ele;
	}
	
	public String getText() {
		return text;
	}
	
	public Element getElement() {
		return ele;
	}
	
	public void appendLevelBlank(StringBuilder strBuilder, int level) {
		for (int i = 0; i < level; i++) {
			strBuilder.append("    ");
		}
	}
	
	public abstract String toXml(int level);

	public String toXml(int level, boolean escape) {
		return this.toXml(level);
	}
	
	@Override
    public abstract AbstractNode clone();
	
	public abstract boolean hasPrimaryAttribute();
	
	public TagNode getParent() {
		return this.parent;
	}

	public void setParent(TagNode parent) {
		this.parent = parent;
	}
	
	public boolean isRoot() {
		return Objects.isNull(this.parent);
	}
	
	private List<AbstractNode> preCommnetList = null;

	private List<AbstractNode> lastCommnetList = null;
	
	public void addPreComment(List<AbstractNode> comments) {
		if (CollectionUtils.isEmpty(comments)) {
			return;
		}
		if (Objects.isNull(preCommnetList)) {
			preCommnetList = new ArrayList<AbstractNode>();
		}
		for (AbstractNode node : comments) {
			preCommnetList.add(node);
		}
	}
	
	public void addLastComment(List<AbstractNode> comments) {
		if (CollectionUtils.isEmpty(comments)) {
			return;
		}
		if (Objects.isNull(lastCommnetList)) {
			lastCommnetList = new ArrayList<AbstractNode>();
		}
		for (AbstractNode node : comments) {
			lastCommnetList.add(node);
		}
	}
	
	public List<AbstractNode> getPreComment() {
		return preCommnetList;
	}

	public List<AbstractNode> getLastComment() {
		return lastCommnetList;
	}

	protected String convertSpecialChars(String str, boolean escape) {
		if (escape) {
			str = StringUtil.replaceAll(str, "&", "&amp;");
			str = StringUtil.replaceAll(str, "<", "&lt;");
			str = StringUtil.replaceAll(str, ">", "&gt;");
			//str = StringUtil.replaceAll(str, "'", "&apos;");
			str = StringUtil.replaceAll(str, "\"", "&quot;");
		}
		return str;
	}
}
