package com.bokesoft.yes.design.xml.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import com.bokesoft.yes.common.log.LogSvr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;

public abstract class XMLPropertyBagBaseObject implements IXMLPropertyBag {
	private static final Long serialVersionUID = 1L;
	protected transient XMLPropertyBagBaseObject parentItem = null;

	public void setParentItem(XMLPropertyBagBaseObject parentItem) {
		this.parentItem = parentItem;
	}

	public XMLPropertyBagBaseObject getParentItem() {
		return parentItem;
	}

	public abstract String getMetaName();

	public XMLPropertyBagBaseObject deepClone() throws Throwable {
		XMLPropertyBagBaseObject result = null;
		try {
			result = this.getClass().newInstance();
			result.setParentItem(this.parentItem);
		} catch (IllegalArgumentException e) {
			LogSvr.getInstance().error(e.getMessage(), e);
		} catch (SecurityException e) {
			LogSvr.getInstance().error(e.getMessage(), e);
		} catch (InstantiationException e) {
			LogSvr.getInstance().error(e.getMessage(), e);
		} catch (IllegalAccessException e) {
			LogSvr.getInstance().error(e.getMessage(), e);
		}
		if (result instanceof Externalizable) {
			ObjectInputStream in = null;
			ObjectOutputStream out = null;
			try {
				ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
				out = new ObjectOutputStream(baos);
				((Externalizable) this).writeExternal(out);
				out.flush();
				byte[] bytes = baos.toByteArray();
				ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
				in = new ObjectInputStream(bais);
				((Externalizable) result).readExternal(in);
			} catch (Throwable e) {
				throw new Exception("");
			} finally {
				if (out != null) {
					try {
						out.close();
					} catch (IOException e) {
					}
				}
				if (in != null) {
					try {
						in.close();
					} catch (IOException e) {
					}
				}
			}
		} else {
			Document doc = DomHelper.createDocument();
			Element root = null;
			root = doc.createElement("PropertyBag");
			doc.appendChild(root);
			XMLPropertyBag.writeProperties(doc, this.getMetaName(), root, this, 1);
			XMLPropertyBag.readProperties(doc, this.getMetaName(), root, result, 1);
		}
		return result;
	}
}
