package com.bokesoft.yes.design.xml.dom;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import com.bokesoft.yes.common.log.LogSvr;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.common.util.DebugUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.util.HashMapKeyIgnoreCase;
import com.bokesoft.yes.util.LinkedHashMapKeyIgnoreCase;

class XMLItem {
	public Document document;

	public Element root;

	public XMLItem(Document initDocument, Element initRoot) {
		document = initDocument;
		root = initRoot;
	}
}

/**
 * billmeta相关xml的property解析工具
 * 
 * 
 */
public class XMLPropertyBag {

	private static final String vartype = "VARTYPE";
	private static final String nothing = "NOTHING";
	// read children according key
	// If key is empty, read all child,else read elements which match key
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static void readProperties(Document doc, String key, Element element, Class<?> cls, XMLPropertyBagBaseObject parent,
			ArrayList arr, int flag) throws Throwable {
		arr.clear();
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				if (key.length() != 0 && !node.getNodeName().equalsIgnoreCase(key)) {
					continue;
				}
				Object o = null;
				if (!(elm.getAttributes().getLength() == 1 && elm.hasAttribute(vartype)
						&& elm.getAttribute(vartype).equals(nothing))) { // 这种表示VB中的Nothing,在Java中表示null
					try {
						o = cls.newInstance();
					} catch (Throwable e) {
						LogSvr.getInstance().error(e.getMessage(), e);
					}
					if (Objects.isNull(o)) {
						return;
					}
					XMLPropertyBagBaseObject bag = (XMLPropertyBagBaseObject) o;
					bag.setParentItem(parent);
					bag.ReadProperties(doc, elm, flag);
				}
				arr.add(o);
			}
		}
	}

	public static List<Element> enumChildren(Document doc, Element element, String tagName) {
		ArrayList<Element> arrChild = new ArrayList<Element>();
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				if (elm.getTagName().equalsIgnoreCase(tagName)) {
					arrChild.add(elm);
				}
			}
		}
		return arrChild;
	}

	public static final boolean THROW_EX = true;

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static void readProperties(Document doc, Element element, HashMapKeyIgnoreCase<Class> metaNameToClass,
			XMLPropertyBagBaseObject parent, LinkedHashMapKeyIgnoreCase map, int flag) throws Throwable {
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				Object o = null;
				try {
					Class<?> cls = metaNameToClass.get(node.getNodeName());
					o = cls.newInstance();
				} catch (InstantiationException e) {
					if (THROW_EX) {
						throw new InstantiationException();
					}
				} catch (IllegalAccessException e) {
					if (THROW_EX) {
						throw new IllegalAccessException();
					}
				} catch (Throwable e) {
					if (THROW_EX) {
						throw new Exception();
					} else {
						continue;
					}
				}
				if (Objects.isNull(o)) {
					return;
				}
				KeyPairBaseObject ko = (KeyPairBaseObject) o;
				XMLPropertyBagBaseObject bag = (XMLPropertyBagBaseObject) o;
				bag.setParentItem(parent);
				bag.ReadProperties(doc, elm, flag);
				map.put(ko.getKey(), ko);
			}
		}
	}

	// read children according key
	// If key is empty, read all child,else read elements which match key
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static void readProperties(Document doc, String key, Element element, Class<?> cls, XMLPropertyBagBaseObject parent,
			LinkedHashMapKeyIgnoreCase map, int flag) throws Throwable {
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				Object o = null;
				try {
					String nodeName = node.getNodeName();
					if (key.length() != 0 && !nodeName.equalsIgnoreCase(key)) {
						continue;
					}
					o = cls.newInstance();
				} catch (InstantiationException e) {
					if (THROW_EX) {
						throw new InstantiationException();
					}
				} catch (IllegalAccessException e) {
					if (THROW_EX) {
						throw new Exception();
					}
				} catch (Throwable e) {
					if (THROW_EX) {
						throw new Exception();
					} else {
						continue;
					}
				}
				if (Objects.isNull(o)) {
					return;
				}
				KeyPairBaseObject ko = (KeyPairBaseObject) o;
				XMLPropertyBagBaseObject bag = (XMLPropertyBagBaseObject) o;
				bag.setParentItem(parent);
				bag.ReadProperties(doc, elm, flag);
				if (map.containsKey(ko.getKey())) {
					throw new Exception("配置对象Key重复,对象" + map.get(ko.getKey()) + "和对象" + ko + "的Key值" + ko.getKey() + "重复,请检查配置.");
				}
				map.put(ko.getKey(), ko);
			}
		}
	}

	/**
	 * 根据XML结构中的位置去读取配置对象
	 * 
	 * @param doc
	 * @param key XML结构中的位置
	 * @param element
	 * @param bag
	 * @param flag
	 * @return
	 * @throws Throwable
	 */
	public static IXMLPropertyBag readProperties(Document doc, int key, Element element, IXMLPropertyBag bag, int flag) throws Throwable {
		if (Objects.isNull(bag)) {
			return null;
		}
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		if (key >= children.getLength()) {
			throw new RuntimeException("数据读取错误");
		}
		node = children.item(key);
		if (node instanceof Element) {
			elm = (Element) node;
			if (elm.getAttributes().getLength() == 1 && elm.hasAttribute(vartype) && elm.getAttribute(vartype).equals(nothing)) { // 这种表示VB中的Nothing,在Java中表示null
				return null;
			} else {
				bag.ReadProperties(doc, elm, flag);
				return bag;
			}
		}
		return null;
	}

	public static void readProperties(Document doc, String key, Element element, IXMLPropertyBag bag, int flag) throws Throwable {
		// try {
		if (Objects.isNull(bag)) {
			return;
		}
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				if (elm.getNodeName().equalsIgnoreCase(key)) {
					bag.ReadProperties(doc, elm, flag);
				}
			}
		}
	}

	/**
	 * 取子对象
	 * 
	 * @param doc
	 * @param key
	 * @param element
	 * @param cls
	 * @param parentItem
	 * @param flag
	 * @return
	 * @throws Throwable
	 */
	public static IXMLPropertyBag readProperties(Document doc, String key, Element element, Class<?> cls,
			XMLPropertyBagBaseObject parentItem, int flag) throws Throwable {
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				if (elm.getNodeName().equalsIgnoreCase(key)) {
					XMLPropertyBagBaseObject bag;
					try {
						bag = (XMLPropertyBagBaseObject) cls.newInstance();
					} catch (InstantiationException e) {
						throw new InstantiationException();
					} catch (IllegalAccessException e) {
						throw new IllegalAccessException();
					}
					bag.setParentItem(parentItem);
					bag.ReadProperties(doc, elm, flag);
					return bag;
				}
			}
		}
		return null;
	}

	public static void readPropertie(Document doc, String key, Element element, Class<?> cls, XMLPropertyBagBaseObject parent,
			XMLPropertyBagBaseObject o, int flag) throws Throwable {
		ArrayList<XMLPropertyBagBaseObject> arr = new ArrayList<XMLPropertyBagBaseObject>();
		readProperties(doc, key, element, cls, parent, arr, flag);
	}

	public static void writeProperties(Document doc, String key, Element element, ArrayList<?> arr, int flag) throws Throwable {
		Iterator<?> it = arr.iterator();
		int index = 0; // Integer.valueOf(0);
		while (it.hasNext()) {
			Element el = doc.createElement(key);
			Object o = it.next();
			if (o != null) {
				IXMLPropertyBag bag = (IXMLPropertyBag) o;
				bag.WriteProperties(doc, el, flag);
			} else {
				el.setAttribute(vartype, nothing);
			}
			if (!key.equalsIgnoreCase("RichDocument") && !key.equalsIgnoreCase("Menu") && !key.equalsIgnoreCase("Command")) { // 因为VB版本的BillDocumentArray中保存BillDocument时没有保存Index,对于Nothing需要根据Attribute的数量为1来判断
				el.setAttribute("Index", "" + index);
			}
			index += 1;
			element.appendChild(el);
		}
	}

	public static void writeProperties(Document doc, Element element, LinkedHashMapKeyIgnoreCase<?> map, int flag) throws Throwable {
		Collection<?> col = map.values();
		Iterator<?> it = col.iterator();
		while (it.hasNext()) {
			Object o = it.next();
			XMLPropertyBagBaseObject bag = (XMLPropertyBagBaseObject) o;
			Element el = doc.createElement(bag.getMetaName());
			bag.WriteProperties(doc, el, flag);
			element.appendChild(el);
		}
	}

	public static void writeProperties(Document doc, String key, Element element, IXMLPropertyBag bag, int flag) throws Throwable {
		if (Objects.isNull(bag)) {
			return;
		}
		Element elm = doc.createElement(key);
		bag.WriteProperties(doc, elm, flag);
		element.appendChild(elm);
	}

	public static <T> void writePropertie(Document doc, String key, Element element, T o, int flag) throws Throwable {
		ArrayList<T> arr = new ArrayList<T>();
		arr.add(o);
		writeProperties(doc, key, element, arr, flag);
	}

	/**
	 * 这个方法极大地减少了String对象在内存中的数量
	 * 
	 * @param s
	 * @return String
	 */
	public static String getCachedString(String s) {
		if (StringUtils.isBlank(s)) {
			return null;
		}
		return s.intern();
	}

	/**
	 * 取字符串Attribute,返回的字符串没做缓冲(做缓冲的目的是为了减少内容相同的String对象)
	 * 
	 * @param element
	 * @param name
	 * @param defaultValue
	 * @return
	 */
	public static String readAttribute(Element element, String name, String defaultValue) {
		String s = readAttributeNoCache(element, name, defaultValue);
		if (StringUtils.isBlank(s)) {
			return null;
		}
		return getCachedString(s);
	}

	/**
	 * 读取文本,先从CDATA节点中读取,如果读不到,再从属性中读取
	 * 
	 * @param element
	 * @param name
	 * @param defaultValue
	 * @return
	 */
	public static String readTextCDataOrAttribute(Element element, String name, String defaultValue) {
		String s = readNamedCDATAContent(element, name, defaultValue);
		if (StringUtils.isBlank(s) || s.equalsIgnoreCase(defaultValue)) {
			s = readAttributeNoCache(element, name, defaultValue);
		}
		return s;
	}

	/**
	 * 从命名的子节点中取得CDATA中的内容
	 * 
	 * @param element
	 * @param name
	 * @param defaultValue
	 * @return
	 */
	public static String readNamedCDATAContent(Element element, String name, String defaultValue) {
		String value = defaultValue;
		NodeList childList = element.getChildNodes();
		int length = childList.getLength();
		for (int i = 0; i < length; ++i) {
			Node child = childList.item(i);

			if (child instanceof Element) {
				Element elementChild = (Element) child;
				if (elementChild.getTagName().equalsIgnoreCase(name)) {
					value = elementChild.getTextContent();
					break;
				}
			}
		}
		return value;
	}

	/**
	 * 在当前节点下创建一个命名的CDATA
	 * 
	 * @param doc
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeNamedCDATAContent(Document doc, Element element, String name, String value, String defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equalsIgnoreCase(defaultValue)) {
			return;
		}
		Element dataElement = doc.createElement(name);
		element.appendChild(dataElement);
		CDATASection attrElement = doc.createCDATASection(value);
		dataElement.appendChild(attrElement);
	}

	/**
	 * 取字符串Attribute,返回的字符串做缓冲(做缓冲的目的是为了减少内容相同的String对象)
	 * 
	 * @param element
	 * @param name
	 * @param defaultValue
	 * @return
	 */
	public static String readAttributeNoCache(Element element, String name, String defaultValue) {
		Attr attr = element.getAttributeNode(name);
		if (Objects.isNull(attr)) {
			return defaultValue;
		}
		String attrValue = attr.getNodeValue();
		if (StringUtils.isBlank(defaultValue)) {
			return attrValue;
		}
		return (StringUtil.isBlankOrNull(attrValue)) ? defaultValue : attrValue;
	}

	public static String readAttribute(Element element, String name, String defaultValue, boolean allowBlank) {
		return getCachedString(readAttributeNoCache(element, name, defaultValue, allowBlank));
	}

	public static String readAttributeNoCache(Element element, String name, String defaultValue, boolean allowBlank) {
		String value;
		Attr attr = element.getAttributeNode(name);
		if (StringUtils.isBlank(defaultValue) && Objects.isNull(attr)) {
			return null;
		}
		if ((attr != null && attr.getNodeValue().length() == 0) && allowBlank) {
			return "";
		}
		value = (Objects.isNull(attr) || StringUtil.isBlankOrNull(attr.getNodeValue())) ? defaultValue : attr.getNodeValue();
		if (StringUtils.isBlank(value) && attr != null) {
			value = Objects.isNull(attr.getNodeValue()) ? defaultValue : attr.getNodeValue();
		}
		return value;
	}

	/**
	 * 取字符串Element,返回的字符串没做缓冲(做缓冲的目的是为了减少内容相同的String对象)
	 * 
	 * @param element
	 * @param name
	 * @param defaultValue
	 * @return
	 */
	public static String readElementNoCache(Element element, String name, String defaultValue) {
		String value = readElementNoCache(element, name);
		if (Objects.isNull(value)) {
			value = defaultValue;
		}
		return value;
	}

	private static String readElementNoCache(Element element, String name) {
		String value = "";
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				if (elm.getNodeName().equalsIgnoreCase(name)) {
					// DebugUtil.debug(">" + elm.getClass() + "," + name);
					// 获取标签内文本
					value = elm.getTextContent();
					break;
				}
			}
		}

		return value;
	}

	/**
	 * 取字符串Element,返回的字符串做缓冲(做缓冲的目的是为了减少内容相同的String对象)
	 * 
	 * @param element
	 * @param name
	 * @param defaultValue
	 * @return
	 */
	public static String readElement(Element element, String name, String defaultValue) {
		return getCachedString(readElementNoCache(element, name, defaultValue));
	}

	// public static Integer readAttribute(Element element, String name, Integer
	// defaultValue)
	// {
	// Integer value;
	// Attr attr = element.getAttributeNode(name);
	// if ( Objects.isNull(defaultValue) && Objects.isNull(attr) )
	// {
	// return null;
	// }
	// value = Objects.isNull(attr) ? defaultValue :
	// Integer.parseInt(attr.getNodeValue());
	// return value;
	// }

	public static Integer readElement(Element element, String name, Integer defaultValue) {
		String sValue = readElementNoCache(element, name);
		if (Objects.isNull(sValue)) {
			return defaultValue;
		} else {
			return Integer.parseInt(sValue);
		}
	}

	public static Boolean readElement(Element element, String name, Boolean defaultValue) {
		String sValue = readElementNoCache(element, name);
		if (Objects.isNull(sValue)) {
			return defaultValue;
		} else {
			return Boolean.parseBoolean(sValue);
		}
	}

	public static int readAttributeInt(Element element, String name, int defaultValue) {
		Attr attr = element.getAttributeNode(name);
		if (Objects.isNull(attr)) {
			return defaultValue;
		}
		if (StringUtil.isBlankOrNull(attr.getNodeValue())) {
			return 0;
		}
		return Integer.parseInt(attr.getNodeValue());
	}

	public static int readElement(Element element, String name, int defaultValue) {
		String sValue = readElementNoCache(element, name);
		if (StringUtils.isBlank(sValue)) {
			return defaultValue;
		} else {
			return Integer.parseInt(sValue);
		}
	}

	public static Short readAttribute(Element element, String name, Short defaultValue) {
		Short value;
		Attr attr = element.getAttributeNode(name);
		if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
			return null;
		}
		value = Objects.isNull(attr) ? defaultValue : Short.parseShort(attr.getNodeValue());
		return value;
	}

	public static Short readElement(Element element, String name, Short defaultValue) {
		Short value = null;
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				if (elm.getNodeName().equalsIgnoreCase(name)) {
					value = Short.parseShort(elm.getNodeValue());
				}
			}
		}
		if (Objects.isNull(value)) {
			value = defaultValue;
		}
		return value;
	}

	public static BigDecimal readAttribute(Element element, String name, BigDecimal defaultValue) {
		BigDecimal value;
		Attr attr = element.getAttributeNode(name);
		if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
			return null;
		}
		value = Objects.isNull(attr) ? defaultValue : new BigDecimal(attr.getNodeValue());
		return value;
	}

	public static BigDecimal readElement(Element element, String name, BigDecimal defaultValue) {
		BigDecimal value = null;
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				if (elm.getNodeName().equalsIgnoreCase(name)) {
					value = new BigDecimal(elm.getNodeValue());
				}
			}
		}
		if (Objects.isNull(value)) {
			value = defaultValue;
		}
		return value;
	}

	public static Float readAttribute(Element element, String name, Float defaultValue) {
		Float value;
		Attr attr = element.getAttributeNode(name);
		if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
			return null;
		}
		value = Objects.isNull(attr) ? defaultValue : Float.parseFloat(attr.getNodeValue());
		return value;
	}

	public static Float readElement(Element element, String name, Float defaultValue) {
		Float value = null;
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				if (elm.getNodeName().equalsIgnoreCase(name)) {
					value = Float.parseFloat(elm.getNodeValue());
				}
			}
		}
		if (Objects.isNull(value)) {
			value = defaultValue;
		}
		return value;
	}

	public static Double readAttribute(Element element, String name, Double defaultValue) {
		Double value;
		Attr attr = element.getAttributeNode(name);
		if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
			return null;
		}
		value = Objects.isNull(attr) ? defaultValue : Double.parseDouble(attr.getNodeValue());
		return value;
	}

	public static Double readElement(Element element, String name, Double defaultValue) {
		Double value = null;
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				if (elm.getNodeName().equalsIgnoreCase(name)) {
					value = Double.parseDouble(elm.getNodeValue());
				}
			}
		}
		if (Objects.isNull(value)) {
			value = defaultValue;
		}
		return value;
	}

	public static Boolean readAttribute(Element element, String name, Boolean defaultValue) {
		Boolean value;
		Attr attr = element.getAttributeNode(name);
		if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
			return false;
		}
		value = Objects.isNull(attr) ? defaultValue : Boolean.parseBoolean(attr.getNodeValue());
		return value;
	}

	public static Date readAttribute(Element element, String name, Date defaultValue) {
		Date value;
		Attr attr = element.getAttributeNode(name);
		if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
			return null;
		}
		try {
			value = Objects.isNull(attr) ? defaultValue : DateUtil.getDate(attr.getNodeValue());
		} catch (Throwable e) {
			LogSvr.getInstance().error(e.getMessage(), e);
			return null;
		}

		return value;
	}

	public static Date readElement(Element element, String name, Date defaultValue) {
		Date value = null;
		NodeList children = element.getChildNodes();
		Node node;
		Element elm;
		int length = children.getLength();
		for (int i = 0; i < length; ++i) {
			node = children.item(i);
			if (node instanceof Element) {
				elm = (Element) node;
				if (elm.getNodeName().equalsIgnoreCase(name)) {
					try {
						value = DateFormat.getInstance().parse(elm.getNodeValue());
					} catch (DOMException e) {
						LogSvr.getInstance().error(e.getMessage(), e);
					} catch (ParseException e) {
						LogSvr.getInstance().error(e.getMessage(), e);
					}
				}
			}
		}
		if (Objects.isNull(value)) {
			value = defaultValue;
		}
		return value;
	}

	// Write
	public static void writeAttribute(Element element, String name, String value, String defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equalsIgnoreCase(defaultValue)) {
			return;
		}
		element.setAttribute(name, value);
	}

	/**
	 * 考虑defaultValue大小写，用于BillMetaUICommon中的VisibleWhen 和 EnabledWhen 属性
	 * 
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeAttributeCase(Element element, String name, String value, String defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		element.setAttribute(name, value);
	}

	/**
	 * 保存文本,如果文本中有\n\t<>&;\"'这些字符,保存为CDATA的element,否则保存为attribute
	 * 
	 * @param doc
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeTextCDataOrAttribute(Document doc, Element element, String name, String value, String defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equalsIgnoreCase(defaultValue)) {
			return;
		}
		if (StringUtils.containsAny(value, "\n\t<>&;\"'")) {
			Element dataElement = doc.createElement(name);
			element.appendChild(dataElement);
			CDATASection attrElement = doc.createCDATASection(value);
			dataElement.appendChild(attrElement);
		} else {
			element.setAttribute(name, value);
		}
	}

	/**
	 * 不带默认值的写属性
	 * 
	 * @param element
	 * @param name
	 * @param value
	 */
	public static void writeAttribute(Element element, String name, String value) {
		if (Objects.isNull(value)) {
			value = "";
		}
		element.setAttribute(name, value);
	}

	/**
	 * @param doc
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeElement(Document doc, Element element, String name, String value, String defaultValue) {
		if (value != null && value.equalsIgnoreCase(defaultValue)) {
			return;
		}
		writeElement(doc, element, name, value);
	}

	/**
	 * @param doc
	 * @param element
	 * @param name
	 * @param value
	 */
	public static void writeElement(Document doc, Element element, String name, String value) {
		if (Objects.isNull(value)) {
			value = "";
		}
		Element el = doc.createElement(name);
		if (value.indexOf('<') > 0 || value.indexOf('>') > 0) {
			CDATASection cdata = doc.createCDATASection(value);
			el.appendChild(cdata);
		} else {
			el.setTextContent(value);
		}
		element.appendChild(el);
	}

	public static void writeAttribute(Element element, String name, Integer value, Integer defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (defaultValue != null) {
			if (value.equals(defaultValue)) {
				return;
			}
		}
		element.setAttribute(name, value.toString());
	}

	public static void writeElement(Document doc, Element element, String name, Integer value, Integer defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		Element el = doc.createElement(name);
		el.setTextContent(value.toString());
		element.appendChild(el);
	}

	public static void writeAttribute(Element element, String name, Long value, Long defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		element.setAttribute(name, value.toString());
	}

	public static void writeElement(Document doc, Element element, String name, int value, int defaultValue) {
		if (value == defaultValue) {
			return;
		}
		writeElement(doc, element, name, value);
	}

	public static void writeElement(Document doc, Element element, String name, int value) {
		Element el = doc.createElement(name);
		el.setTextContent(String.valueOf(value));
		element.appendChild(el);
	}

	public static void writeAttribute(Element element, String name, Short value, Short defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		element.setAttribute(name, value.toString());
	}

	public static void writeElement(Document doc, Element element, String name, Short value, Short defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		Element el = doc.createElement(name);
		el.setTextContent(value.toString());
		element.appendChild(el);
	}

	/**
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeAttribute(Element element, String name, BigDecimal value, BigDecimal defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		element.setAttribute(name, value.toString());
	}

	/**
	 * @param doc
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeElement(Document doc, Element element, String name, BigDecimal value, BigDecimal defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		Element el = doc.createElement(name);
		el.setTextContent(value.toString());
		element.appendChild(el);
	}

	/**
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeAttribute(Element element, String name, Float value, Float defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		element.setAttribute(name, value.toString());
	}

	/**
	 * @param doc
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeElement(Document doc, Element element, String name, Float value, Float defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		Element el = doc.createElement(name);
		el.setTextContent(value.toString());
		element.appendChild(el);
	}

	/**
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeAttribute(Element element, String name, Double value, Double defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		element.setAttribute(name, value.toString());
	}

	/**
	 * @param doc
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeElement(Document doc, Element element, String name, Double value, Double defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		Element el = doc.createElement(name);
		el.setTextContent(value.toString());
		element.appendChild(el);
	}

	/**
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeAttribute(Element element, String name, Boolean value, Boolean defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		String ret = value ? "True" : "False";
		element.setAttribute(name, ret);
	}

	/**
	 * @param doc
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeElement(Document doc, Element element, String name, boolean value, boolean defaultValue) {
		if (value == defaultValue) {
			return;
		}
		writeElement(doc, element, name, value);
	}

	/**
	 * @param doc
	 * @param element
	 * @param name
	 * @param value
	 */
	public static void writeElement(Document doc, Element element, String name, boolean value) {
		Element el = doc.createElement(name);
		el.setTextContent(String.valueOf(value));
		element.appendChild(el);
	}

	/**
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeAttribute(Element element, String name, Date value, Date defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		element.setAttribute(name, value.toString());
	}

	/**
	 * @param doc
	 * @param element
	 * @param name
	 * @param value
	 * @param defaultValue
	 */
	public static void writeElement(Document doc, Element element, String name, Date value, Date defaultValue) {
		if (Objects.isNull(value)) {
			return;
		}
		if (value.equals(defaultValue)) {
			return;
		}
		Element el = doc.createElement(name);
		el.setTextContent(value.toString());
		element.appendChild(el);
	}

	public static boolean readLocalProperties(String fileName, String rootNode, String key, IXMLPropertyBag bag, int flag)
			throws Throwable {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = null;
		try {
			builder = factory.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			throw new ParserConfigurationException();
		}
		Document doc = null;
		File f = new File(fileName);
		if (!f.exists()) {
			DebugUtil.debug(">resolver==null.2");
			return false;
		}
		InputStream in = null;
		try {
			in = new FileInputStream(f);
			// if (Objects.isNull(in)) {
			// DebugUtil.debug(">Cannot resolver resource local.3. " + fileName);
			// return false;
			// }
//			if (!false) {
			doc = builder.parse(in);
//			} else {
//				org.apache.xerces.parsers.DOMParser domParse = new org.apache.xerces.parsers.DOMParser();
//				domParse.parse(new InputSource(in));
//				doc = domParse.getRichDocument();
//			}
		} catch (SAXException e) {
			DebugUtil.debug(">error.xml:" + fileName);
			LogSvr.getInstance().error(e.getMessage(), e);
			return false;
		} catch (Throwable e) {
			DebugUtil.debug(">error.xml:" + fileName);
			throw new Exception();
		} finally {
			if (in != null) {
				in.close();
			}
		}
		Element root = doc.getDocumentElement();
		XMLPropertyBag.readProperties(doc, key, root, bag, flag);
		return true;
	}

	/**
	 * @param fileName
	 * @param rootNode
	 * @param key
	 * @param bag
	 * @param flag
	 * @return boolean
	 * @throws Throwable
	 */
	public static boolean readProperties(IFileResolver resolver, String fileName, String rootNode, String key, IXMLPropertyBag bag,
			int flag, int resourceType) throws Throwable {
		XMLItem root = readRoot(resolver, fileName, rootNode, key, bag, flag, resourceType);
		if (root != null) {
			XMLPropertyBag.readProperties(root.document, key, root.root, bag, flag);
			return true;
		}
		return false;
	}

	public static boolean readObject(IFileResolver resolver, String fileName, String rootNode, String key, IXMLPropertyBag bag, int flag,
			int resourceType) throws Throwable {
		XMLItem root = readRoot(resolver, fileName, rootNode, key, bag, flag, resourceType);
		if (root != null) {
			bag.ReadProperties(root.document, root.root, flag);
			return true;
		}
		return false;
	}

	public static Document readDocument(String sFileName) throws Throwable {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = null;
		try {
			builder = factory.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			throw new ParserConfigurationException();
		}
		Document doc = null;
		InputStream in = null;
		try {
			in = new FileInputStream(sFileName);
			// if (Objects.isNull(in)) {
			// DebugUtil.debug(">Cannot resolver resource read.5. " + sFileName);
			// return null;
			// }
//			if (!false) {
			doc = builder.parse(in);
//			} else {
//				org.apache.xerces.parsers.DOMParser domParse = new org.apache.xerces.parsers.DOMParser();
//				domParse.parse(new InputSource(in));
//				doc = domParse.getRichDocument();
//			}
		} catch (SAXException e) {
			DebugUtil.debug(">error.xml:" + sFileName);
			LogSvr.getInstance().error(e.getMessage(), e);
			throw new SAXException("xml文件" + sFileName + "解析错误,请检查文件格式.", e);
		} catch (Throwable e) {
			DebugUtil.debug(">error.xml:" + sFileName);
			throw new Exception("xml文件" + sFileName + "解析错误,请检查文件格式.", e);
		} finally {
			if (in != null) {
				in.close();
			}
		}
		return doc;
	}

	private static XMLItem readRoot(IFileResolver resolver, String sFileName, String rootNode, String key, IXMLPropertyBag bag, int flag,
			int resourceType) throws Throwable {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = null;
		try {
			builder = factory.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			throw new ParserConfigurationException();
		}
		Document doc = null;
		if (Objects.isNull(resolver)) {
			DebugUtil.debug(">resolver==null.3");
			return null;
		}
		InputStream in = null;
		try {
			in = resolver.getInputStream(sFileName, resourceType);
			if (Objects.isNull(in)) {
				DebugUtil.debug(">Cannot resolver resource read.5. " + sFileName);
				return null;
			}
//			if (!false) {
				doc = builder.parse(in);
//			} else {
//				org.apache.xerces.parsers.DOMParser domParse = new org.apache.xerces.parsers.DOMParser();
//				domParse.parse(new InputSource(in));
//				doc = domParse.getRichDocument();
//			}
		} catch (SAXException e) {
			DebugUtil.debug(">error.xml:" + sFileName);
			throw new SAXException("xml文件" + sFileName + "解析错误,请检查文件格式.", e);
		} catch (Throwable e) {
			DebugUtil.debug(">error.xml:" + sFileName);
			throw new Exception("xml文件" + sFileName + "解析错误,请检查文件格式.", e);
		} finally {
			if (in != null) {
				in.close();
			}
		}
		Element root = doc.getDocumentElement();
		return new XMLItem(doc, root);
	}

	public static boolean writeLocalProperties(String fileName, String rootNode, String key, IXMLPropertyBag bag, int flag)
			throws Throwable {
		Document newDoc = createDocument();
		Element root = null;
		//		@SuppressWarnings("unused")
		//		Element secondary;
		if (StringUtils.isBlank(rootNode)) {
			rootNode = "PropertyBag";
		}
		root = newDoc.createElement(rootNode);
		newDoc.appendChild(root);

		XMLPropertyBag.writeProperties(newDoc, key, root, bag, 0);

		return writeLocalDocument(fileName, newDoc);
	}

	/**
	 * 
	 * @param fileName
	 * @param rootNode
	 * @param key
	 * @param bag
	 * @param flag
	 * @return
	 * @throws Throwable
	 * 
	 * @History 2009-8-28 - wangyh -
	 *          中间层的反射机制已经不使用,去掉,使用IFileResolver使配置的读取/保存不关心是否远程和本地
	 */
	public static boolean writeProperties(IFileResolver resolver, String fileName, String rootNode, String key, IXMLPropertyBag bag,
			int flag, int resourceType) throws Throwable {
		Document newDoc = createDocument();
		Element root = null;
		@SuppressWarnings("unused")
		Element secondary;
		if (StringUtils.isBlank(rootNode)) {
			rootNode = "PropertyBag";
		}
		root = newDoc.createElement(rootNode);
		newDoc.appendChild(root);
		XMLPropertyBag.writeProperties(newDoc, key, root, bag, 0);

		return writeDocument(resolver, fileName, newDoc, resourceType);
	}

	public static boolean writeObject(IFileResolver resolver, String fileName, String rootNode, String key, IXMLPropertyBag bag, int flag,
			int resourceType) throws Throwable {
		Document newDoc = createDocument();
		Element root = null;
		@SuppressWarnings("unused")
		Element secondary;
		if (StringUtils.isBlank(rootNode)) {
			rootNode = "PropertyBag";
		}
		root = newDoc.createElement(rootNode);
		newDoc.appendChild(root);
		bag.WriteProperties(newDoc, root, flag);
		return writeDocument(resolver, fileName, newDoc, resourceType);
	}

	private static Document createDocument() throws Throwable {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = null;
		try {
			builder = factory.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			throw new ParserConfigurationException();
		}
		Document newDoc = builder.newDocument();
		return newDoc;
	}

	private static boolean writeDocument(IFileResolver resolver, String fileName, Document document, int resourceType) throws Throwable {
		if (Objects.isNull(resolver)) {
			return false;
		}
		Transformer trans = null;
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		try {
			trans = TransformerFactory.newInstance().newTransformer();
		} catch (TransformerConfigurationException e) {
			throw new TransformerConfigurationException();
		} catch (TransformerFactoryConfigurationError e) {
			throw new TransformerFactoryConfigurationError();
		}

		try {
			trans.transform(new DOMSource(document), new StreamResult(out));
		} catch (TransformerException e) {
			throw new Exception();
		}

		try {
			resolver.write(fileName, out.toByteArray(), resourceType);
		} catch (Throwable e) {
			throw new Exception();
		}

		return true;
	}

	private static boolean writeLocalDocument(String fileName, Document document) throws Throwable {
		Transformer trans = null;
		try {
			trans = TransformerFactory.newInstance().newTransformer();
		} catch (TransformerConfigurationException e) {
			throw new TransformerConfigurationException();
		} catch (TransformerFactoryConfigurationError e) {
			throw new TransformerFactoryConfigurationError();
		}
		String uri = fileName;
		File f = new File(uri);
		try {
			trans.transform(new DOMSource(document), new StreamResult(new FileOutputStream(f)));
		} catch (FileNotFoundException e) {
			throw new FileNotFoundException();
		} catch (TransformerException e) {
			throw new Exception();
		}
		return true;
	}
}
