package com.bokesoft.yes.design.xml.dom;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.util.HashMapKeyIgnoreCase;
import com.bokesoft.yes.util.LinkedHashMapKeyIgnoreCase;

/**
 * 子节点有Key值的集合 这里为什么有要有IKeyPairObject,因为不知道为什么本来就有,
 * 另外BillMetaDataProcess要作为BillMetaDataProcessCollection的子节点
 */
@SuppressWarnings("rawtypes")
public abstract class GenericKeyCollection<T extends KeyPairBaseObject> extends KeyPairBaseObject implements Iterable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected GenericKeyCollection() {
	}

	/**
	 * @param ct
	 * @param xmlElmKey
	 */
	protected GenericKeyCollection(Class<T> ct, String xmlElmKey) {
		view = null;
		c = ct;
		XML_ELEMENTKEY = xmlElmKey;
		Elements = new LinkedHashMapKeyIgnoreCase<T>();
	}

	@Override
	public String getKey() {
		return null;
	}

	public void Add(T newItem) {
		if (Objects.isNull(newItem)) {
			return;
		}
		if (Objects.isNull(Elements)) {
			Elements = new LinkedHashMapKeyIgnoreCase<T>();
		}
		Elements.put(newItem.getKey(), newItem);
	}

	public void add(GenericKeyCollection<T> collection) {
		for (T t : collection.values()) {
			this.Add(t);
		}
	}

	public int Count() {
		return Elements.size();
	}

	public void Remove(String key) {
		Elements.remove(key);
	}

	/**
	 * 根据位置取集合中的内容,当集合中数据较多时这个方法性能极差,如果需要按顺序遍历,建议for (T t : XXX.values()),效率高多了
	 * 
	 * @param index
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public T Item(int index) {
		return (T) Elements.values().toArray()[index];
	}

	public T Item(String key) {
		return Elements.get(key);
	}

	/**
	 * 取不为空的子对象
	 * 
	 * @param key
	 * @return
	 */
	public T ItemNotNull(String key) {
		T t = Elements.get(key);
		if (Objects.isNull(t)) {
			throw new RuntimeException("集合中不存在Key为" + key + "的对象,集合为" + this + ".");
		}
		return t;
	}

	/**
	 * 判断是否存在Key
	 * 
	 * @param key
	 * @return boolean
	 */
	public boolean exists(String key) {
		return Elements.containsKey(key);
	}

//	/**
//	 * 判断是否存在对象
//	 * 
//	 * @param ct
//	 * @return boolean
//	 */
//	public boolean exists(Class<T> ct) {
//		return Elements.containsValue(ct);
//	}

	@SuppressWarnings("unchecked")
	@Override
	public Iterator<T> iterator() {
		view = Elements.values();
		return (Iterator<T>) view.iterator();
	}

	public Collection<T> values() {
		return Elements.values();
	}

	public void Clear() {
		Elements.clear();
	}

	public void ReadProperties(Document doc, Element element, HashMapKeyIgnoreCase<Class> metaNameToClass, int flag) throws Throwable {
		XMLPropertyBag.readProperties(doc, element, metaNameToClass, this, Elements, flag);
	}

	@Override
	public void ReadProperties(Document doc, Element element, int flag) throws Throwable {
		XMLPropertyBag.readProperties(doc, XML_ELEMENTKEY, element, c, this, Elements, flag);
	}

	@Override
	public void WriteProperties(Document doc, Element element, int flag) throws Throwable {
		XMLPropertyBag.writeProperties(doc, element, Elements, flag);
	}

	@Override
	public String toString() {
		return Elements.toString();
	}

	public LinkedHashMapKeyIgnoreCase<T> Elements;

	private Collection<?> view;

	private String XML_ELEMENTKEY;

	private Class<T> c;
}
