package com.bokesoft.yes.design.xml;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.xml.ex.XmlSyntaxException;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.CommentNode;
import com.bokesoft.yes.design.xml.node.DTDNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.TextNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yes.design.xml.parse.Util;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class XmlParser {

	private static boolean useComment = true;

	public static void setUseComment(boolean bool) {
		useComment = bool;
	}

	/**
	 * 根据文件内容生成Xml结构树，若文件解析错误，直接报错
	 *
	 * @param xml
	 * @return
	 */
	public static XmlTree parse(String xml) throws Throwable {
		return parse(xml, false,true);
	}

	public static XmlTree parse(String xml, boolean trimText,boolean isCheck) throws Throwable {
		xml = XmlFormat.formatXML_str(xml);
		List<Element> list = Util.getElements(xml);
		if (CollectionUtils.isEmpty(list)) {
			return null;
		}

		int idx = -1;
		List<AbstractNode> listPreComment = new ArrayList<AbstractNode>();
		List<AbstractNode> listLastComment = new ArrayList<AbstractNode>();

		for (int i = 0; i < list.size(); i++) {
			Element e = list.get(i);
			if (e.getType() == Element.DTD) {
				continue;
			}
			if (e.getType() == Element.COMMENT) {
				listPreComment.add(new CommentNode(e.getText(), e));
				continue;
			}
			if (e.getType() == Element.TEXT) {
				if (StringUtil.isEmptyStr(e.getText())) {
					continue;
				}
				throw new XmlSyntaxException("标签开始之前不能有文本[" + e.getText().trim()
						+ "]");
			}
			if (e.getType() == Element.TAG) {
				idx = i;
				break;
			}
			throw new XmlSyntaxException("标签开始之前不能有CDATA[" + e.getText().trim()
					+ "]");
		}

		if (idx == -1) {
			return null;
		}


		Element ele = list.get(idx);
		TagNode node = new TagNode(ele.getTagName(), ele);

		if (ele.getAttrs() != null) {
			node.setAttributes(ele.getAttrs());
		}

		Element endEle = getEndTagElement(list, idx, ele, node, trimText);
		if (Objects.isNull(endEle)) {
			throw new XmlSyntaxException("root: <" + ele.getTagName()
					+ "> 没有找到对应的endTag");
		}

		for (int i = endEle.getIndexInTheList() + 1; i < list.size(); i++) {
			Element e = list.get(i);
			if (e.getType() == Element.COMMENT) {
				listLastComment.add(new CommentNode(e.getText(), e));
			}
			if (e.getType() == Element.TAG) {
				throw new XmlSyntaxException("root: </" + ele.getTagName()
						+ "> 根标签的后面不能再有数据<" + e.getTagName() + ">");
			}
			if (e.getType() == Element.CDATA) {
				throw new XmlSyntaxException("root: </" + ele.getTagName()
						+ "> 根标签的后面不能再有数据CDATA[" + e.getText() + "]");
			}
			if ((e.getType() != Element.TEXT) || (StringUtil.isEmptyStr(e.getText()))) {
				continue;
			}
			throw new XmlSyntaxException("root: </" + ele.getTagName()
					+ "> 根标签的后面不能再有数据text[" + e.getText().trim() + "]");
		}

		XmlTree tree = new XmlTree(node);

		String substring = xml.substring(xml.lastIndexOf("\n") + 1);
		if (substring.isEmpty()) {

		} else {
			xml += "\r\n";
		}

		tree.setOrgXml(xml);
		tree.addPreComment(listPreComment);
		tree.addLastComment(listLastComment);
		if(MetaProcess.TAG_NAME.equals(tree.getRoot().getTagName())||"CommonDefVestCollection".equals(tree.getRoot().getTagName())){
			isCheck = false;
		}
		tree.updateMap(isCheck);
		return tree;
	}

	private static Element getEndTagElement(List<Element> list, int bg,
											Element ele, TagNode node, boolean trimText) {
		if (ele.getTagType() == Element.T_NODE) {
			ele.setIndexInTheList(bg);
			return ele;
		}
		if (ele.getTagType() == Element.T_END) {
			throw new XmlSyntaxException("结尾标签</" + ele.getTagName() + "> 之前没有开始标签");
		}

		for (int i = bg + 1; i < list.size(); i++) {
			Element tem = list.get(i);
			if ((tem.getType() == Element.TEXT) || (tem.getType() == Element.COMMENT)
					|| (tem.getType() == Element.CDATA)) {
				if ((tem.getType() == Element.COMMENT) && (!useComment)) {
					continue;
				}
				if (trimText) {
					String txt = tem.getText().trim();
					if (txt.length() > 0) {
						node.appendNode(makeNotTagNode(txt, tem));
					}
				} else {
					node.appendNode(makeNotTagNode(tem.getText(), tem));
				}

			} else if (tem.getTagType() == Element.T_NODE) {
				node.appendNode(makeTagNode(tem));
			} else {
				if (tem.getTagType() == Element.T_END) {
					if (tem.getTagName().equals(ele.getTagName())) {
						tem.setIndexInTheList(i);

						TagNode endNode = makeTagNode(tem);
						node.appendNode(endNode);
						return tem;
					}
					throw new XmlSyntaxException("endTag </" + tem.getTagName()
							+ " 之前没有开始节点");
				}

				TagNode newNode = makeTagNode(tem);
				node.appendNode(newNode);
				Element newEd = getEndTagElement(list, i, tem, newNode, trimText);
				if (Objects.isNull(newEd)) {
					throw new XmlSyntaxException("Tag <" + tem.getTagName()
							+ "> 没有找到对应的endTag");
				}

				i = newEd.getIndexInTheList();
			}

		}

		return null;
	}

	private static TagNode makeTagNode(Element ele) {
		TagNode node = new TagNode(ele);
		node.setTagName(ele.getTagName());
		if (ele.getAttrs() != null) {
			node.setAttributes(ele.getAttrs());
		}
		return node;
	}

	private static AbstractNode makeNotTagNode(String text, Element element) {
		int elemType = element.getType();
		if (Element.TEXT == elemType) {
			return new TextNode(text, element);
		} else if (Element.COMMENT == elemType) {
			return new CommentNode(text, element);
		} else if (Element.CDATA == elemType) {
			return new CDataNode(text, element);
		} else if (Element.DTD == elemType) {
			return new DTDNode(text, element);
		}
		throw new XmlSyntaxException("节点类型:" + elemType
				+ " 不存在！");
	}
}