package com.bokesoft.yes.design.vest;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;

public class DynamicVestExtendTagDefine {
	public static final String Tag_Panel = "Panel";
	public static final String Tag_DataSource = "DataSource";
	public static final String Tag_DataObject = "DataObject";
	public static final String Tag_TableCollection = "TableCollection";
	public static final String Tag_Item = "Item";
	private static List<String> tagsCanNotExtend = null;

	public DynamicVestExtendTagDefine() {
	}

	public static boolean isTagCanNotExtend(String tag) {
		return tagsCanNotExtend.contains(tag);
	}

	public static List<String> getTagsCanNotExtend() {
		return tagsCanNotExtend;
	}

	public static boolean isPanelNode(TagNode tagNode) {
		return Objects.isNull(tagNode) ? false : tagNode.getTagName().endsWith("Panel");
	}

	public static TagNode cloneWithoutChildren(TagNode tagNode) {
		TagNode node = new TagNode(tagNode.getTagName());
		for (Map.Entry<String,String> entry : tagNode.getAttributes().entrySet()) {
			node.setAttribute(entry.getKey(), entry.getValue());
		}

		return node;
	}

	static {
		tagsCanNotExtend = Arrays.asList("Item");
	}
}
