package com.bokesoft.yes.design.vest;

import java.util.*;

import org.w3c.dom.Document;

import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yigo.common.util.TypeConvertor;

/**
 * 根据当前界面配置动态创建马甲配置文件内容
 * 
 * @author chenbinbin
 *
 */
public class DynamicVestCreator {
	
	private Document sourceDocument = null;
	
	private Document curDocument = null;
	
	private HashMap<String, TagNode> sourceNodeMap = null;
	
	public DynamicVestCreator(Document srcDocument, Document extendedDocument) {
		this.sourceDocument = srcDocument;
		this.curDocument = extendedDocument;
	}
	
	public String createVestXml() throws Exception {
		TagNode vestRootNode = createVest(null);
		return vestRootNode.toXml(0);
	}
	
	public TagNode createVest(XmlTree orgTree) throws Exception {
		XmlCreator createor = new XmlCreator(curDocument, orgTree);
		XmlTree xmlTree = createor.createXmlTree();
		//curMapNode = createor.getTagNodeMap();
		TagNode curRootNode = xmlTree.getRoot();

		createor = new XmlCreator(sourceDocument, orgTree);
		xmlTree = createor.createXmlTree();
		sourceNodeMap = createor.getTagNodeMap();
		TagNode sourceRootNode = xmlTree.getRoot();



		String par="";
		if (curRootNode.getParent()!=null){
			par = curRootNode.getParent().getPrimaryKey();
			if (curRootNode.getParent().getParent()!=null){
				par = curRootNode.getParent().getParent().getPrimaryKey()+"->"+par;
			}
		}
		String sourceKey = par + "->" + curRootNode.getPrimaryKey();

		// 马甲中个根节点Key与源单不一样，此处特殊处理
		sourceNodeMap.put(sourceKey, sourceRootNode);


		TagNode vestRootNode = createNode(curRootNode, sourceRootNode);
		//vestRootNode.setAttribute("Key", formKey);
		return vestRootNode;
	}
	
	private TagNode createNode(TagNode curNode, TagNode parentSourceNode) {
		TagNode vestNode = null;
		String tagName = curNode.getTagName();
		if (DynamicVestExtendTagDefine.isTagCanNotExtend(tagName)) {
			return null;
		}
		
		if (!curNode.hasPrimaryAttribute()) {
			// 复制默认面板布局
			TagNode parentNode = curNode.getParent();
			if (DynamicVestExtendTagDefine.isPanelNode(parentNode)) {
				vestNode = (TagNode) curNode.clone();
				return vestNode;
			}
		}
		
		if (curNode.hasPrimaryAttribute()) {
			String par="";
			if (curNode.getParent()!=null){
				par = curNode.getParent().getPrimaryKey();
				if (curNode.getParent().getParent()!=null){
					par = curNode.getParent().getParent().getPrimaryKey()+"->"+par;
				}
			}
			String sourceKey = par + "->" + curNode.getPrimaryKey();

			TagNode sourceNode = sourceNodeMap.get(sourceKey);
			if (sourceNode != null) {
				// 可以根据主键找到原始节点
				vestNode = createVestNode(curNode, sourceNode);
			} else {
				if (parentSourceNode != null && parentSourceNode.findChildByTagNode(curNode) != null) {
					vestNode = createVestNode(curNode, parentSourceNode.findChildByTagNode(curNode));
				} else {
					// 马甲中新增的組件
					if (DynamicVestExtendTagDefine.isPanelNode(curNode)) {
						vestNode = DynamicVestExtendTagDefine.cloneWithoutChildren(curNode);
						List<AbstractNode> children = createChildTagNodes(curNode, null);
						if (children != null && children.size() > 0) {
							for (AbstractNode node : children) {
								vestNode.addNode(node);
							}
						}
					} else {
						vestNode = (TagNode) curNode.clone();
					}
				}

			}
		} else {
			if (parentSourceNode != null) {
				// 无主键节点，通过TagName查找到源
				TagNode sourceNode = parentSourceNode.findFirstTagNodeByTagName(curNode.getTagName());
				if (sourceNode != null) {
					vestNode = createVestNode(curNode, sourceNode);
				} else {
					//马甲中新增的字段
					vestNode = (TagNode) curNode.clone();
				}
			}
		}
		return vestNode;
	}
	
	/**
	 * 根据当前真实节点信息，和源节点信息创建马甲节点
	 * 
	 * @param curNode
	 * @param srcNode
	 * @return
	 */
	private TagNode createVestNode(TagNode curNode, TagNode srcNode) {
		TagNode vestNode = null;
		String key, value, sourceValue;
		String tagName = curNode.getTagName();
		if (curNode.hasPrimaryAttribute()) {
			vestNode = new TagNode(tagName);
			String primaryName = curNode.getPrimaryAttrName();
			vestNode.setAttribute(primaryName, curNode.getAttributes().get(primaryName));
			VestUtil.dealSpecialAttrs(vestNode, srcNode, new String[]{"CellType","ColumnType"});
			VestUtil.dealOptRefKey(vestNode, srcNode);
		}
		
		for(Map.Entry<String, String> entry : curNode.getAttributes().entrySet()) {
			key = entry.getKey();
			value = entry.getValue();
			sourceValue = srcNode.getAttributes().get(key);
			if (!TypeConvertor.toString(value).equals(sourceValue)) {
				if (Objects.isNull(vestNode)) {
                    vestNode = new TagNode(tagName);
                }
				vestNode.setAttribute(key, value);
			}
			
		}
		List<AbstractNode> children = createChildTagNodes(curNode, srcNode);
		if (children != null && children.size() > 0) {
			if (Objects.isNull(vestNode)) {
                vestNode = new TagNode(tagName);
            }
			for (AbstractNode node : children) {
				vestNode.addNode(node);
			}
		}
		
		if (vestNode != null && vestNode.getTagName().equalsIgnoreCase("Column") && vestNode.getAttributes().size() == 1) {
			return null;
		}
		return vestNode;
	}
	
	private List<AbstractNode> createChildTagNodes(TagNode curNode, TagNode srcNode) {
		AbstractNode otherNode = null;
		TagNode tmpNode = null, vestNode = null;
		List<AbstractNode> children = null;
		for (AbstractNode node : curNode.getChildren()) {
			if (node instanceof TagNode) {
				tmpNode = (TagNode) node;
				vestNode = createNode(tmpNode, srcNode);
				if (vestNode != null) {
					if (Objects.isNull(children)) {
                        children = new ArrayList<AbstractNode>();
                    }
					children.add(vestNode);
				}
			} else {
				otherNode = createOtherNode(node, srcNode);
				if (otherNode != null) {
					if (Objects.isNull(children)) {
                        children = new ArrayList<AbstractNode>();
                    }
					children.add(otherNode);
				}
			}
		}
		return children;
	}
	
	/**
	 * 处理内容节点
	 * 
	 * @param curNode
	 * @param parentSourceNode
	 * @return
	 */
	private AbstractNode createOtherNode(AbstractNode curNode, TagNode parentSourceNode) {
		if (Objects.isNull(parentSourceNode)) {
            return null;
        }
		AbstractNode srcNode = parentSourceNode.getFirst();
		String curContent = TypeConvertor.toString(curNode.getText()),
				srcContent = TypeConvertor.toString(srcNode.getText());

		if (!curContent.equals(srcContent)) {
			return curNode.clone();
		}
		return null;
	}
}
