package com.bokesoft.yes.design.utils;

import com.bokesoft.erp.metaobjectchange.IMetaObjectChangeListener;
import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.erp.metaobjectchange.MetaObjectChangeListener;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaPopView;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaButton;
import com.bokesoft.yigo.meta.form.component.control.MetaComboBox;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.MetaDatePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.MetaDynamicDict;
import com.bokesoft.yigo.meta.form.component.control.MetaNumberEditor;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionView;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionViewRow;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.MetaColumnExpand;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Stack;

/**
 * 用于Key到配置对象的快速获取<br>
 * 为什么不用com.bokesoft.yigo.view.model.base.IDLookup，因为那个类中有view的特性
 */
public class IDLookup {
	/**
	 * 表单配置对象
	 */
	private final MetaForm metaForm;

	//private StringHashMap<AbstractMetaObject> metaObjects = new StringHashMap<AbstractMetaObject>();

	/**
	 * 记录字段Key和字段信息之间的关系，这里记录了所有的字段
	 */
	private final StringHashMap<FieldInfo> fieldKey2FieldInfo = new StringHashMap<FieldInfo>();

	/**
	 * 记录非字段的Component，比如Grid、Panel等
	 */
	private final StringHashMap<MetaComponent> key2NoFieldComponent = new StringHashMap<MetaComponent>();

	/**
	 * 记录字典字段和ItemKey之间的关系
	 */
	private final StringHashMap<String> dicFiledKey2ItemKey = new StringHashMap<String>();

	/**
	 * 记录明细行上的单元格和Grid之间的关系
	 */
	private Map<String, String> detailCellKey2GridKey = null;

	/**
	 * 记录明细表格上没有tableKey的单元格
	 */
	private Map<String, List<String>> noTableGridCell = null;

	/**
	 * 记录tableKey和ColumnKey对应fieldKey的关系
	 * 如果一个数据库字段对应多个界面字段，目前只能找到一个
	 */
	private Map<String, Map<String, String>> tableColumnKey2FieldKeys = null;

	/**
	 * 设计器专用
	 * 记录tableKey和ColumnKey对应fieldKey的关系
	 * 如果一个数据库字段对应多个界面字段，可找到多个
	 */
	private Map<String, Map<String, List<String>>> tableColumnKey2FieldListKeys = null;

	/**
	 * 所有的表格
	 */
	private List<MetaGrid> metaGrids = null;

	/**
	 * 所有的TableView中的明细类型TableRow
	 */
	private List<MetaTableRow> metaDetailTableRows = null;

	/**
	 * 所有的GridColumns
	 */
	private final StringHashMap<MetaGridColumn> fieldKey2MetaGridColumnInfo = new StringHashMap<MetaGridColumn>();
	/**
	 * 所有的GridColumns的oldKey
	 */
	private final StringHashMap<MetaGridColumn> fieldKey2MetaGridColumnInfooldKey = new StringHashMap<MetaGridColumn>();
	/**
	 * 根据tableKey 对应的field List
	 */
	private StringHashMap<List<String>> tableFields = null;
	/**
	 * 所有伙伴字段到字段之间的对应
	 */
	private final StringHashMap<String> buddyKey2FieldKeys = new StringHashMap<String>();
	/**
	 * 所有字段到Panel之间的对应
	 */
	private final StringHashMap<String> fieldKey2PanelKeys = new StringHashMap<String>();
	/**
	 * 记录所有panelKey
	 */
	private final StringHashMap<String> panelKeys = new StringHashMap<String>();

	public StringHashMap<String> getPanelKeys() {
		return panelKeys;
	}

	private final Map<String, List<String>> gridColumnExpands = new HashMap<String, List<String>>();

	// 父子表格关系
	private Map<String, List<String>> tableRelationMap = null;

	private IDLookup(MetaForm metaForm) {
		this.metaForm = metaForm;

		MetaDataSource metaDataSource = metaForm.getDataSource();
		MetaDataObject metaDataObject = Objects.isNull(metaDataSource) ? null : metaDataSource.getDataObject();
		MetaBody metaBody = metaForm.getMetaBody();
		Stack<MetaComponent> stack = new Stack<MetaComponent>();
		for (int i = 0, size = metaBody.size(); i < size; ++i) {
			stack.push(metaBody.get(i));
		}

		while (!stack.isEmpty()) {
			MetaComponent metaComponent = stack.pop();

			if (metaComponent instanceof MetaPanel) {
				panelKeys.put(metaComponent.getKey(), metaComponent.getCaption());
			}
			int controlType = metaComponent.getControlType();
			switch (controlType) {
				case ControlType.GRID: {
					if (Objects.isNull(detailCellKey2GridKey)) {
						detailCellKey2GridKey = new HashMap<String, String>();
					}
					MetaGrid metaGrid = (MetaGrid) metaComponent;
					String gridKey = metaGrid.getKey();
					key2NoFieldComponent.put(gridKey, metaComponent);
					String tableKey = metaGrid.getTableKey();
					String tmpBandTableName = tableKey;
					List<String> noTableKeyGridCell = null;
					for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
						tmpBandTableName = tableKey;
						for (MetaGridCell metaGridCell : metaGridRow) {
							String cellFieldKey = metaGridCell.getKey();
							if (metaGridRow.getRowType() == RowType.Detail || metaGridRow.getRowType() == RowType.Total || metaGridRow.getRowType() == RowType.Group
									|| metaGridRow.getRowType() == RowType.Fix) {
								detailCellKey2GridKey.put(cellFieldKey, gridKey);
								if (Objects.isNull(metaGridCell.getDataBinding()) || isBlankOrNull(metaGridCell.getColumnKey())) {
									if (Objects.isNull(noTableKeyGridCell)) {
										noTableKeyGridCell = new ArrayList<String>();
									}
									noTableKeyGridCell.add(metaGridCell.getKey());
								}
							}
							MetaTable metaCellTable = null;
							MetaColumn metaCellColumn = null;
							MetaDataBinding cellMetaDataBinding = metaGridCell.getDataBinding();
							String defaultValue = null;
							String defaultFormulaValue = null;
							String enable = metaGridCell.getEnable();
							String checkRule = "";
							if (cellMetaDataBinding != null) {
								defaultValue = cellMetaDataBinding.getDefaultValue();
								defaultFormulaValue = cellMetaDataBinding.getDefaultFormulaValue();
								checkRule = cellMetaDataBinding.getCheckRule();
								if (cellMetaDataBinding.getTableKey() != null && cellMetaDataBinding.getTableKey().length() > 0) {
									tmpBandTableName = cellMetaDataBinding.getTableKey();
								}
								if (metaDataObject != null && Objects.nonNull(metaDataObject.getTableCollection())) {
									MetaTableCollection metaTableCollection = metaDataObject.getTableCollection();
									metaCellTable = metaTableCollection.get(tmpBandTableName);
									if (metaCellTable != null) {
										String columnKey = cellMetaDataBinding.getColumnKey();
										metaCellColumn = metaCellTable.get(columnKey);
										if (metaCellColumn != null) {
											if (StringUtils.isBlank(defaultValue)) {
												defaultValue = metaCellColumn.getDefaultValue();
											}
											recordFieldTableColumn(tmpBandTableName, columnKey, cellFieldKey);
											if (metaCellColumn.getIsPrimary()) {
												recordTablePrimaryColumn(tmpBandTableName, columnKey);
											}
										}
									}
								}
							}
							MetaItemFilterCollection itemFilters = null;
							if (metaGridCell.getCellType() == ControlType.DICT || metaGridCell.getCellType() == ControlType.DYNAMICDICT) {
								MetaDictProperties dictProperties = (MetaDictProperties) metaGridCell.getProperties();
								itemFilters = dictProperties.getFilters();
								if (!cellFieldKey.contains("__mirror")) {
									dicFiledKey2ItemKey.put(cellFieldKey, dictProperties.getItemKey());
								}
							}
							fieldKey2FieldInfo.put(cellFieldKey, new FieldInfo(metaCellTable, metaCellColumn, gridKey,
									defaultValue, defaultFormulaValue, enable, null, checkRule, itemFilters, metaGridCell));
						}
					}
					if (noTableKeyGridCell != null) {
						if (Objects.isNull(noTableGridCell)) {
							noTableGridCell = new HashMap<String, List<String>>();
						}
						this.noTableGridCell.put(gridKey, noTableKeyGridCell);
					}
					for (MetaGridColumn metaGridCol : metaGrid.getColumnCollection()) {
						genGridColumn(metaGrid.getKey(), metaGridCol);
					}

					if (CollectionUtils.isEmpty(metaGrids)) {
						metaGrids = new ArrayList<MetaGrid>();
					}
					metaGrids.add(metaGrid);
				}
				break;
				case ControlType.LISTVIEW: {
					if (Objects.isNull(detailCellKey2GridKey)) {
						detailCellKey2GridKey = new HashMap<String, String>();
					}
					MetaListView metaListView = (MetaListView) metaComponent;
					MetaTable metaTable = null;
					String tableKey = metaListView.getTableKey();
					if (metaDataObject != null && !StringUtils.isEmpty(tableKey)) {
						metaTable = metaDataObject.getMetaTable(tableKey);
					}
					String listViewKey = metaListView.getKey();
					key2NoFieldComponent.put(listViewKey, metaComponent);
					fieldKey2FieldInfo.put(listViewKey,
							new FieldInfo(metaTable, null, listViewKey, null, null, null, null, null, null, metaListView));
					// 加入子组件作为下一遍循环
					for (MetaListViewColumn child : metaListView.getColumnCollection()) {
						MetaColumn metaColumn = null;
						if (metaTable != null) {
							String columnKey = child.getDataColumnKey();
							if (!StringUtils.isEmpty(columnKey)) {
								metaColumn = metaTable.get(columnKey);
							}
						}
						String childKey = child.getKey();
						MetaDataBinding dataBinding = child.getDataBinding();
						String checkRule = dataBinding != null ? dataBinding.getCheckRule() : "";
						fieldKey2FieldInfo.put(childKey,
								new FieldInfo(metaTable, metaColumn, listViewKey, child.getDefaultValue(),
										child.getDefaultFormulaValue(), child.getEnable(), child.getVisible(), checkRule, null, child));
						if (child.getColumnType() == ControlType.DICT) {
							MetaDictProperties dictProperties = (MetaDictProperties) child.getProperties();
							if (!childKey.contains("__mirror")) {
								dicFiledKey2ItemKey.put(childKey, dictProperties.getItemKey());
							}
						}
						detailCellKey2GridKey.put(childKey, listViewKey);
					}
				}
				break;
				case ControlType.COLLECTIONVIEW:{
					MetaCollectionView metaCollectionView = (MetaCollectionView) metaComponent;
					String tableViewKey = metaCollectionView.getKey();
					key2NoFieldComponent.put(tableViewKey, metaCollectionView);
					fieldKey2FieldInfo.put(tableViewKey, new FieldInfo(null, null, tableViewKey, null,
							null, null, null, null, null, metaCollectionView));
					for (int i = 0; i < metaCollectionView.getRows().size(); i++) {
						MetaCollectionViewRow metaCollectionViewRow = metaCollectionView.getRows().get(i);
						String tableRowKey = metaCollectionViewRow.getKey();
						key2NoFieldComponent.put(tableRowKey, metaCollectionViewRow);
						fieldKey2FieldInfo.put(tableRowKey, new FieldInfo(null, null, tableRowKey, null,
								null, null, null, null, null, metaCollectionViewRow));
						stack.add(metaCollectionViewRow.getRoot());
					}
				}
				break;
				case ControlType.TABLEVIEW: {
					if (Objects.isNull(detailCellKey2GridKey)) {
						detailCellKey2GridKey = new HashMap<String, String>();
					}
					MetaTableView metaTableView = (MetaTableView) metaComponent;
					String tableViewKey = metaTableView.getKey();
					key2NoFieldComponent.put(tableViewKey, metaTableView);
					fieldKey2FieldInfo.put(tableViewKey, new FieldInfo(null, null, tableViewKey, null,
							null, null, null, null, null, metaTableView));
					for (int i = 0; i < metaTableView.getRows().size(); i++) {
						MetaTableRow metaTableRow = metaTableView.getRows().get(i);
						String tableRowKey = metaTableRow.getKey();
						key2NoFieldComponent.put(tableRowKey, metaTableRow);
						fieldKey2FieldInfo.put(tableRowKey, new FieldInfo(null, null, tableRowKey, null,
								null, null, null, null, null, metaTableRow));
						if (metaTableRow.getRowType() == TableViewRowType.Detail) {
							addDetailRowCell(metaDataObject, metaTableRow, metaTableRow.getRoot());
							if (CollectionUtils.isEmpty(metaDetailTableRows)) {
								metaDetailTableRows = new ArrayList<MetaTableRow>();
							}
							metaDetailTableRows.add(metaTableRow);
						} else {
							stack.add(metaTableRow.getRoot());
						}
					}
				}
				break;
				case ControlType.POPVIEW: {
					if (Objects.isNull(detailCellKey2GridKey)) {
						detailCellKey2GridKey = new HashMap<String, String>();
					}
					MetaPopView metaPopView = (MetaPopView) metaComponent;
					fieldKey2FieldInfo.put(metaPopView.getKey(), new FieldInfo(null, null, metaPopView.getKey(), null,
							null, null, null, null, null, metaPopView));
					
					if (metaPopView.getRoot() != null) {
						stack.add(metaPopView.getRoot());
					}
				}
				break;
				case ControlType.REFRESHCONTROL:
					break;
				default: {
					addComponent(metaComponent, metaDataObject, null);
				}

				// 加入子组件作为下一遍循环
				String componentKey = metaComponent.getKey();
				key2NoFieldComponent.put(componentKey, metaComponent);
				for (int i = 0, size = metaComponent.getComponentCount(); i < size; ++i) {
					MetaComponent child = metaComponent.getComponent(i);
					fieldKey2PanelKeys.put(child.getKey(), componentKey);
					stack.add(child);
				}
			}
		}
	}

	private void addComponent(MetaComponent metaComponent, MetaDataObject metaDataObject, String gridKey){
		String fieldKey = metaComponent.getKey();
		MetaTable metaTable = null;
		MetaColumn metaColumn = null;
		String defaultValue = null;
		String defaultFormulaValue = null;
		MetaDataBinding metaDataBinding = metaComponent.getDataBinding();
		String enable = metaComponent.getEnable();
		String visible = metaComponent.getVisible();
		String checkRule = "";
		if (metaDataBinding != null) {
			defaultValue = metaDataBinding.getDefaultValue();
			defaultFormulaValue = metaDataBinding.getDefaultFormulaValue();
			checkRule = metaDataBinding.getCheckRule();
			String tableKey = metaDataBinding.getTableKey();
			if (tableKey != null && !tableKey.isEmpty() && metaDataObject != null) {
				MetaTableCollection metaTableCollection = metaDataObject.getTableCollection();
				metaTable = metaTableCollection.get(tableKey);
				if (metaTable != null) {
					String columnKey = metaDataBinding.getColumnKey();
					metaColumn = metaTable.get(columnKey);
					if (metaColumn != null) {
						if (StringUtils.isBlank(defaultValue) || defaultValue.isEmpty()) {
							defaultValue = metaColumn.getDefaultValue();
						}
						recordFieldTableColumn(tableKey, columnKey, fieldKey);
					}
				}
			}
		}
		MetaItemFilterCollection itemFilters = null;
		if (metaComponent instanceof MetaDict) {
			MetaDict dict = (MetaDict) metaComponent;
			itemFilters = dict.getFilters();
			if (!fieldKey.contains("__mirror")) {
				dicFiledKey2ItemKey.put(fieldKey, dict.getItemKey());
			}
		} else if (metaComponent instanceof MetaDictView) {
			MetaDictView dict = (MetaDictView) metaComponent;
			itemFilters = dict.getFilters();
		}
		fieldKey2FieldInfo.put(fieldKey, new FieldInfo(metaTable, metaColumn, gridKey, defaultValue,
				defaultFormulaValue, enable, visible, checkRule, itemFilters, metaComponent));
		String buddyKey = metaComponent.getBuddyKey();
		if (buddyKey != null && !buddyKey.isEmpty()) {
			buddyKey2FieldKeys.put(buddyKey, fieldKey);
		}
	}

	private void addDetailRowCell(MetaDataObject metaDataObject, MetaTableRow metaTableRow, MetaComponent metaComponent) {
		if (metaComponent != null) {
			String fieldKey = metaComponent.getKey();
			String tableRowKey = metaTableRow.getKey();
			if(metaComponent.getDataBinding() != null){
				metaComponent.getDataBinding().setTableKey(metaTableRow.getTableKey());
			}
			addComponent(metaComponent, metaDataObject, tableRowKey);
			key2NoFieldComponent.put(fieldKey, metaComponent);
			detailCellKey2GridKey.put(fieldKey, tableRowKey);

			for (int j = 0; j < metaComponent.getComponentCount(); j++) {
				MetaComponent metaSubComp = metaComponent.getComponent(j);
				addDetailRowCell(metaDataObject, metaTableRow, metaSubComp);
			}
		}
	}

	private void genGridColumn(String gridKey, MetaGridColumn metaGridColumn) {
		if (metaGridColumn.isColumnExpand()) {
			MetaColumnExpand metaColumnExpand = metaGridColumn.getColumnExpand();
			if (!StringUtil.isBlankOrNull(metaColumnExpand.getColumnKey())) {
				if (StringUtils.isEmpty(metaColumnExpand.getTableKey())) {
					String tableKey = this.getTableKeyByDBColumnKey(metaColumnExpand.getColumnKey());
					metaColumnExpand.setTableKey(TypeConvertor.toString(tableKey));
				}
				MetaDataSource dataSource = this.metaForm.getDataSource();
				if (Objects.isNull(dataSource)) {
					return;
				}
				MetaDataObject dataObject = dataSource.getDataObject();
				if (Objects.isNull(dataObject)) {
					return;
				}
				MetaTable metaTable = this.metaForm.getDataSource().getDataObject().getMetaTable(metaColumnExpand.getTableKey());
//				MetaColumn metaColumn = null;
//				if (metaTable != null) {
//					metaColumn = metaTable.get(metaColumnExpand.getColumnKey());
//				}
//				fieldKey2FieldInfo.put(metaColumnExpand.getColumnKey(), new FieldInfo(metaTable, metaColumn, gridKey,
//						null, null, null, null, null, null, metaColumnExpand));
				List<String> columnExpandList = gridColumnExpands.get(gridKey);
				if (Objects.isNull(columnExpandList)) {
					columnExpandList = new ArrayList<String>();
				}
				columnExpandList.add(metaColumnExpand.getColumnKey());
				this.gridColumnExpands.put(gridKey, columnExpandList);
			}

		}
		if (!fieldKey2MetaGridColumnInfo.containsKey(metaGridColumn.getKey())) {
			fieldKey2MetaGridColumnInfo.put(metaGridColumn.getKey(), metaGridColumn);
		}
		if (!fieldKey2MetaGridColumnInfooldKey.containsKey(metaGridColumn.getMetaKey())) {
			fieldKey2MetaGridColumnInfooldKey.put(metaGridColumn.getMetaKey(), metaGridColumn);
		}

		// 处理嵌套列
		MetaGridColumnCollection columns = metaGridColumn.getColumnCollection();
		if (columns != null && columns.size() > 0) {
			for (MetaGridColumn metaGridCol : columns) {
				genGridColumn(gridKey, metaGridCol);
			}
		}
	}

	/**
	 * 获得某个数据源的ColumnKey和字段key
	 *
	 * @param
	 * @return
	 */
	public List<String> getMetaTableKeys() {
		List<String> list = new ArrayList<>();
		if (Objects.isNull(tableColumnKey2FieldKeys)){
			return list;
		}
		tableColumnKey2FieldKeys.forEach((a,b)->{
			list.add(a);
		});
		return list;
	}

	/**
	 * 根据组件的标识取得组件定义
	 *
	 * @param fieldKey 组件标识
	 * @return 如果存在key指定的组件则返回组件定义，否则返回null
	 * @throws Exception
	 */
	public MetaComponent getComponentByKey(String fieldKey) throws Exception {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			throw new Exception(String.format("表单 %s 中不存在字段 %s， 请检查配置", metaForm.getKey(), fieldKey));
		}
		AbstractMetaObject metaObject = fieldInfo.metaObject;
		if (metaObject instanceof MetaComponent) {
			return (MetaComponent) metaObject;
		}
		return null;
	}

	/**
	 * 取组件的TagName
	 *
	 * @param key
	 * @return
	 * @throws Exception
	 */
	public String getTagNameByKey(String key) throws Exception {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(key);
		if (fieldInfo != null) {
			return fieldInfo.metaObject.getTagName();
		} else if (key2NoFieldComponent.get(key) != null) {
			return key2NoFieldComponent.get(key).getTagName();
		} else if (fieldKey2MetaGridColumnInfooldKey.get(key) != null) {
			return fieldKey2MetaGridColumnInfooldKey.get(key).getTagName();
		} else {
			return null;
		}
	}

	/**
	 * 取组件的TagName
	 *
	 * @param key
	 * @return
	 * @throws Exception
	 */
	public MetaComponent getNoFieldComponent(String key) throws Exception {
		if (key2NoFieldComponent.get(key) != null) {
			return key2NoFieldComponent.get(key);
		}
		return null;
	}

	/**
	 * 取得所有组件
	 *
	 * @return
	 */
	public List<MetaComponent> getAllComponent() {
		List<MetaComponent> coms = new ArrayList<MetaComponent>();
		for (Entry<String, FieldInfo> key : fieldKey2FieldInfo.entrySet()) {
			FieldInfo fieldInfo = this.fieldKey2FieldInfo.get(key.getKey());
			if (fieldInfo != null && fieldInfo.metaObject instanceof MetaComponent) {
				coms.add((MetaComponent) fieldInfo.metaObject);
			}
		}
		return coms;
	}

	/**
	 * 获取表格字段定义
	 *
	 * @param key
	 * @return
	 */
	public MetaGridCell getGridCellByKey(String key) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(key);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		if (fieldInfo.metaObject instanceof MetaGridCell) {
			return (MetaGridCell) fieldInfo.metaObject;
		}
		return null;
	}

	/**
	 * 获取所有的单元格字段通过TableKey
	 *
	 * @return
	 */
	public List<MetaGridCell> getGridCellsByTableKey(String TableKey) {
		ArrayList<MetaGridCell> metaGridCells = new ArrayList<>();
		fieldKey2FieldInfo.forEach((key, fieldInfo) -> {
			if (fieldInfo.metaObject instanceof MetaGridCell) {
				MetaGridCell metaGridCell = (MetaGridCell) fieldInfo.metaObject;
				if (TableKey.equalsIgnoreCase(metaGridCell.getTableKey())) {
					metaGridCells.add(metaGridCell);
				}
			}
		});
		return metaGridCells;
	}

	/**
	 * 获取所有的网格布局面板
	 *
	 * @return
	 */
	public List<MetaGridLayoutPanel> getGridLayoutPanels() {
		ArrayList<MetaGridLayoutPanel> metaGridCells = new ArrayList<>();
		fieldKey2FieldInfo.forEach((key, fieldInfo) -> {
			if (fieldInfo.metaObject instanceof MetaGridLayoutPanel) {
				metaGridCells.add((MetaGridLayoutPanel) fieldInfo.metaObject);

			}
		});
		return metaGridCells;
	}

	public MetaColumnExpand getGrieColumnExpand(String key) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(key);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		if (fieldInfo.metaObject instanceof MetaColumnExpand) {
			return (MetaColumnExpand) fieldInfo.metaObject;
		}
		return null;
	}

	public MetaListViewColumn getListViewColumnByKey(String key) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(key);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		if (fieldInfo.metaObject instanceof MetaListViewColumn) {
			return (MetaListViewColumn) fieldInfo.metaObject;
		}
		return null;
	}

	public AbstractMetaObject getMetaObjectColumnByKey(String key) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(key);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		return fieldInfo.metaObject;
	}

	/**
	 * 根据key取得GridColumn
	 *
	 * @param key
	 * @return
	 */
	public MetaGridColumn getGridMetaColumnByKey(String key) {
		if (fieldKey2MetaGridColumnInfo.containsKey(key)) {
			return fieldKey2MetaGridColumnInfo.get(key);
		}
		return null;
	}

	/**
	 * 根据oldkey取得GridColumn
	 *
	 * @param key
	 * @return
	 */
	public MetaGridColumn getGridMetaColumnByOldKey(String key) {
		if (fieldKey2MetaGridColumnInfooldKey.containsKey(key)) {
			return fieldKey2MetaGridColumnInfooldKey.get(key);
		}
		return null;
	}

	/**
	 * 返回所有的GridColumns
	 */
	public StringHashMap<MetaGridColumn> getAllFieldKey2MetaGridColumnInfo() {
		return fieldKey2MetaGridColumnInfo;
	}

	/**
	 * 返回所有的GridColumns_oldkey
	 */
	public StringHashMap<MetaGridColumn> getAllFieldKey2MetaGridColumnInfo_oldKey() {
		return fieldKey2MetaGridColumnInfooldKey;
	}

	private void recordFieldTableColumn(String tableKey, String columnKey, String fieldKey) {
		if (Objects.isNull(tableColumnKey2FieldKeys)) {
			tableColumnKey2FieldKeys = new StringHashMap<Map<String, String>>();
		}
		Map<String, String> columnKey2FieldKey = tableColumnKey2FieldKeys.get(tableKey);
		if (Objects.isNull(columnKey2FieldKey)) {
			synchronized (tableColumnKey2FieldKeys) {
				columnKey2FieldKey = tableColumnKey2FieldKeys.get(tableKey);
				if (Objects.isNull(columnKey2FieldKey)) {
					columnKey2FieldKey = new StringHashMap<String>();
					tableColumnKey2FieldKeys.put(tableKey, columnKey2FieldKey);
				}
			}
		}
		columnKey2FieldKey.put(columnKey, fieldKey);

		//设计器专用
		if (Objects.isNull(tableColumnKey2FieldListKeys)) {
			tableColumnKey2FieldListKeys = new StringHashMap<Map<String, List<String>>>();
		}
		Map<String, List<String>> columnKey2FieldListKey = tableColumnKey2FieldListKeys.get(tableKey);
		if (Objects.isNull(columnKey2FieldListKey)) {
			synchronized (tableColumnKey2FieldListKeys) {
				columnKey2FieldListKey = tableColumnKey2FieldListKeys.get(tableKey);
				if (Objects.isNull(columnKey2FieldListKey)) {
					columnKey2FieldListKey = new StringHashMap<List<String>>();
					tableColumnKey2FieldListKeys.put(tableKey, columnKey2FieldListKey);
				}
			}
		}
		List<String> strings = columnKey2FieldListKey.get(columnKey);
		if (Objects.isNull(strings)) {
			strings = new ArrayList<>();
		}
		strings.add(fieldKey);
		columnKey2FieldListKey.put(columnKey, strings);
	}

	/**
	 * 记录表中的业务关键字，用于扩展计算
	 */
	private StringHashMap<List<String>> tablePrimaryColumns = null;

	private void recordTablePrimaryColumn(String tableKey, String columnKey) {
		if (Objects.isNull(this.tablePrimaryColumns)) {
			tablePrimaryColumns = new StringHashMap<>();
		}
		List<String> columns = tablePrimaryColumns.get(tableKey);
		if (Objects.isNull(columns)) {
			synchronized (tablePrimaryColumns) {
				columns = tablePrimaryColumns.get(tableKey);
				if (Objects.isNull(columns)) {
					columns = new ArrayList<String>();
					tablePrimaryColumns.put(tableKey, columns);
				}
			}
		}

		if (!columns.contains(columnKey)) {
			columns.add(columnKey);
		}
	}

	public List<String> getPrimaryColumnKeys(String tableKey) {
		if (tablePrimaryColumns.containsKey(tableKey)) {
			return tablePrimaryColumns.get(tableKey);
		} else {
			return new ArrayList<>();
		}
	}


	private HashMap<String, String> componentTab = null;

	private void initComponentTab() {
		HashMap<String, String> tmp = new HashMap<String, String>();
		MetaBody metabody = metaForm.getMetaBody();
		Stack<MetaComponent> stack = new Stack<MetaComponent>();
		for (int i = 0, size = metabody.size(); i < size; ++i) {
			stack.push(metabody.get(i));
		}
		while (!stack.isEmpty()) {
			MetaComponent component = stack.pop();
			String comKey = component.getKey();
			switch (component.getControlType()) {
				case ControlType.GRID: {
					MetaGrid metaGrid = (MetaGrid) component;
					String gridKey = metaGrid.getKey();
					if (tmp.containsKey(gridKey)) {
						String sTab = tmp.get(gridKey);
						for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
							if (metaGridRow.getRowType() == RowType.Detail || metaGridRow.getRowType() == RowType.Fix) {
								for (int i = 0; i < metaGridRow.size(); i++) {
									MetaGridCell metaGridCell = metaGridRow.get(i);
									String tmpGridCellKey = metaGridCell.getKey();
									tmp.put(tmpGridCellKey, sTab);
								}
							}
						}
					}
				}
				break;

			}
			// 加入子组件作为下一遍循环
			boolean isTab = component.getControlType() == ControlType.TABPANEL;
			for (int i = 0, size = component.getComponentCount(); i < size; ++i) {
				MetaComponent child = component.getComponent(i);
				String childKey = child.getKey();
				if (isTab) {
					tmp.put(childKey, childKey);
				}
				stack.add(child);
				if (tmp.containsKey(comKey)) {
					tmp.put(childKey, tmp.get(comKey));
				}
			}
		}
		componentTab = tmp;
	}

	/**
	 * 根据字段Key取默认值
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getDefaultValueByFieldKey(String fieldKey) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		return fieldInfo.defaultValue;
	}

	/**
	 * 根据字段Key取默认值公式
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getDefaultFormulaValueByFieldKey(String fieldKey) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		return fieldInfo.defaultFormulaValue;
	}

	/**
	 * 根据字段Key取可用性
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getEnable(String fieldKey) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		return fieldInfo.enable;
	}

	/**
	 * 根据字段Key取可见性
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getVisible(String fieldKey) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		return fieldInfo.visible;
	}

	/**
	 * 根据字段Key取检查公式
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getCheckRule(String fieldKey) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		return fieldInfo.checkRule;
	}

	/**
	 * 判断单元格是否在表格的明细行中
	 *
	 * @param cellKey
	 * @param gridKey
	 * @return
	 */
	public boolean isDetailCellInGrid(String cellKey, String gridKey) {
		return gridKey.equals(detailCellKey2GridKey.get(cellKey));
	}


	public AbstractMetaObject getMetaObjectByKey(String fieldKey) {
		AbstractMetaObject result = metaForm.componentByKey(fieldKey);
		if (Objects.isNull(result)) {
			result = metaForm.metaGridCellByKey(fieldKey);
		}
		return result;
	}

	/**
	 * 根据字段Key取数据绑定对象
	 *
	 * @param fieldKey
	 * @return
	 * @throws Exception
	 */
	public MetaDataBinding getMetaDataBinding(String fieldKey) throws Exception {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		Object obj = fieldInfo.metaObject;
		if (obj instanceof MetaComponent) {
			return ((MetaComponent) obj).getDataBinding();
		} else if (obj instanceof MetaGridCell) {
			return ((MetaGridCell) obj).getDataBinding();
		} else if (obj instanceof MetaColumnExpand) {
			MetaColumnExpand metaColumnExpand = (MetaColumnExpand) obj;
			MetaDataBinding dataBinding = new MetaDataBinding();
			dataBinding.setColumnKey(metaColumnExpand.getColumnKey());
			dataBinding.setTableKey(metaColumnExpand.getTableKey());
			return dataBinding;
		}
		return null;
	}

	/**
	 * 根据字段Key取字段标题
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getFieldCaption(String fieldKey) {
		String result = null;
		MetaComponent metaComponent = metaForm.componentByKey(fieldKey);
		if (metaComponent != null) {
			result = metaComponent.getCaption();
		} else {
			MetaGridCell metaGridCell = metaForm.metaGridCellByKey(fieldKey);
			if (metaGridCell != null) {
				result = metaGridCell.getCaption();
			}
		}
		return result;
	}

	/**
	 * 根据TableleKey字段Key取字段标题
	 * 主要用于判断特殊字段
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getTableFieldCaption(String tableKey, String fieldKey) {
		String result = null;
		MetaComponent metaComponent = metaForm.componentByKey(fieldKey);
		if (metaComponent != null) {
			String tableKey2 = metaComponent.getTableKey();
			if (tableKey2.equals(tableKey)) {
				result = metaComponent.getCaption();
			}
		} else {
			MetaGridCell metaGridCell = metaForm.metaGridCellByKey(fieldKey);
			if (metaGridCell != null) {
				String tableKey1 = metaGridCell.getTableKey();
				if (tableKey.equals(tableKey1)) {
					result = metaGridCell.getCaption();
				}
			}
		}
		return result;
	}

	/**
	 * 根据数据库表Key取界面表格key，目前只返回了第一个相关的表格
	 *
	 * @param tableKey
	 * @return
	 */
	public String getGridKeyByTableKey(String tableKey) {
		if (CollectionUtils.isEmpty(metaGrids)) {
			return null;
		}
		for (MetaGrid metaGrid : metaGrids) {
			if (tableKey.equals(metaGrid.getTableKey())) {
				return metaGrid.getKey();
			}
		}
		return null;
	}

	/**
	 * 根据界面表格Key,取数据表Key
	 *
	 * @param gridKey
	 * @return
	 */
	public String getTableKeyByGridKey(String gridKey) {
		if (CollectionUtils.isEmpty(metaGrids)) {
			return null;
		}
		for (MetaGrid metaGrid : metaGrids) {
			if (metaGrid.getKey().equalsIgnoreCase(gridKey)) {
				return metaGrid.getTableKey();
			}
		}
		return null;
	}

	public List<String> getChildGridKeyByGridKey(String gridKey) {
		List<String> result = new ArrayList<String>();

		if (CollectionUtils.isEmpty(metaGrids)) {
			return result;
		}

		for (MetaGrid metaGrid : metaGrids) {
			if (metaGrid.getParentGridKey().equalsIgnoreCase(gridKey)) {
				result.add(metaGrid.getKey());
			}
		}
		return result;
	}

	public String getParentTableKeyByTableKey(String tableKey) {
		MetaDataSource metaDataSource = metaForm.getDataSource();
		MetaDataObject metaDataObject = Objects.isNull(metaDataSource) ? null : metaDataSource.getDataObject();
		if (Objects.isNull(metaDataObject)) {
			return null;
		}
		MetaTableCollection tableCollection = metaDataObject.getTableCollection();
		if (Objects.isNull(tableCollection) || tableCollection.size() == 0) {
			return null;
		}
		MetaTable metaTable = tableCollection.get(tableKey);
		String parentKey = metaTable.getParentKey();
		if (StringUtil.isBlankOrNull(parentKey)) {
			return null;
		}
		return parentKey;
	}

	/**
	 * 获取子tableKey
	 *
	 * @param tableKey
	 * @return
	 */
	public List<String> getChildTableKeys(String tableKey) {
		if (Objects.isNull(tableRelationMap)) {
			Map<String, List<String>> tmpTableRelationMap = new HashMap<>();
			MetaDataSource metaDataSource = metaForm.getDataSource();
			MetaDataObject metaDataObject = Objects.isNull(metaDataSource) ? null : metaDataSource.getDataObject();
			if (Objects.isNull(metaDataObject)) {
				tableRelationMap = tmpTableRelationMap;
				return null;
			}
			MetaTableCollection tableCollection = metaDataObject.getTableCollection();
			if (Objects.isNull(tableCollection) || tableCollection.size() == 0) {
				tableRelationMap = tmpTableRelationMap;
				return null;
			}
			for (MetaTable metaTable : tableCollection) {
				String parentKey = metaTable.getParentKey();
				if (StringUtil.isBlankOrNull(parentKey)) {
					continue;
				}
				List<String> childTableKeys = tmpTableRelationMap.get(parentKey);
				if (Objects.isNull(childTableKeys)) {
					childTableKeys = new ArrayList<>(tableCollection.size());
					tmpTableRelationMap.put(parentKey, childTableKeys);
				}
				childTableKeys.add(metaTable.getKey());
			}
			tableRelationMap = tmpTableRelationMap;
		}

		if (tableRelationMap.size() == 0) {
			return null;
		}

		return tableRelationMap.get(tableKey);
	}

	/**
	 * 取所有的表格
	 *
	 * @return
	 */
	public List<MetaGrid> getMetaGrids() {
		return metaGrids;
	}

	public List<MetaTableRow> getMetaDetailTableRows() {
		return metaDetailTableRows;
	}

	/**
	 * 取所有的字段
	 *
	 * @return
	 */
	public Collection<String> getFieldKeys() {
		return fieldKey2FieldInfo.keySet();
	}

	/**
	 * 根据gridKey取得表格
	 *
	 * @param gridKey
	 * @return
	 */
	public MetaGrid getMetaGridByGridKey(String gridKey) {
		if (CollectionUtils.isEmpty(metaGrids)) {
			return null;
		}
		for (MetaGrid metaGird : metaGrids) {
			if (metaGird.getKey().equalsIgnoreCase(gridKey)) {
				return metaGird;
			}
		}
		return null;
	}

	public MetaTableRow getMetaTableDetailRowByRowKey(String rowKey) {
		if (CollectionUtils.isEmpty(metaDetailTableRows)) {
			return null;
		}
		for (MetaTableRow metaTableRow : metaDetailTableRows) {
			if (metaTableRow.getKey().equalsIgnoreCase(rowKey)) {
				return metaTableRow;
			}
		}
		return null;
	}

	/**
	 * 根据字段Key取得TableKey
	 *
	 * @param
	 * @return
	 */
	public String getTableKeyByFieldKey(String fieldKey) {
		MetaTable metaTable = getTableByFieldKey(fieldKey);
		String result = null;
		if (metaTable != null) {
			result = metaTable.getKey();
		}
		return result;
	}

	public MetaTable getTableByFieldKey(String fieldKey) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		return fieldInfo.metaTable;
	}

	/**
	 * 根据字段Key取得数据库名
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getTableNameByFieldKey(String fieldKey) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		String result = null;
		MetaTable metaTable = fieldInfo.metaTable;
		if (metaTable != null) {
			result = metaTable.getBindingDBTableName();
		}
		return result;
	}

	/**
	 * 根据字段Key取得ColumnKey
	 *
	 * @param fieldKey
	 * @return
	 * @throws Exception
	 */
	public String getColumnKeyByFieldKey(String fieldKey) throws Exception {
		MetaDataBinding metaDataBinding = getMetaDataBinding(fieldKey);
		String result = null;
		if (metaDataBinding != null) {
			result = metaDataBinding.getColumnKey();
		}
		return result;
	}

	/**
	 * 根据字段Key取得字段类型
	 *
	 * @param fieldKey
	 * @return
	 */
	public int getDataTypeByFieldKey(String fieldKey) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return -1;
		}
		MetaColumn metaColumn = fieldInfo.metaColumn;
		int result = -1;
		if (metaColumn != null) {
			result = metaColumn.getDataType();
		} else {
			if (fieldInfo.metaObject instanceof MetaColumnExpand) {
				MetaColumnExpand columnExpand = (MetaColumnExpand) fieldInfo.metaObject;
				String columnKey = columnExpand.getColumnKey();
				return fieldInfo.metaTable.get(columnKey).getDataType();
			}
		}
		return result;
	}

	/**
	 * 根据字段Key取表格Key
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getGridKeyByFieldKey(String fieldKey) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		String result = fieldInfo.gridKey;
		return result;
	}

	/**
	 * 根据字段Key取得值变化事件
	 *
	 * @param fieldKey
	 * @return
	 * @throws Exception
	 */
	public String getValueChangedByFieldKey(String fieldKey) throws Exception {
		String result = null;
		MetaDataBinding metaDataBinding = getMetaDataBinding(fieldKey);
		if (metaDataBinding != null) {
			result = metaDataBinding.getValueChanged();
		}
		return result;
	}

	/**
	 * 根据字段取OnClick的表达式
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getOnClickByFieldKey(String fieldKey) {
		String result = null;
		MetaComponent metaComponent = metaForm.componentByKey(fieldKey);
		if (metaComponent instanceof MetaButton) {
			if (((MetaButton) metaComponent).getOnClick() != null) {
				result = ((MetaButton) metaComponent).getOnClick().getContent();
			}
		} else {

		}
		return result;
	}

	/**
	 * 取字典的过滤条件
	 *
	 * @param fieldKey
	 * @return
	 */
	public MetaItemFilterCollection getMetaItemFiltersByFieldKey(String fieldKey) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		return fieldInfo.itemFilters;
	}

	/**
	 * 判断表单中是否存在某个字段，用于写测试代码
	 *
	 * @param fieldKey
	 * @return
	 */
	public boolean containFieldKey(String fieldKey) {
		return this.fieldKey2FieldInfo.containsKey(fieldKey);
	}

	/**
	 * 判断表单中是否存在某个字段，用于写测试代码
	 *
	 * @param fieldKey
	 * @return
	 */
	public boolean containNoFieldKey(String fieldKey) {
		return this.key2NoFieldComponent.containsKey(fieldKey);
	}

	/**
	 * 根据数据库tableKey和columnKey取得字段key
	 * 目前只能找到一个
	 *
	 * @param tableKey
	 * @param columnKey
	 * @return
	 */
	public String getFieldKeyByTableColumnKey(String tableKey, String columnKey) {
		if (Objects.isNull(tableColumnKey2FieldKeys)) {
			return null;
		}
		Map<String, String> columnKey2FieldKey = tableColumnKey2FieldKeys.get(tableKey);
		String result = null;
		if (columnKey2FieldKey != null) {
			result = columnKey2FieldKey.get(columnKey);
		}
		return result;
	}

	/**
	 * 根据数据库tableKey和columnKey取得字段key
	 * 设计器专用
	 *
	 * @param tableKey
	 * @param columnKey
	 * @return
	 */
	public List<String> getFieldListKeyByTableColumnKey(String tableKey, String columnKey) {
		Map<String, List<String>> columnKey2FieldKey = tableColumnKey2FieldListKeys.get(tableKey);
		List<String> result = null;
		if (columnKey2FieldKey != null) {
			result = columnKey2FieldKey.get(columnKey);
		}
		return result;
	}

	static private final Map<MetaForm, IDLookup> IDLookups = new HashMap<MetaForm, IDLookup>();

	static public IDLookup getIDLookup(MetaForm metaForm) {
		IDLookup result = IDLookups.get(metaForm);
		if (Objects.isNull(result)) {
			synchronized (IDLookups) {
				result = IDLookups.get(metaForm);
				if (Objects.isNull(result)) {
					result = new IDLookup(metaForm);
					IDLookups.put(metaForm, result);
				}
			}
		}
		return result;
	}

	/**
	 * 重新加载IDLookup，用于配置升级或对配置改动后
	 *
	 * @param metaForm
	 * @return
	 */
	public static IDLookup reloadIDLookup(MetaForm metaForm) {
		synchronized (IDLookups) {
			IDLookup idLookup = new IDLookup(metaForm);
			IDLookups.put(metaForm, idLookup);
		}
		return IDLookups.get(metaForm);
	}

	/**
	 * 根据字段Key取ItemKey
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getItemKeyByFieldKey(String fieldKey) {
		String itemKey = null;
		MetaComponent metaComponent = metaForm.componentByKey(fieldKey);
		if (metaComponent != null && metaComponent.getControlType() == ControlType.DICT) {
			MetaDict dict = (MetaDict) metaComponent;
			itemKey = dict.getItemKey();
		} else if (metaComponent != null && metaComponent.getControlType() == ControlType.DYNAMICDICT) {
			MetaDynamicDict dyDict = (MetaDynamicDict) metaComponent;
			itemKey = dyDict.getRefKey();
		} else {
			MetaGridCell metaGridCell = metaForm.metaGridCellByKey(fieldKey);
			if (metaGridCell != null && metaGridCell.getCellType() == ControlType.DICT) {
				MetaDictProperties dictProperties = (MetaDictProperties) metaGridCell.getProperties();
				itemKey = dictProperties.getItemKey();
			} else if (metaGridCell != null && metaGridCell.getCellType() == ControlType.DYNAMICDICT) {
				MetaDictProperties dictProperties = (MetaDictProperties) metaGridCell.getProperties();
				itemKey = dictProperties.getRefKey();
			}
		}
		return itemKey;
	}

	/**
	 * 判断是否是多选字典
	 *
	 * @param fieldKey
	 * @return
	 */
	public boolean isMultiSelectionDict(String fieldKey) {
		MetaComponent metaComponent = metaForm.componentByKey(fieldKey);
		MetaDictProperties properties = null;
		if (metaComponent != null && metaComponent.getControlType() == ControlType.DICT) {
			properties = (MetaDictProperties) metaComponent.getProperties();
		} else {
			MetaGridCell metaGridCell = metaForm.metaGridCellByKey(fieldKey);
			if (metaGridCell != null && metaGridCell.getCellType() == ControlType.DICT) {
				properties = (MetaDictProperties) metaGridCell.getProperties();
			}
		}

		return properties != null && properties.isAllowMultiSelection();
	}

	/**
	 * 判断是否是动态字典
	 *
	 * @param fieldKey
	 * @return
	 */
	public boolean isDynamicDict(String fieldKey) {
		MetaComponent metaComponent = metaForm.componentByKey(fieldKey);
		if (metaComponent != null) {
			return metaComponent.getControlType() == ControlType.DYNAMICDICT;
		} else {
			MetaGridCell metaGridCell = metaForm.metaGridCellByKey(fieldKey);
			return metaGridCell != null && metaGridCell.getCellType() == ControlType.DYNAMICDICT;
		}
	}

	public MetaColumn getMetaColumnByFieldKey(String fieldKey) {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		if (Objects.isNull(fieldInfo)) {
			return null;
		}
		return fieldInfo.metaColumn;
	}

	/**
	 * 根据字段Key，得到控件所在tab名称。目前仅用于多组织字典·
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getTabKeyByFieldKey(String fieldKey) {
		String tabKey = null;
		if (Objects.isNull(componentTab)) {
			synchronized (IDLookup.class) {
				if (Objects.isNull(componentTab)) {
					initComponentTab();
				}
			}
		}
		if (componentTab.containsKey(fieldKey)) {
			tabKey = componentTab.get(fieldKey);
		}
		return tabKey;
	}

	/**
	 * 根据字段Key,获取下拉框来源项
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getComboBoxItemsByFieldKey(String fieldKey) {
		String result = "";
		MetaComponent metaComponent = metaForm.componentByKey(fieldKey);
		if (metaComponent != null && metaComponent.getControlType() == ControlType.COMBOBOX) {
			MetaComboBox comboBox = (MetaComboBox) metaComponent;
			if (comboBox.getFormulaItems() != null) {
				result = comboBox.getFormulaItems().getContent();
			}

		} else {
			MetaGridCell metaGridCell = metaForm.metaGridCellByKey(fieldKey);
			if (metaGridCell != null && metaGridCell.getCellType() == ControlType.COMBOBOX) {
				MetaComboBoxProperties comboBoxProperties = (MetaComboBoxProperties) metaGridCell.getProperties();
				if (comboBoxProperties.getFormulaItems() != null) {
					result = comboBoxProperties.getFormulaItems().getContent();
				}
			}
		}
		return result;
	}

	public List<String> getNoTableGridCell(String gridKey) {
		return this.noTableGridCell.get(gridKey);
	}

	/**
	 * 获取字段类型，这里的类型是2.0的定义 与1.6不一样
	 *
	 * @param fieldKey
	 * @return
	 * @throws Throwable
	 */
	public String getFieldControlType(String fieldKey) throws Throwable {
		FieldInfo fieldInfo = fieldKey2FieldInfo.get(fieldKey);
		AbstractMetaObject metaObject = fieldInfo.metaObject;
		if (metaObject instanceof MetaComponent) {
			MetaComponent metaComponent = (MetaComponent) metaObject;
			int controlType = metaComponent.getControlType();
			return ControlType.toString(controlType);
		} else if (metaObject instanceof MetaGridCell) {
			MetaGridCell metaGridCell = (MetaGridCell) metaObject;
			int metaGridCellType = metaGridCell.getCellType();
			return ControlType.toString(metaGridCellType);
		} else if (metaObject instanceof MetaColumnExpand) {
//			MetaColumnExpand metaColumnExpand = (MetaColumnExpand)metaObject;
//			metaColumnExpand.
			return "";
		} else {
			throw new Exception("");
		}

	}

	/**
	 * 获得某个数据源的ColumnKey和字段key
	 *
	 * @param metaTableKey
	 * @return
	 */
	public Map<String, String> getColumKeysAndFieldKeys(String metaTableKey) {
		//如果模板进到这里tableColumnKey2FieldKeys为空
		if (Objects.isNull(tableColumnKey2FieldKeys)) {
			return null;
		}
		return tableColumnKey2FieldKeys.get(metaTableKey);
	}

	/**
	 * 获得某个数据源的ColumnKey和字段key
	 *
	 * @param metaTableKey
	 * @return
	 */
	public Map<String, List<String>> getColumKeysAndFieldListKeys(String metaTableKey) {
		//如果模板进到这里tableColumnKey2FieldKeys为空
		if (Objects.isNull(tableColumnKey2FieldListKeys)) {
			return null;
		}
		return tableColumnKey2FieldListKeys.get(metaTableKey);
	}


	private boolean isBlankOrNull(String str) {
		if (StringUtils.isBlank(str)) {
			return true;
		}
		return false;
	}

	public int getDataTypeByComponentKey(String key) throws Exception {
		MetaComponent component = this.getComponentByKey(key);
		int controlType = component.getControlType();
		switch (controlType) {
			case ControlType.DICT:
			case ControlType.DYNAMICDICT:
			case ControlType.COMPDICT: {
				if (((MetaDict) component).isAllowMultiSelection()) {
					return DataType.STRING;
				}
				return DataType.LONG;
			}
			case ControlType.CHECKBOX:
				return DataType.INT;
			case ControlType.CHECKLISTBOX:
				return DataType.STRING;
			case ControlType.NUMBEREDITOR:
				if (((MetaNumberEditor) component).getScale() == 0) {
					return DataType.INT;
				}
				return DataType.NUMERIC;
			case ControlType.UTCDATEPICKER:
				return DataType.LONG;
			case ControlType.DATEPICKER:
				if ("yyyy-MM-dd".equalsIgnoreCase(((MetaDatePicker) component).getDateFormat())) {
					return DataType.DATE;
				}
				return DataType.DATETIME;
			case ControlType.COMBOBOX:
				if (((MetaComboBox) component).isIntegerValue()) {
					return DataType.INT;
				}
				return DataType.STRING;
			default:
				return DataType.STRING;
		}
	}

	/**
	 * 根据字段Key取得字段的CheckRule
	 *
	 * @param fieldKey
	 * @return
	 * @throws Exception
	 */
	public String getCheckRuleByFieldKey(String fieldKey) throws Exception {
		String result = null;
		MetaDataBinding metaDataBinding = getMetaDataBinding(fieldKey);
		if (metaDataBinding != null) {
			result = metaDataBinding.getCheckRule();
		}
		return result;
	}

	public StringHashMap<String> getAllDicFiledKey2ItemKey() {
		return dicFiledKey2ItemKey;
	}

	public List<String> getFieldListByTableKey(String tableKey) {
		if (Objects.isNull(tableFields)) {
			tableFields = new StringHashMap<List<String>>();
		}
		if (tableFields.containsKey(tableKey)) {
			return tableFields.get(tableKey);
		} else {
			List<String> fieldsList = new ArrayList<String>();
			for (String fieldKey : fieldKey2FieldInfo.keySet()) {
				if (StringUtils.isEmpty(fieldKey)) {
					continue;
				}
				String temp = this.getTableKeyByFieldKey(fieldKey);
				if (StringUtils.isBlank(temp)) {
					continue;
				}
				if (temp.equalsIgnoreCase(tableKey)) {
					fieldsList.add(fieldKey);
				}
			}
			tableFields.put(tableKey, fieldsList);
			return fieldsList;
		}
	}

	public boolean isRequired(String fieldKey) throws Throwable {
		MetaDataBinding metaDataBinding = getMetaDataBinding(fieldKey);
		return metaDataBinding.isRequired();
	}

//	private HashMap<String, HashMap<String, MetaSourceField>> mapFieldSourceRelation = new HashMap<String, HashMap<String, MetaSourceField>>();
//	private HashMap<String, HashMap<String, MetaSourceField>> mapFieldKeyRelation = new HashMap<String, HashMap<String, MetaSourceField>>();

	/**
	 * 根据伙伴字段Key取得字段Key
	 *
	 * @param buddyKey
	 * @return
	 */
	public String getFieldKeyByBuddyKey(String buddyKey) {
		return buddyKey2FieldKeys.get(buddyKey);
	}

	/**
	 * 根据FieldKey取所属的PanelKey
	 *
	 * @param fieldKey
	 * @return
	 */
	public String getPanelKeyByFieldKey(String fieldKey) {
		return fieldKey2PanelKeys.get(fieldKey);
	}

	/**
	 * 判断是否是表头字段
	 *
	 * @param fieldKey
	 * @return
	 */
	public boolean isHeadField(String fieldKey) {
		String gridKey = this.getGridKeyByFieldKey(fieldKey);
		return StringUtil.isBlankOrNull(gridKey);
	}

	/**
	 * 判断表格是否有列扩展字段
	 */
	public List<String> getGridColumnExpands(String gridKey) {
		if (gridColumnExpands.containsKey(gridKey)) {
			return gridColumnExpands.get(gridKey);
		}
		return null;
	}

	public String getColumnCaption(String tableKey, String columnKey) {
		return this.metaForm.getDataSource().getDataObject().getMetaTable(tableKey).get(columnKey).getCaption();
	}

	/**
	 * 取所有带表达式下拉内容且不缓存的下拉框
	 *
	 * @return
	 */
	public List<KeyPairMetaObject> getAllComboBoxWithNoCacheFormula() {
		List<KeyPairMetaObject> result = null;
		for (Map.Entry<String, FieldInfo> entry : fieldKey2FieldInfo.entrySet()) {
			FieldInfo fieldInfo = entry.getValue();
			AbstractMetaObject metaObject = fieldInfo.metaObject;
			if (metaObject instanceof MetaComboBox) {
				MetaComboBox metaComboBox = (MetaComboBox) metaObject;
				MetaComboBoxProperties properties = metaComboBox.getProperties();
				if (!properties.getCache() && properties.getSourceType() == ComboBoxSourceType.FORMULA) {
					if (Objects.isNull(result)) {
						result = new ArrayList<KeyPairMetaObject>();
					}
					result.add(metaComboBox);
				}
			} else if (metaObject instanceof MetaGridCell) {
				MetaGridCell metaGridCell = (MetaGridCell) metaObject;
				if (metaGridCell.getCellType() == ControlType.COMBOBOX) {
					MetaComboBoxProperties properties = (MetaComboBoxProperties) metaGridCell.getProperties();
					if (!properties.getCache() && properties.getSourceType() == ComboBoxSourceType.FORMULA) {
						if (Objects.isNull(result)) {
							result = new ArrayList<KeyPairMetaObject>();
						}
						result.add(metaGridCell);
					}
				}
			}
		}
		return result;
	}

	public boolean containTableKey(String tableKey) {
		return this.metaForm.getDataSource().getDataObject().contains(tableKey);
	}

	/**
	 * 根据列名返回表标志， 只返回第一个匹配到的表
	 *
	 * @param columnKey
	 * @return
	 */
	public String getTableKeyByDBColumnKey(String columnKey) {
		MetaDataObject metaDataObject = this.metaForm.getDataSource().getDataObject();
		if (Objects.isNull(metaDataObject) || Objects.isNull(metaDataObject.getTableCollection())) {
			return null;
		}
		for (MetaTable metaTable : metaDataObject.getTableCollection()) {
			if (metaTable.containsKey(columnKey)) {
				return metaTable.getKey();
			}
		}
		return null;
	}


	static {
		MetaObjectChange.register(new MetaObjectChangeListener() {
			@Override
			public void changeMetaAll() {
				// TODO Auto-generated method stub

			}

			@Override
			public void changeMetaForm(MetaForm metaForm) throws Throwable {
				synchronized (IDLookups) {
					IDLookups.remove(metaForm);
				}
			}

			@Override
			public void changeMetaDataObject(MetaDataObject metaDataObject) throws Throwable {
				// TODO Auto-generated method stub

			}
		},"MetaCache");
	}
}

/**
 * 程序处理中需要字段相关信息
 */
class FieldInfo {
	public FieldInfo(MetaTable metaTable, MetaColumn metaColumn, String gridKey, String defaultValue,
					 String defaultFormulaValue, String enable, String visible, String checkRule, MetaItemFilterCollection itemFilters, AbstractMetaObject metaObject) {
		this.metaTable = metaTable;
		this.metaColumn = metaColumn;
		this.gridKey = gridKey;
		this.defaultValue = defaultValue;
		this.defaultFormulaValue = defaultFormulaValue;
		this.enable = enable;
		this.visible = visible;
		this.checkRule = checkRule;
		this.itemFilters = itemFilters;
//		this.metaComponent = metaComponent;
//		this.metaGridCell = metaGridCell;
		this.metaObject = metaObject;
	}

	final MetaTable metaTable;
	final MetaColumn metaColumn;
	final String gridKey;
	final String defaultValue;
	final String defaultFormulaValue;
	final String enable;
	final String visible;
	final String checkRule;
	final MetaItemFilterCollection itemFilters;
	final AbstractMetaObject metaObject;
//	final MetaComponent metaComponent;
//	final MetaGridCell metaGridCell;
}
