package com.bokesoft.yes.design.utils;

import com.bokesoft.yes.design.vo.CheckXSDResult;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNode;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeDefine;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.util.MetaUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.*;

public class CheckXSDUtils {
    private static final DefaultNodeDefine defaultNodeDefine = DefaultNodeDefine.getInstance();
    public static final String W3C_XML_SCHEMA11_NS_URI = "http://www.w3.org/XML/XMLSchema/v1.1".intern();
    private final static List<String> extList = Arrays.asList("webconfig");
    public final static Set<String> skipMsgSet = new HashSet<>();

    static {
        skipMsgSet.add("");
    }

    /**
     * * 设置例外表单
     */
    public static HashMap<String, HashSet<String>> EXCLUDE = new HashMap<String, HashSet<String>>() {
        /**
         *
         */
        private static final long serialVersionUID = 1L;

        {
            put("GS_DataTable_Rpt", new HashSet<String>() {{
                add("cvc-complex-type.2.4.b: The content of element 'Table' is not complete. One of '{Column}' is expected.");
                add("cvc-complex-type.2.4.b: The content of element 'GridColumnCollection' is not complete. One of '{GridColumn}' is expected.");
                add("cvc-complex-type.2.4.b: The content of element 'GridRow' is not complete. One of '{GridCell}' is expected.");
            }});// table下没column;GridColumnCollection下没GridColumn;GridRow下没GridCell
            put("GS_DataQuery_Rpt", new HashSet<String>() {{
                add("cvc-complex-type.2.4.b: The content of element 'Table' is not complete. One of '{Column}' is expected.");
                add("cvc-complex-type.2.4.b: The content of element 'GridColumnCollection' is not complete. One of '{GridColumn}' is expected.");
                add("cvc-complex-type.2.4.b: The content of element 'GridRow' is not complete. One of '{GridCell}' is expected.");
            }});// table下没column;GridColumnCollection下没GridColumn;GridRow下没GridCell
            put("Report_30", new HashSet<String>() {
            });// 特殊报表
            put("Report_20", new HashSet<String>() {
            });// 特殊报表
            put("Report_10", new HashSet<String>() {
            });// 特殊报表
            put("HR_Roster_Module", new HashSet<String>() {{
                add("cvc-complex-type.2.4.b: The content of element 'GridColumnCollection' is not complete. One of '{GridColumn}' is expected.");
                add("cvc-complex-type.2.4.b: The content of element 'GridRow' is not complete. One of '{GridCell}' is expected.");
            }});// GridColumnCollection与GridRow不检查
            put("GridSettingVariantDialog", new HashSet<String>() {{
                add("cvc-pattern-valid: Value 'columnkey' is not facet-valid with respect to pattern '[A-Z][a-zA-Z0-9_]*' for type 'yigo-Key-Restriction30'.");
                add("cvc-attribute.3: The value 'columnkey' of attribute 'Key' on element 'Column' is not valid with respect to its type, 'yigo-Key-Restriction30'.");
                add("cvc-pattern-valid: Value 'name' is not facet-valid with respect to pattern '[A-Z][a-zA-Z0-9_]*' for type 'yigo-Key-Restriction30'.");
                add("cvc-attribute.3: The value 'name' of attribute 'Key' on element 'Column' is not valid with respect to its type, 'yigo-Key-Restriction30'.");
                add("cvc-identity-constraint.4.1: Duplicate unique value [null] found for identity constraint \"uniqueColumnKey\" of element \"Table\".");
            }});//ColumnKey中columnkey与name暂不能改
            put("HR_CHNEmployeInfo", new HashSet<String>() {{
                add("cvc-complex-type.2.4.b: The content of element 'TabPanel' is not complete. One of '{Format, Dict, DynamicDict, TextEditor, TextArea, CheckBox, ComboBox, CheckListBox, DatePicker, UTCDatePicker, MonthPicker, TimePicker, Button, NumberEditor, Label, TextButton, RadioButton, PasswordEditor, Image, WebBrowser, RichEditor, HyperLink, Separator, DropdownButton, Activate, Icon, Custom, BPMGraph, Dynamic, Carousel, EditView, GridLayoutPanel, FlexFlowLayoutPanel, FlexGridLayoutPanel, FlowLayoutPanel, BorderLayoutPanel, Embed, TabPanel, SplitPanel, Container, Grid, SubDetail, DictView, LinearLayoutPanel, PopView, HoverButton, TableView, TabGroup, TableRow}' is expected.");
                add("cvc-complex-type.2.4.a: Invalid content was found starting with element 'ItemChanged'. One of '{Format, Dict, DynamicDict, TextEditor, TextArea, CheckBox, ComboBox, CheckListBox, DatePicker, UTCDatePicker, MonthPicker, TimePicker, Button, NumberEditor, Label, TextButton, RadioButton, PasswordEditor, Image, WebBrowser, RichEditor, HyperLink, Separator, DropdownButton, Activate, Icon, Custom, BPMGraph, Dynamic, Carousel, EditView, GridLayoutPanel, FlexFlowLayoutPanel, FlexGridLayoutPanel, FlowLayoutPanel, BorderLayoutPanel, Embed, TabPanel, SplitPanel, Container, Grid, SubDetail, DictView, LinearLayoutPanel, PopView, HoverButton, TableView, TabGroup, TableRow}' is expected.");
            }});// Form下TabPanel不检查
            put("HR_PersonnelAction_", new HashSet<String>() {{
                add("cvc-complex-type.2.4.b: The content of element 'TabPanel' is not complete. One of '{Format, Dict, DynamicDict, TextEditor, TextArea, CheckBox, ComboBox, CheckListBox, DatePicker, UTCDatePicker, MonthPicker, TimePicker, Button, NumberEditor, Label, TextButton, RadioButton, PasswordEditor, Image, WebBrowser, RichEditor, HyperLink, Separator, DropdownButton, Activate, Icon, Custom, BPMGraph, Dynamic, Carousel, EditView, GridLayoutPanel, FlexFlowLayoutPanel, FlexGridLayoutPanel, FlowLayoutPanel, BorderLayoutPanel, Embed, TabPanel, SplitPanel, Container, Grid, SubDetail, DictView, LinearLayoutPanel, PopView, HoverButton, TableView, TabGroup, TableRow}' is expected.");
            }});// Form下TabPanel不检查
            put("HR_LogTreeEmb", new HashSet<String>() {{
                add("cvc-complex-type.2.4.b: The content of element 'TabPanel' is not complete. One of '{Format, Dict, DynamicDict, TextEditor, TextArea, CheckBox, ComboBox, CheckListBox, DatePicker, UTCDatePicker, MonthPicker, TimePicker, Button, NumberEditor, Label, TextButton, RadioButton, PasswordEditor, Image, WebBrowser, RichEditor, HyperLink, Separator, DropdownButton, Activate, Icon, Custom, BPMGraph, Dynamic, Carousel, EditView, GridLayoutPanel, FlexFlowLayoutPanel, FlexGridLayoutPanel, FlowLayoutPanel, BorderLayoutPanel, Embed, TabPanel, SplitPanel, Container, Grid, SubDetail, DictView, LinearLayoutPanel, PopView, HoverButton, TableView, TabGroup, TableRow}' is expected.");
            }});// Form下TabPanel不检查
            put("Workspace", new HashSet<String>() {{
                add("cvc-complex-type.3.2.2: Attribute 'Provider' is not allowed to appear in element 'Body'.");
            }});// Workspace不检查

        }
    };


    public static void resortAttrPosition(TagNode tagNode, String filePath) {
        String tagName = tagNode.getTagName();
        Map<String, String> attributes = tagNode.getAttributes();
        DefaultNode defaultNode = defaultNodeDefine.getDefaultNode(tagName);
        Map<String, String> newSortedMap;
        if (defaultNode != null && !defaultNode.values().isEmpty()) {
            List<String> defaultNodeAttrList = defaultNode.getAttrList();
            newSortedMap = customSort(defaultNodeAttrList, new LinkedHashMap<>(attributes));
        } else {
            newSortedMap = customSort(null, new LinkedHashMap<>(attributes));
        }
        attributes.clear();
        attributes.putAll(newSortedMap);
        for (AbstractNode child : tagNode.getChildren()) {
            if (child instanceof TagNode) {
                resortAttrPosition((TagNode) child, filePath);
            }
        }
    }

    /**
     * Key和Caption排最前，如果存在的话
     * XmlNodeDefine中的defaultNodeAttrList，次之，注意这是有序的
     * 最后遗留的属性追加到后面
     *
     * @param defaultNodeAttrList
     * @param attributes
     * @return
     */
    public static Map<String, String> customSort(List<String> defaultNodeAttrList, Map<String, String> attributes) {
        Map<String, String> sortedMap = new LinkedHashMap<>();
        String key = "Key";
        if (attributes.containsKey(key)) {
            sortedMap.put(key, attributes.get(key));
            attributes.remove(key);
        }
        String caption = "Caption";
        if (attributes.containsKey(caption)) {
            sortedMap.put(caption, attributes.get(caption));
            attributes.remove(caption);
        }

        if (defaultNodeAttrList != null) {
            for (String elem : defaultNodeAttrList) {
                if (attributes.containsKey(elem)) {
                    sortedMap.put(elem, attributes.get(elem));
                    attributes.remove(elem);
                }
            }
        }
        sortedMap.putAll(attributes);
        return sortedMap;
    }

    /**
     * 加载xsd文件
     *
     * @return
     */
    public static HashMap<String, Source> loadSchemaSourceMap(IMetaFactory metaFactory) {
        HashMap<String, Source> schemaSourceMap = new HashMap<>();
        // 加载元素与xsd文件名的对应关系
        HashMap<String, String> elementKey_XSDMap = new HashMap<String, String>() {{
            put("DataObject", "DataObject.xsd");
            put("Form", "Form.xsd");
            put("Map", "Map.xsd");
            put("CommonDef", "CommonDef.xsd");
            put("DataMigration", "DataMigration.xsd");
            put("DataElementDef", "DataElementDef.xsd");
            put("DomainDef", "DomainDef.xsd");
            put("Entry", "Entry.xsd");
        }};
        for (Map.Entry<String, String> entry : elementKey_XSDMap.entrySet()) {
            String elementKey = entry.getKey();
            String xsdName = entry.getValue();
            String xsdFilePath =
                    metaFactory.getSolutionPath() + File.separator + "Resource" + File.separator + "xsd" + File.separator + xsdName;
            File schemaFile = new File(xsdFilePath);
            Source schemaSource = new StreamSource(schemaFile);
            schemaSourceMap.put(elementKey, schemaSource);
        }
        return schemaSourceMap;
    }

    public static CheckXSDResult checkXSD(IMetaFactory metaFactory, String tagName, String key, String fileName, String newXml,
                                          String projectKey, MetaCommonDef metaCommonDef, MetaEntry metaEntry) throws Throwable {
        CheckXSDResult checkXSDResult = new CheckXSDResult();
        try {
            // 创建一个SchemaFactory实例
            SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA11_NS_URI);
            HashMap<String, Source> schemaSourceMap = loadSchemaSourceMap(metaFactory);
            Source source = schemaSourceMap.get(tagName);
            // 编译XML Schema
            Schema schema = schemaFactory.newSchema(source);
            // 创建一个Validator实例
            Validator validator = schema.newValidator();
            switch (tagName) {
                case "DataObject":
                    MetaDataObjectProfile metaDataObjectProfile = metaFactory.getDataObjectList().get(key);
                    // 排除一些不需要检查的
                    if (EXCLUDE.containsKey(metaDataObjectProfile.getKey()) && EXCLUDE.get(metaDataObjectProfile.getKey()).isEmpty()) {
                        checkXSDResult.setPass(true);
                        break;
                    }
                    checkXSDResult = validateXML(validator, fileName, newXml);
                    break;
                case "Form":
                    MetaFormProfile metaFormProfile = metaFactory.getMetaFormList().get(key);
                    projectKey = metaFormProfile.getProject().getKey();
                    // 排除一些不需要检查的
                    if (EXCLUDE.containsKey(key) && EXCLUDE.get(key).isEmpty()) {
                        checkXSDResult.setPass(true);
                        break;
                    }
                    if (key.startsWith("ReportCell_")) {
                        checkXSDResult.setPass(true);
                        break;
                    }
                    if (extList.contains(projectKey)) {
                        checkXSDResult.setPass(true);
                        break;
                    }
                    checkXSDResult = validateXML(validator, fileName, newXml);
                    break;
                case "Map":
                    ERPMetaMap erpMetaMap = metaFactory.getMetaCustomObject(ERPMetaMap.class, key);
                    // 排除一些不需要检查的
                    if (EXCLUDE.containsKey(erpMetaMap.getKey()) && EXCLUDE.get(erpMetaMap.getKey()).isEmpty()) {
                        checkXSDResult.setPass(true);
                        break;
                    }
                    checkXSDResult = validateXML(validator, fileName, newXml);
                    break;
                case "CommonDef":
                    if (metaCommonDef == null) {
                        checkXSDResult.setPass(true);
                        break;
                    }
                    checkXSDResult = validateXML(validator, fileName, newXml);
                    break;
                case "DataMigration":
                    checkXSDResult = validateXML(validator, fileName, newXml);
                    break;
                case "DataElementDef":
                   /* MetaDataElement dataElement = MetaUtil.getDataElement(metaFactory, key);
                    for (MetaSolution metaSolution : metaFactory.getMetaSolutions()) {
                        IMetaResolverFactory resolverFactory =
                                metaFactory.getMetaResolverFactoryBySolution(metaSolution.getKey());
                        IMetaResolver resolver = resolverFactory.newMetaResolver("");
                        String path = resolver.getPath("");
                        List<String> resourceList = new ArrayList<String>();
                        List<String> nameList = new ArrayList<String>();
                        List<Boolean> flagList = new ArrayList<Boolean>();
                        resolver.listResource(DomMetaConstants.DATAELEMENT_FOLD, ".xml", resourceList, nameList, flagList);
                        for (String s : resourceList) {
                            validateXML(validator, filePath, DomMetaConstants.DATAELEMENT_FOLD);
                        }
                    }*/
                    break;
                case "DomainDef":
                   /* for (MetaSolution metaSolution : metaFactory.getMetaSolutions()) {
                        IMetaResolverFactory resolverFactory =
                                metaFactory.getMetaResolverFactoryBySolution(metaSolution.getKey());
                        IMetaResolver resolver = resolverFactory.newMetaResolver("");
                        String path = resolver.getPath("");
                        List<String> resourceList = new ArrayList<String>();
                        List<String> nameList = new ArrayList<String>();
                        List<Boolean> flagList = new ArrayList<Boolean>();
                        resolver.listResource(DomMetaConstants.DOMAIN_FOLD, ".xml", resourceList, nameList, flagList);
                        for (String s : resourceList) {
                            validateXML(validator, filePath, DomMetaConstants.DOMAIN_FOLD);
                        }
                    }*/
                    break;
                case "Entry":
                    if (metaEntry == null) {
                        checkXSDResult.setPass(true);
                        break;
                    }
                    String filePath_Entry = metaFactory.getProjectResolverMap().get(projectKey).getPath("") + "Entry.xml";
                    checkXSDResult = validateXML(validator, filePath_Entry, newXml);
                    if (checkXSDResult.isPass()){
                        String filePath_ERPEntry = metaFactory.getProjectResolverMap().get(projectKey).getPath("") + "ERPEntry.xml";
                        checkXSDResult = validateXML(validator, filePath_ERPEntry, newXml);
                    }
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
            System.err.println("XML is not valid according to the XSD schema.");
        }
        return checkXSDResult;
    }

    /**
     * 校验XML文件
     *
     * @param validator
     * @throws IOException
     * @throws SAXException
     */
    private static CheckXSDResult validateXML(Validator validator, String fileName, String newXml) throws IOException, SAXException {
        CheckXSDResult checkXSDResult = new CheckXSDResult();
        ArrayList<Object> resultList = new ArrayList<>();
        XSDErrorHandler simpleErrorHandler = new XSDErrorHandler();
        validator.setErrorHandler(simpleErrorHandler);
        //此处没传路径，属性添加时，还未写入文件
        validator.validate(new StreamSource(new StringReader(newXml)));
        if (simpleErrorHandler.infoMap.containsKey(XSDErrorHandler.ERROR)) {
            HashSet<String> errorInfoSet = simpleErrorHandler.infoMap.get(XSDErrorHandler.ERROR);
            for (String errorInfo : errorInfoSet) {
                boolean skip = false;
                if (EXCLUDE.containsKey(fileName)) {
                    for (String error : EXCLUDE.get(fileName)) {
                        if (errorInfo.contains(error)) {
                            skip = true;
                            break;
                        }
                    }
                }
                if (!skip) {
                    resultList.add("表单" + fileName + "配置XSD规范检查，第" + errorInfo);
                }
            }
        }
        if (resultList.size() > 0) {
            checkXSDResult.setPass(false);
            checkXSDResult.setMsg(resultList.toString());
        }else{
            checkXSDResult.setPass(true);
        }
        return checkXSDResult;
    }
}

/**
 * 自定义错误处理器
 */
class XSDErrorHandler implements ErrorHandler {

    public static final String WARN = "Warn";
    public static final String ERROR = "Error";
    public static final String FATALERROR = "FatalError";

    public HashMap<String, LinkedHashSet<String>> infoMap = new HashMap<String, LinkedHashSet<String>>();

    public void warning(SAXParseException exception) throws SAXException {
        // XSMessageFormatter中读取properties文件的ResourceBundle.getBundle默认编码为ISO-8859-1，需转换输出
        String message = new String(exception.getMessage().getBytes(StandardCharsets.ISO_8859_1),StandardCharsets.UTF_8);
        String errorInfo = exception.getLineNumber() + "行" + exception.getColumnNumber() + "列:\t" + message;
        if (infoMap.containsKey(WARN)) {
            infoMap.get(WARN).add(errorInfo);
        } else {
            LinkedHashSet<String> errorList = new LinkedHashSet<>();
            errorList.add(errorInfo);
            infoMap.put(WARN, errorList);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        // XSMessageFormatter中读取properties文件的ResourceBundle.getBundle默认编码为ISO-8859-1，需转换输出
        String message = new String(exception.getMessage().getBytes(StandardCharsets.ISO_8859_1),StandardCharsets.UTF_8);
        if (CheckXSDUtils.skipMsgSet.contains(message)) {
            return;
        }
        String errorInfo = exception.getLineNumber() + "行" + exception.getColumnNumber() + "列:\t" + message;
        if (infoMap.containsKey(ERROR)) {
            infoMap.get(ERROR).add(errorInfo);
        } else {
            LinkedHashSet<String> errorList = new LinkedHashSet<>();
            errorList.add(errorInfo);
            infoMap.put(ERROR, errorList);
        }
    }
    public void fatalError(SAXParseException exception) throws SAXException {
        // XSMessageFormatter中读取properties文件的ResourceBundle.getBundle默认编码为ISO-8859-1，需转换输出
        String message = new String(exception.getMessage().getBytes(StandardCharsets.ISO_8859_1),StandardCharsets.UTF_8);
        if (CheckXSDUtils.skipMsgSet.contains(message)) {
            return;
        }
        String errorInfo = exception.getLineNumber() + "行" + exception.getColumnNumber() + "列:\t" + message;
        if (infoMap.containsKey(FATALERROR)) {
            infoMap.get(FATALERROR).add(errorInfo);
        } else {
            LinkedHashSet<String> errorList = new LinkedHashSet<>();
            errorList.add(errorInfo);
            infoMap.put(FATALERROR, errorList);
        }
    }
}
