package com.bokesoft.yes.design.sql;


import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;

/**
 * 传递参数数据
 */
public class TransmitConditions {

    //携带参数
    public String filedKey;
    public List<String> dependentFields;
    public String itemsDependency;
    public int cellType;
    public int SourceType = -1;//下拉框开源类型
    public MetaBaseScript formulaItems;//表达式表示的下拉项集合
    public String componentFieldCaption;

    public String itemColumnKey;
    public MetaQueryDef metaQueryDef;
    public String columnKey;
    public MetaColumn metaColumn; //记录控件对应的metaColumn
    private static final HashMap<String, TransmitConditions> transmitConditions = new HashMap<>();

    public TransmitConditions() {
    }

    public static TransmitConditions TransmitConditionsInit(String key) {
        TransmitConditions transmitConditions1 = transmitConditions.get(key);
        if (transmitConditions1 != null) {
            return transmitConditions1;
        }
        TransmitConditions transmitConditions2 = new TransmitConditions();
        transmitConditions.put(key, transmitConditions2);
        return transmitConditions2;

    }

    public List<String> getDependentFields() {
        return dependentFields;
    }

    public void setDependentFields(List<String> dependentFields) {
        this.dependentFields = dependentFields;
    }

    public String getItemsDependency() {
        return itemsDependency;
    }

    public void setItemsDependency(String itemsDependency) {
        this.itemsDependency = itemsDependency;
    }

    public int getSourceType() {
        return SourceType;
    }

    public void setSourceType(int sourceType) {
        SourceType = sourceType;
    }

    public void setFormulaItems(MetaBaseScript formulaItems) {
        this.formulaItems = formulaItems;
    }

    public MetaBaseScript getFormulaItems() {
        return formulaItems;
    }

    public String getComponentFieldCaption() {
        return componentFieldCaption;
    }

    public void setComponentFieldCaption(String componentFieldCaption) {
        if (StringUtils.isEmpty(componentFieldCaption)) {
            return;
        }
        this.componentFieldCaption = componentFieldCaption;
    }


    public MetaQueryDef getMetaQueryDef() {
        return metaQueryDef;
    }

    public void setMetaQueryDef(MetaQueryDef metaQueryDef) {
        this.metaQueryDef = metaQueryDef;
    }

    public String getColumnKey() {
        return columnKey;
    }

    public void setColumnKey(String columnKey) {
        if (StringUtils.isEmpty(columnKey)) {
            return;
        }
        if (columnKey.equalsIgnoreCase("SOID")
                || columnKey.equalsIgnoreCase("OID")
                || columnKey.equalsIgnoreCase("POID")
                || columnKey.equalsIgnoreCase("VERID")
                || columnKey.equalsIgnoreCase("DVERID")) {
            columnKey = columnKey.toUpperCase();
        }
        this.columnKey = columnKey.replaceAll("\"", "").replaceAll("'", "");
    }
    public int getCellType() {
        return cellType;
    }

    public void setCellType(int cellType) {
        this.cellType = cellType;
    }

    public String getItemColumnKey() {
        return itemColumnKey;
    }

    public void setItemColumnKey(String itemColumnKey) {
        if (StringUtils.isEmpty(itemColumnKey)) {
            return;
        }
        this.itemColumnKey = itemColumnKey;
    }

    public String getFiledKey() {
        return filedKey;
    }

    public void setFiledKey(String fileKey) {
        if (StringUtils.isEmpty(fileKey)) {
            return;
        }
        this.filedKey = fileKey.replaceAll("\"", "").replaceAll("'", "");
    }

    public void setMetaColumn(MetaColumn metaColumn ){
        this.metaColumn = metaColumn;
    }
    public MetaColumn getMetaColumn(){
        return this.metaColumn;
    }
}
