package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.solution.MetaSolutionLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaSolutionSave;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.FormTarget;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbar;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbarCollection;
import com.bokesoft.yigo.meta.solution.*;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

public class SolutionOperUtil extends HandleSettingImpl {

    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
//        SettingCommonUtils.saveXml(diff.getXmlTree(), diff.getXmlTree().xmlTree.getRoot(), diff, jsonObject);
        String xml = genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument(xml);
        MetaSolutionLoad solutionLoad = new MetaSolutionLoad(AppRunType.App);
        solutionLoad.load(document);
        MetaSolution metaSolution = (MetaSolution) solutionLoad.getRootMetaObject();
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        (new MetaSolutionSave(metaSolution)).save(designSettingMetaResolver, filePath);// 多语言配置转换有问题
    }

    public void reload(String filePath) {

    }

    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        // 处理头表数据
        dealHeadData(document, rootNode);
        // 处理工程集合
        dealProjectCollection(document, rootNode);
        // 处理融合工具栏
        dealInplaceToolbarCollection(document, rootNode);
        // 处理登录打开的表单集合
        dealPreLoadItemCollection(document, rootNode);
        // 处理国际化语种定义
        dealLangConfig(document, rootNode);
        // 处理启动项集合
        dealStartItemCollection(document, rootNode);
    }
    private void dealHeadData(Document document, TagNode rootNode) throws Throwable {
        DataTable solutionHead = document.get("ED_SolutionHead");
        solutionHead.setShowDeleted(true);
        if (isTableChange(solutionHead)) {
            String appKey = solutionHead.getString(0, "AppKey");
            String caption = solutionHead.getString(0, "Caption");
            String dataPath = solutionHead.getString(0, "DataPath");
            String startForm = solutionHead.getString(0, "StartForm");
            int securityLevel = solutionHead.getInt(0, "SecurityLevel");
            boolean isEnableMultiLang = solutionHead.getInt(0, "IsEnableMultiLang") == 1;
            String defaultLang = solutionHead.getString(0, "DefaultLang");
            String testLang = solutionHead.getString(0, "TestLang");
            String designEditorFactory = solutionHead.getString(0, "DesignEditorFactory");
            boolean isEnableDiff = solutionHead.getInt(0, "IsEnableDiff") == 1;

            if (StringUtils.isNotEmpty(caption)) {
                rootNode.setAttribute("Caption", caption);
            } else {
                rootNode.deleteAttribute("Caption");
            }

            if (StringUtils.isNotEmpty(appKey)) {
                rootNode.setAttribute("Key", appKey);
            } else {
                rootNode.deleteAttribute("Key");
            }

            if (StringUtils.isNotEmpty(dataPath)) {
                rootNode.setAttribute("DataPath", dataPath);
            } else {
                rootNode.deleteAttribute("DataPath");
            }

            if (StringUtils.isNotEmpty(startForm)) {
                rootNode.setAttribute("StartForm", startForm);
            } else {
                rootNode.deleteAttribute("StartForm");
            }

            if (securityLevel > 0) {
                rootNode.setAttribute("SecurityLevel", "" + securityLevel);
            } else {
                rootNode.deleteAttribute("SecurityLevel");
            }

            if (isEnableMultiLang) {
                rootNode.setAttribute("EnableMultiLang", "true");
            } else {
                rootNode.deleteAttribute("EnableMultiLang");
            }

            if (StringUtils.isNotEmpty(defaultLang) && !"zh-CN".equals(defaultLang)) {
                rootNode.setAttribute("DefaultLang", defaultLang);
            } else {
                rootNode.deleteAttribute("DefaultLang");
            }

            if (isEnableMultiLang) {
                rootNode.setAttribute("EnableMultiLang", "true");
            } else {
                rootNode.deleteAttribute("EnableMultiLang");
            }

            if (StringUtils.isNotEmpty(testLang)) {
                rootNode.setAttribute("TestLang", testLang);
            } else {
                rootNode.deleteAttribute("TestLang");
            }

            if (StringUtils.isNotEmpty(designEditorFactory)) {
                rootNode.setAttribute("DesignEditorFactory", designEditorFactory);
            } else {
                rootNode.deleteAttribute("DesignEditorFactory");
            }

            if (isEnableDiff) {
                rootNode.setAttribute("EnableDiff", "true");
            } else {
                rootNode.deleteAttribute("EnableDiff");
            }

        }
    }

    private void dealProjectCollection(Document document, TagNode rootNode) throws Throwable {
        DataTable project = document.get("ED_Project");
        project.setShowDeleted(true);
        if (!isTableChange(project)) {
            return;
        }
        project.setShowDeleted(false);
        rootNode.deleteChildByTagName(MetaProjectCollection.TAG_NAME);
        if (project.size() == 0) {
            return;
        }
        TagNode projectCollectionTag = rootNode.getOrCreateChildByTagName(MetaProjectCollection.TAG_NAME, 1);
        String projectKey;
        String projectCaption;
        String refPath;
        for (int i = 0; i < project.size(); i++) {
            projectKey = project.getString(i, "ProjectKey");
            projectCaption = project.getString(i, "ProjectCaption");
            refPath = project.getString(i, "RefPath");
            TagNode ProjectNode = new TagNode(MetaProjectProfile.TAG_NAME, null);
            ProjectNode.setAttribute("Caption", projectCaption);
            ProjectNode.setAttribute("Key", projectKey);
            if (StringUtils.isNotEmpty(refPath)) {
                ProjectNode.setAttribute("RefPath", refPath);
            }
            projectCollectionTag.addNode(ProjectNode);
        }
    }

    private void dealInplaceToolbarCollection(Document document, TagNode rootNode) throws Throwable {
        DataTable inplaceToolbar = document.get("ED_InplaceToolbar");
        inplaceToolbar.setShowDeleted(true);
        if (!isTableChange(inplaceToolbar)) {
            return;
        }
        inplaceToolbar.setShowDeleted(false);
        rootNode.deleteChildByTagName(MetaInplaceToolbarCollection.TAG_NAME);
        if (inplaceToolbar.size() == 0) {
            return;
        }
        TagNode inplaceToolbarCollectionTag = rootNode.getOrCreateChildByTagName(MetaInplaceToolbarCollection.TAG_NAME, 3);
        String tag;
        String handler;
        String description;
        for (int i = 0; i < inplaceToolbar.size(); i++) {
            tag = inplaceToolbar.getString(i, "Tag");
            handler = inplaceToolbar.getString(i, "Handler");
            description = inplaceToolbar.getString(i, "Description");
            TagNode inplaceToolbarNode = new TagNode(MetaInplaceToolbar.TAG_NAME, null);
            if (StringUtils.isNotEmpty(description)) {
                inplaceToolbarNode.setAttribute("Description", description);
            }
            inplaceToolbarNode.setAttribute("Handler", handler);
            inplaceToolbarNode.setAttribute("Tag", tag);
            inplaceToolbarCollectionTag.addNode(inplaceToolbarNode);
        }
    }

    private void dealStartItemCollection(Document document, TagNode rootNode) throws Throwable {
        DataTable startItem = document.get("ED_StartItem");
        startItem.setShowDeleted(true);
        if (!isTableChange(startItem)) {
            return;
        }
        startItem.setShowDeleted(false);
        rootNode.deleteChildByTagName(MetaStartItemCollection.TAG_NAME);
        if (startItem.size() == 0) {
            return;
        }
        TagNode StartItemCollectionTag = rootNode.getOrCreateChildByTagName(MetaStartItemCollection.TAG_NAME);
        String platformKey;
        String startFormKey;
        String loginFormKey;
        String applicationKey;
        for (int i = 0; i < startItem.size(); i++) {
            platformKey = startItem.getString(i, "PlatformKey");
            startFormKey = startItem.getString(i, "StartFormKey");
            loginFormKey = startItem.getString(i, "LoginFormKey");
            applicationKey = startItem.getString(i, "ApplicationKey");
            TagNode startItemNode = new TagNode(MetaStartItem.TAG_NAME, null);
            startItemNode.setAttribute("LoginForm", loginFormKey);
            startItemNode.setAttribute("StartForm", startFormKey);
            startItemNode.setAttribute("Platform", platformKey);
            if (StringUtils.isNotEmpty(applicationKey)) {
                startItemNode.setAttribute("AppKey", applicationKey);
            }
            StartItemCollectionTag.addNode(startItemNode);
        }
    }

    private void dealPreLoadItemCollection(Document document, TagNode rootNode) throws Throwable {
        DataTable preLoadItem = document.get("ED_PreLoadItem");
        preLoadItem.setShowDeleted(true);
        if (!isTableChange(preLoadItem)) {
            return;
        }
        preLoadItem.setShowDeleted(false);
        rootNode.deleteChildByTagName(MetaPreLoadItemCollection.TAG_NAME);
        if (preLoadItem.size() == 0) {
            return;
        }
        TagNode preLoadItemCollectionTag = rootNode.getOrCreateChildByTagName(MetaPreLoadItemCollection.TAG_NAME, 5);
        String preLoadItemKey;
        String entryPath;
        String condition;
        boolean isClose;
        String target;
        for (int i = 0; i < preLoadItem.size(); i++) {
            preLoadItemKey = preLoadItem.getString(i, "PreLoadItemKey");
            entryPath = preLoadItem.getString(i, "EntryPath");
            condition = preLoadItem.getString(i, "Condition");
            isClose = preLoadItem.getInt(i, "IsClose") == 1;
            target = preLoadItem.getString(i, "Target");
            TagNode preLoadItemNode = new TagNode(MetaPreLoadItem.TAG_NAME, null);
            preLoadItemNode.setAttribute("Key", preLoadItemKey);
            preLoadItemNode.setAttribute("EntryPath", entryPath);
            if (!FormTarget.STR_NEWTAB.equals(target)) {
                preLoadItemNode.setAttribute("Target", target);
            }
            preLoadItemNode.setAttribute("Condition", condition);
            if (!isClose) {
                preLoadItemNode.setAttribute("Close", "false");
            }
            preLoadItemCollectionTag.addNode(preLoadItemNode);
        }
    }

    private void dealLangConfig(Document document, TagNode rootNode) throws Throwable {
        DataTable langConfig = document.get("ED_LangConfig");
        langConfig.setShowDeleted(true);
        if (!isTableChange(langConfig)) {
            return;
        }
        langConfig.setShowDeleted(false);
        rootNode.deleteChildByTagName(MetaLangConfig.TAG_NAME);
        if (langConfig.size() == 0) {
            return;
        }
        TagNode preLoadItemCollectionTag = rootNode.getOrCreateChildByTagName(MetaLangConfig.TAG_NAME, 7);
        String langKey;
        String langDescription;
        BigDecimal widthMultiple;
        String langSuffix;
        for (int i = 0; i < langConfig.size(); i++) {
            langKey = langConfig.getString(i, "LangKey");
            langDescription = langConfig.getString(i, "LangDescription");
            langSuffix = langConfig.getString(i, "LangSuffix");
            widthMultiple = langConfig.getNumeric(i, "WidthMultiple");
            TagNode LangNode = new TagNode(MetaLang.TAG_NAME, null);

            LangNode.setAttribute("Description", langDescription);
            LangNode.setAttribute("Key", langKey);
            LangNode.setAttributeNotRemove("Suffix", langSuffix);
            LangNode.setAttribute("WidthMultiple", widthMultiple.toString());
            preLoadItemCollectionTag.addNode(LangNode);
        }
    }
}
