package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.setting.MetaSettingLoad;
import com.bokesoft.yes.meta.persist.dom.setting.MetaSettingSave;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yes.util.FileUtil;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.TreeMenuBarType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaPara;
import com.bokesoft.yigo.meta.common.MetaParas;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaRightsProxy;
import com.bokesoft.yigo.meta.form.MetaRightsProxyCollection;
import com.bokesoft.yigo.meta.setting.*;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;


public class SettingOperJsonUtil extends HandleSettingImpl {
    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
//        SettingCommonUtils.saveXml(xmlTree, rootNode, diff, jsonObject);
        // 修改Setting直接保存到xml文件中不再生成临时文件
        String xml = genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument(xml);
        MetaSettingLoad settingLoad = new MetaSettingLoad(AppRunType.App);
        settingLoad.load(document);
        MetaSetting metaSetting = (MetaSetting) settingLoad.getRootMetaObject();
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        dealMetaSetting(metaSetting);
        (new MetaSettingSave(metaSetting)).save(designSettingMetaResolver, filePath);
    }

    private void dealMetaSetting(MetaSetting metaSetting) throws Throwable {
        MetaBPMSetting bpmSetting = metaSetting.getBPMSetting();
        if (bpmSetting != null){
            if (bpmSetting.getBPMMTable().size() == 0){
                bpmSetting.setBPMMTable(null);
            }
            nullifyEmptyMetaBaseScriptFields(bpmSetting);
        }
    }

    /**
     * 将配置对象中的CDATA为空的成员变量设置为null，防止写入空节点（可复用，以后可以抽出）
     * @param obj 任意配置对象
     */
    public void nullifyEmptyMetaBaseScriptFields(Object obj) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        // 获取对象的类
        Class<?> clazz = obj.getClass();

        // 获取所有声明的字段（包括私有字段）
        Field[] fields = clazz.getDeclaredFields();

        for (Field field : fields) {
            // 设置字段为可访问
            field.setAccessible(true);

            // 获取字段的值
            Object value = field.get(obj);

            // 检查字段值是否为MetaBaseScript类型
            if (value != null && MetaBaseScript.class.isAssignableFrom(field.getType())) {
                MetaBaseScript metaBaseScript = (MetaBaseScript) value;
                // 调用getContent方法
                Method getContentMethod = metaBaseScript.getClass().getMethod("getContent");
                String content = (String) getContentMethod.invoke(metaBaseScript);

                // 检查内容是否为空字符串
                if (content == null || content.isEmpty()) {
                    // 获取对应的set方法名
                    String setName = "set" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
                    Method setMethod = clazz.getMethod(setName, field.getType());
                    // 调用set方法将字段值设置为null
                    setMethod.invoke(obj, (Object) null);
                }
            }
        }
    }

    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        // 从当前表单的document中获取
        DataTable settingDataTable = document.get("ED_Setting");
        DataTable attachmentServiceDataTable = document.get("ED_AttachmentService");
        DataTable dtsDataTable = document.get("ED_DTS");
        DataTable iOServiceDataTable = document.get("ED_IOService");
        DataTable hbeaParasDataTable = document.get("ED_hbea_paras");
        DataTable rightsProxyDataTable = document.get("ED_RightsProxy");
        DataTable sessionParaDataTable = document.get("ED_SessionPara");
        DataTable tagNameDataTable = document.get("ED_TagName");
        DataTable tagParaDataTable = document.get("ED_TagPara");
        DataTable bpmmDataTable = document.get("ED_BPMMGrid");


        // 处理基本配置
        dealSettingData(rootNode, settingDataTable);
        // 处理业务流程运行设置
        dealBPMSetting(rootNode, settingDataTable);
        // 处理业务流程迁移设置
        dealBPMM(rootNode, bpmmDataTable);
        // 处理附件服务配置
        dealAttachmentOrDts(rootNode, settingDataTable, attachmentServiceDataTable, false);
        // 处理数据传输配置
        dealAttachmentOrDts(rootNode, settingDataTable, dtsDataTable, true);
        // 处理hbae配置
        dealIoService(rootNode, iOServiceDataTable, hbeaParasDataTable);
        // 处理权限代理配置
        dealRightsProxyTable(rootNode, rightsProxyDataTable);
        // 处理会话参数配置
        dealSessionTable(rootNode, sessionParaDataTable);
        // 处理简单属性设置
        dealSimpleSettings(rootNode, tagNameDataTable, tagParaDataTable);
        // 处理SysTopic闭标签问题
        xmlTree.xmlTree.setOrgXml(xmlTree.xmlTree.getOrgXml().replaceAll("></SysTopic>", "/>"));
    }

    /**
     * 处理Setting数据
     */
    private void dealSettingData(TagNode rootNode, DataTable settingDataTable) {
        if (settingDataTable.size() == 0) {
            return;
        }
        int state = settingDataTable.getState(0);
        if (state == RowState.NORMAL) {
            return;
        }

        // 是否是分布式数据库
        boolean isDbCluster = settingDataTable.getLong(0, "IsDbCluster") == 1;
        if (isDbCluster) {
            rootNode.setAttribute("DbCluster", "true");
        } else {
            rootNode.deleteAttribute("DbCluster");
        }
        // 会话超时相关设置
        dealSession(rootNode, settingDataTable);
        // 入口设置
        TagNode entry = rootNode.getOrCreateChildByTagName(MetaEntrySetting.TAG_NAME);
        String entryStyle1 = settingDataTable.getString(0, "EntryStyle");
        String entryStyle = StringUtils.isEmpty(entryStyle1) ? "" : TreeMenuBarType.toString(Integer.parseInt(entryStyle1));
        if (!TreeMenuBarType.STR_GroupTree.equals(entryStyle) && TreeMenuBarType.parse(entryStyle) != -1) {
            entry.setAttribute("Style", entryStyle);
        } else {
            entry.deleteAttribute("Style");
        }
        // 数据簇对象
        dealCluster(rootNode, settingDataTable);
        // 登录界面配置
        dealLogin(rootNode, settingDataTable);
        // 表单设置
        dealForm(rootNode, settingDataTable);
        // 迁移的运行设置
        boolean isUseOptimization = settingDataTable.getInt("IsUseOptimization") == 1;
        TagNode migrationSetting = rootNode.getOrCreateChildByTagName(MetaMigrationSetting.TAG_NAME);
        if (!isUseOptimization) {
            migrationSetting.setAttribute("UseOptimization", "false");
        } else {
            migrationSetting.deleteAttribute("UseOptimization");
        }
    }

    /**
     * 会话超时相关设置
     */
    private void dealSession(TagNode rootNode, DataTable settingDataTable) {
        int timeout = settingDataTable.getNumeric(0, "Timeout").intValue();
        int mobileTimeout = settingDataTable.getNumeric(0, "MobileTimeout").intValue();
        int maxLoginCount = settingDataTable.getNumeric(0, "MaxLoginCount").intValue();
        String authenticateProvider = settingDataTable.getString(0, "AuthenticateProvider");
        String guestAuthenticateProvider = settingDataTable.getString(0, "GuestAuthenticateProvider");
        boolean isEnableLock = settingDataTable.getLong(0, "IsEnableLock") == 1;
        boolean isSessionParaAsCluster = settingDataTable.getLong(0, "IsSessionParaAsCluster") == 1;
        TagNode session = rootNode.getOrCreateChildByTagName(MetaSession.TAG_NAME);
        if (timeout > 0 && timeout != 3600) {
            session.setAttribute("Timeout", String.valueOf(timeout));
        } else {
            session.deleteAttribute("Timeout");
        }
        if (mobileTimeout > 0) {
            session.setAttribute("MobileTimeout", String.valueOf(mobileTimeout));
        } else {
            session.deleteAttribute("MobileTimeout");
        }
        if (maxLoginCount > 0) {
            session.setAttribute("MaxLoginCount", String.valueOf(maxLoginCount));
        } else {
            session.deleteAttribute("MaxLoginCount");
        }
        if (StringUtils.isNotEmpty(authenticateProvider)) {
            session.setAttribute("AuthenticateProvider", authenticateProvider);
        } else {
            session.deleteAttribute("AuthenticateProvider");
        }
        if (StringUtils.isNotEmpty(authenticateProvider)) {
            session.setAttribute("GuestAuthenticateProvider", guestAuthenticateProvider);
        } else {
            session.deleteAttribute("GuestAuthenticateProvider");
        }
        if (isEnableLock) {
            session.setAttribute("EnableLock", "true");
        } else {
            session.deleteAttribute("EnableLock");
        }
        if (isSessionParaAsCluster) {
            session.setAttribute("SessionParaAsCluster", "true");
        } else {
            session.deleteAttribute("SessionParaAsCluster");
        }
        // 以下三个参数为"会话参数"tab页的内容
        String sessionParaKey = settingDataTable.getString(0, "SessionParaKey");
        String sessionParaItemsProvider = settingDataTable.getString(0, "SessionParaItemsProvider");
        String sessionParaProcess = settingDataTable.getString(0, "SessionParaProcess");
        if (StringUtils.isNotEmpty(sessionParaKey)) {
            session.setAttribute("SessionParaKey", sessionParaKey);
        } else {
            session.deleteAttribute("SessionParaKey");
        }
        if (StringUtils.isNotEmpty(sessionParaItemsProvider)) {
            session.setAttribute("SessionParaItemsProvider", sessionParaItemsProvider);
        } else {
            session.deleteAttribute("SessionParaItemsProvider");
        }
        if (StringUtils.isNotEmpty(sessionParaProcess)) {
            session.setAttribute("SessionParaProcess", sessionParaProcess);
        } else {
            session.deleteAttribute("SessionParaProcess");
        }
        if (session.getAttributes().size() == 0) {
            rootNode.deleteChildByTagName(MetaSession.TAG_NAME);
        }
    }

    /**
     * 数据簇对象
     */
    private void dealCluster(TagNode rootNode, DataTable settingDataTable) {
        String clusterType1 = settingDataTable.getString(0, "ClusterType");
        String clusterType = StringUtils.isEmpty(clusterType1) ? "" : ClusterType.toString(Integer.parseInt(clusterType1));
        String clusterImpl = settingDataTable.getString(0, "ClusterImpl");
        String refItemKey = settingDataTable.getString(0, "RefItemKey");
        TagNode cluster = rootNode.getOrCreateChildByTagName(MetaCluster.TAG_NAME);
        if (StringUtils.isNotEmpty(clusterType)) {
            cluster.setAttribute("Type", clusterType);
        } else {
            cluster.deleteAttribute("Type");
        }
        if (StringUtils.isNotEmpty(clusterImpl)) {
            cluster.setAttribute("Impl", clusterImpl);
        } else {
            cluster.deleteAttribute("Impl");
        }
        if (StringUtils.isNotEmpty(refItemKey)) {
            cluster.setAttribute("RefItemKey", refItemKey);
        } else {
            cluster.deleteAttribute("RefItemKey");
        }
        if (cluster.getAttributes().size() == 0) {
            rootNode.deleteChildByTagName(MetaCluster.TAG_NAME);
        }
    }

    /**
     * 登录界面配置
     */
    private void dealLogin(TagNode rootNode, DataTable settingDataTable) {
        boolean isSessionPara = settingDataTable.getInt(0, "IsSessionPara") == 1;
        boolean isMultiLang = settingDataTable.getInt(0, "IsMultiLang") == 1;
        String loginProcess = settingDataTable.getString(0, "LoginProcess");
        String logoutProcess = settingDataTable.getString(0, "LogoutProcess");
        String ssoProvider = settingDataTable.getString(0, "SSOProvider");
        TagNode login = rootNode.getOrCreateChildByTagName(MetaLoginSetting.TAG_NAME);
        if (isSessionPara) {
            login.setAttribute("SessionPara", "true");
        } else {
            login.deleteAttribute("SessionPara");
        }
        if (isMultiLang) {
            login.setAttribute("MultiLang", "true");
        } else {
            login.deleteAttribute("MultiLang");
        }
        if (StringUtils.isNotEmpty(loginProcess)) {
            login.setAttribute("LoginProcess", loginProcess);
        } else {
            login.deleteAttribute("LoginProcess");
        }
        if (StringUtils.isNotEmpty(logoutProcess)) {
            login.setAttribute("LogoutProcess", logoutProcess);
        } else {
            login.deleteAttribute("LogoutProcess");
        }
        if (StringUtils.isNotEmpty(ssoProvider)) {
            login.setAttribute("SSOProvider", ssoProvider);
        } else {
            login.deleteAttribute("SSOProvider");
        }
        if (login.getAttributes().size() == 0) {
            rootNode.deleteChildByTagName(MetaLoginSetting.TAG_NAME);
        }
    }

    /**
     * 表单配置
     */
    private void dealForm(TagNode rootNode, DataTable settingDataTable) {
        boolean initFocus = settingDataTable.getInt("IsInitFocus") == 1;
        String rightsProvider = settingDataTable.getString(0, "RightsProvider");
        String dimValueProvider = settingDataTable.getString(0, "DimValueProvider");
        TagNode form = rootNode.getOrCreateChildByTagName(MetaFormSetting.TAG_NAME);
        if (!initFocus) {
            form.setAttribute("InitFocus", "false");
        } else {
            form.deleteAttribute("InitFocus");
        }
        if (StringUtils.isNotEmpty(rightsProvider)) {
            form.setAttribute("Provider", rightsProvider);
        } else {
            form.deleteAttribute("Provider");
        }
        if (StringUtils.isNotEmpty(dimValueProvider)) {
            form.setAttribute("DimValueProvider", dimValueProvider);
        } else {
            form.deleteAttribute("DimValueProvider");
        }
//        if (form.getAttributes().size() == 0) {
//            rootNode.deleteChildByTagName(MetaFormSetting.TAG_NAME);
//        }
    }

    /**
     * 业务流程运行设置
     */
    private void dealBPMSetting(TagNode rootNode, DataTable settingDataTable) {
        TagNode bmpSetting = rootNode.getOrCreateChildByTagName(MetaBPMSetting.TAG_NAME);

        boolean isQueryRetreatWorkItem = settingDataTable.getInt(0, "IsQueryRetreatWorkItem") == 1;
        boolean isQueryActiveWorkItem = settingDataTable.getInt(0, "IsQueryActiveWorkItem") == 1;
        boolean isQueryActiveStateWorkItem = settingDataTable.getInt(0, "IsQueryActiveStateWorkItem") == 1;
        boolean isRecordFormRights = settingDataTable.getInt(0, "Is" + BPMConstants.RECORD_FORMRIGHTS) == 1;
        boolean isIgnoreFormState = settingDataTable.getInt(0, "Is" + BPMConstants.IGNORE_FORM_STATE) == 1;
        boolean isQueryTransitTo = settingDataTable.getInt(0, "Is" + BPMConstants.QUERY_TRANSIT_TO) == 1;
        boolean isCreateLog4EndNode = settingDataTable.getInt(0, "Is" + BPMConstants.CREATE_LOG_4_END_NODE) == 1;
        boolean isCreateLog4BeginNode = settingDataTable.getInt(0, "Is" + BPMConstants.CREATE_LOG_4_BEGIN_NODE) == 1;
        boolean isRecalculateActiveWorkItem = settingDataTable.getInt(0, "IsRecalculateActiveWorkItem") == 1;
        if (!isQueryRetreatWorkItem) {
            bmpSetting.setAttribute(BPMConstants.QUERY_RETREAT_WORKITEM, "false");
        } else {
            bmpSetting.deleteAttribute(BPMConstants.QUERY_RETREAT_WORKITEM);
        }
        if (isQueryActiveWorkItem) {
            bmpSetting.setAttribute(BPMConstants.QUERY_ACTIVE_WORKITEM, "true");
        } else {
            bmpSetting.deleteAttribute(BPMConstants.QUERY_ACTIVE_WORKITEM);
        }
        if (!isQueryActiveStateWorkItem) {
            bmpSetting.setAttribute(BPMConstants.QUERY_ACTIVE_STATE_WORKITEM, "false");
        } else {
            bmpSetting.deleteAttribute(BPMConstants.QUERY_ACTIVE_STATE_WORKITEM);
        }
        if (isRecordFormRights) {
            bmpSetting.setAttribute(BPMConstants.RECORD_FORMRIGHTS, "true");
        } else {
            bmpSetting.deleteAttribute(BPMConstants.RECORD_FORMRIGHTS);
        }
        if (isIgnoreFormState) {
            bmpSetting.setAttribute(BPMConstants.IGNORE_FORM_STATE, "true");
        } else {
            bmpSetting.deleteAttribute(BPMConstants.IGNORE_FORM_STATE);
        }
        if (isQueryTransitTo) {
            bmpSetting.setAttribute(BPMConstants.QUERY_TRANSIT_TO, "true");
        } else {
            bmpSetting.deleteAttribute(BPMConstants.QUERY_TRANSIT_TO);
        }
        if (isCreateLog4EndNode) {
            bmpSetting.setAttribute(BPMConstants.CREATE_LOG_4_END_NODE, "true");
        } else {
            bmpSetting.deleteAttribute(BPMConstants.CREATE_LOG_4_END_NODE);
        }
        if (isCreateLog4BeginNode) {
            bmpSetting.setAttribute(BPMConstants.CREATE_LOG_4_BEGIN_NODE, "true");
        } else {
            bmpSetting.deleteAttribute(BPMConstants.CREATE_LOG_4_BEGIN_NODE);
        }
        if (isRecalculateActiveWorkItem) {
            bmpSetting.setAttribute(BPMConstants.RECALCULATE_ACTIVE_WORKITEM, "true");
        } else {
            bmpSetting.deleteAttribute(BPMConstants.RECALCULATE_ACTIVE_WORKITEM);
        }

        String defaultBatchStateAction = settingDataTable.getString(0, BPMConstants.DEFAULT_BATCH_STATE_ACTION);
        String defaultStateAction = settingDataTable.getString(0, BPMConstants.DEFAULT_STATE_ACTION);
        String defaultAuditAction = settingDataTable.getString(0, BPMConstants.DEFAULT_AUDIT_ACTION);
        String defaultTaskAction = settingDataTable.getString(0, BPMConstants.DEFAULT_TASK_ACTION);
        String defaultCountersignAction = settingDataTable.getString(0, BPMConstants.DEFAULT_COUNTERSIGN_ACTION);
        if (StringUtils.isNotEmpty(defaultBatchStateAction)) {
            TagNode tagNode = new TagNode(BPMConstants.DEFAULT_BATCH_STATE_ACTION, null);
            tagNode.setCDataValue(defaultBatchStateAction);
            bmpSetting.addNode(tagNode);
        } else {
            bmpSetting.deleteChildByTagName(BPMConstants.DEFAULT_BATCH_STATE_ACTION);
        }
        if (StringUtils.isNotEmpty(defaultStateAction)) {
            TagNode tagNode = new TagNode(BPMConstants.DEFAULT_STATE_ACTION, null);
            tagNode.setCDataValue(defaultStateAction);
            bmpSetting.addNode(tagNode);
        } else {
            bmpSetting.deleteChildByTagName(BPMConstants.DEFAULT_STATE_ACTION);
        }
        if (StringUtils.isNotEmpty(defaultAuditAction)) {
            TagNode tagNode = new TagNode(BPMConstants.DEFAULT_AUDIT_ACTION, null);
            tagNode.setCDataValue(defaultAuditAction);
            bmpSetting.addNode(tagNode);
        } else {
            bmpSetting.deleteChildByTagName(BPMConstants.DEFAULT_AUDIT_ACTION);
        }
        if (StringUtils.isNotEmpty(defaultTaskAction)) {
            TagNode tagNode = new TagNode(BPMConstants.DEFAULT_TASK_ACTION, null);
            tagNode.setCDataValue(defaultTaskAction);
            bmpSetting.addNode(tagNode);
        } else {
            bmpSetting.deleteChildByTagName(BPMConstants.DEFAULT_TASK_ACTION);
        }
        if (StringUtils.isNotEmpty(defaultCountersignAction)) {
            TagNode tagNode = new TagNode(BPMConstants.DEFAULT_COUNTERSIGN_ACTION, null);
            tagNode.setCDataValue(defaultCountersignAction);
            bmpSetting.addNode(tagNode);
        } else {
            bmpSetting.deleteChildByTagName(BPMConstants.DEFAULT_COUNTERSIGN_ACTION);
        }

        String bpmNodeAction = settingDataTable.getString(0, BPMConstants.BPM_NODE_ACTION);
        String workFlowHookPath = settingDataTable.getString(0, BPMConstants.BPM_WORKFLOWHOOK_PATH);
        String bpmGraphInfoPath = settingDataTable.getString(0, BPMConstants.BPM_GRAPHINFO_PATH);
        String bpmRightsProvider = settingDataTable.getString(0, "BPM" + BPMConstants.RIGHTS_PROVIDER);
        String retreatCaption = settingDataTable.getString(0, BPMConstants.RETREAT_CAPTION);
        String templateKey = settingDataTable.getString(0, BPMConstants.NODE_TEMPLATEKEY);
        String delegateCheck = settingDataTable.getString(0, BPMConstants.BPM_DELEGATE_CHECK);
        if (StringUtils.isNotEmpty(bpmNodeAction)) {
            bmpSetting.setAttribute(BPMConstants.BPM_NODE_ACTION, bpmNodeAction);
        } else {
            bmpSetting.deleteAttribute(BPMConstants.BPM_NODE_ACTION);
        }
        if (StringUtils.isNotEmpty(workFlowHookPath)) {
            bmpSetting.setAttribute(BPMConstants.BPM_WORKFLOWHOOK_PATH, workFlowHookPath);
        } else {
            bmpSetting.deleteAttribute(BPMConstants.BPM_WORKFLOWHOOK_PATH);
        }
        if (StringUtils.isNotEmpty(bpmGraphInfoPath)) {
            bmpSetting.setAttribute(BPMConstants.BPM_GRAPHINFO_PATH, bpmGraphInfoPath);
        } else {
            bmpSetting.deleteAttribute(BPMConstants.BPM_GRAPHINFO_PATH);
        }
        if (StringUtils.isNotEmpty(bpmRightsProvider)) {
            bmpSetting.setAttribute(BPMConstants.RIGHTS_PROVIDER, bpmRightsProvider);
        } else {
            bmpSetting.deleteAttribute(BPMConstants.RIGHTS_PROVIDER);
        }
        if (StringUtils.isNotEmpty(retreatCaption)) {
            bmpSetting.setAttribute(BPMConstants.RETREAT_CAPTION, retreatCaption);
        } else {
            bmpSetting.deleteAttribute(BPMConstants.RETREAT_CAPTION);
        }
        if (StringUtils.isNotEmpty(templateKey)) {
            bmpSetting.setAttribute(BPMConstants.NODE_TEMPLATEKEY, templateKey);
        } else {
            bmpSetting.deleteAttribute(BPMConstants.NODE_TEMPLATEKEY);
        }
        if (StringUtils.isNotEmpty(delegateCheck)) {
            bmpSetting.setAttribute(BPMConstants.BPM_DELEGATE_CHECK, delegateCheck);
        } else {
            bmpSetting.deleteAttribute(BPMConstants.BPM_DELEGATE_CHECK);
        }
    }

    /**
     * 业务流程迁移设置
     */
    private void dealBPMM(TagNode rootNode, DataTable bpmmDataTable) {
        if (!isTableChange(bpmmDataTable)) {
            // 没有任何修改
            return;
        }
        TagNode bmpSettingNode = rootNode.getOrCreateChildByTagName(MetaBPMSetting.TAG_NAME);
        TagNode tableNode = bmpSettingNode.getOrCreateChildByTagName(MetaBPMMTable.TAG_NAME);
        tableNode.deleteChildByTagName(MetaBPMMColumn.TAG_NAME);
        String key = "";
        String caption = "";
        String defaultValue = "";
        String dataType = "";
        String dbColumnName = "";
        Integer length = 0;
        Integer precision = 0;
        Integer scale = 0;
        for (int i = 0; i < bpmmDataTable.size(); i++) {
            TagNode tagNode = new TagNode(MetaBPMMColumn.TAG_NAME, null);
            key = bpmmDataTable.getString(i, "ColumnKey");
            caption = bpmmDataTable.getString(i, "ColumnCaption");
            dataType = bpmmDataTable.getString(i, "DataType");
            dbColumnName = bpmmDataTable.getString(i, "DbColumnName");
            defaultValue = bpmmDataTable.getString(i, "DefaultValue");
            length = bpmmDataTable.getInt(i, "Length");
            precision = bpmmDataTable.getInt(i, "ColumnPrecision");
            scale = bpmmDataTable.getInt(i, "ColumnScale");
            tagNode.setAttribute("Key", key);
            tagNode.setAttribute("Caption", caption);
            tagNode.setAttribute("DataType", dataType);
            tagNode.setAttribute("DbColumnName", dbColumnName);
            if (StringUtils.isNotEmpty(defaultValue)){
                tagNode.setAttribute("DefaultValue", defaultValue);
            }
            if ("Varchar".equalsIgnoreCase(dataType) && length != null && length != 0 && length != 255){
                tagNode.setAttribute("Length", length.toString());
            }
            if ("Numeric".equalsIgnoreCase(dataType) && precision != null && precision != 0 && precision != 16){
                tagNode.setAttribute("Precision", precision.toString());
            }
            if ("Numeric".equalsIgnoreCase(dataType) && scale != null && scale != 0 && scale != 2){
                tagNode.setAttribute("Scale", scale.toString());
            }
            tableNode.addNode(tagNode);
        }

    }

    /**
     * 附件服务配置OR数据传输配置
     */
    private void dealAttachmentOrDts(TagNode rootNode, DataTable settingDataTable, DataTable dataTable, boolean isDts)
            throws Throwable {
        int settingState = settingDataTable.getState(0);
        String mainTagName = isDts ? MetaDTS.TAG_NAME : MetaAttachmentService.TAG_NAME;
        int index = isDts ? 1 : 0;
        TagNode mainNode = rootNode.getChildByTagName(mainTagName);
        if (Objects.isNull(mainNode)) {
            mainNode = new TagNode(mainTagName, null);
            rootNode.addNode(mainNode, index);
        }
        if (settingDataTable.size() > 0 && settingState != RowState.NORMAL) {
            String columnKey = isDts ? "DTSDefaultProvider" : "AttachmentDefaultProvider";
            String defaultProvider = settingDataTable.getString(0, columnKey);
            if (StringUtils.isNotEmpty(defaultProvider)) {
                mainNode.setAttribute("DefaultProvider", defaultProvider);
            } else {
                mainNode.deleteAttribute("DefaultProvider");
            }
        }
        // 处理表格数据
        dataTable.setShowDeleted(true);
        if (dataTable.size() == 0) {
            if (mainNode.getAttributes().size() == 0) {
                // 若没有任何数据则删除这个节点
                rootNode.deleteChildByTagName(mainTagName);
            }
            return;
        }
        if (!isTableChange(dataTable)) {
            // 没有任何修改
            return;
        }
        dataTable.setShowDeleted(false);
        String tagName = isDts ? MetaDTSProvider.TAG_NAME : MetaAttachmentProvider.TAG_NAME;
        // 先把原有的全部删掉,再把页面上的数据set进去
        mainNode.deleteChildByTagName(tagName);
        String columnKey = isDts ? "DTSKey" : "AttachmentProviderKey";
        String columnDriver = isDts ? "DTSDriver" : "AttProviderDriver";
        String columnExternalConfig = isDts ? "DTSExternalConfig" : "AttExternalConfig";
        for (int i = 0; i < dataTable.size(); i++) {
            String providerKey = Optional.ofNullable(dataTable.getString(i, columnKey)).orElse("");
            String driver = Optional.ofNullable(dataTable.getString(i, columnDriver)).orElse("");
            String externalConfig = Optional.ofNullable(dataTable.getString(i, columnExternalConfig)).orElse("");
            TagNode provider = new TagNode(tagName, null);
            provider.setAttribute("Key", providerKey);
            provider.setAttribute("Driver", driver);
            provider.setAttribute("ExternalConfig", externalConfig);
            mainNode.addNode(provider);
        }
        if (mainNode.getAttributes().size() == 0 && mainNode.getChildrenByTagName(tagName).size() == 0) {
            // 若没有任何数据则删除这个节点
            rootNode.deleteChildByTagName(mainTagName);
        }
    }


    /**
     * 会话参数表
     */
    private void dealSessionTable(TagNode rootNode, DataTable sessionParaDataTable) throws Throwable {
        sessionParaDataTable.setShowDeleted(true);
        if (sessionParaDataTable.size() == 0 || !isTableChange(sessionParaDataTable)) {
            return;
        }
        sessionParaDataTable.setShowDeleted(false);
        TagNode session = rootNode.getOrCreateChildByTagName(MetaSession.TAG_NAME);
        // 先把原有的全部删掉,再把页面上的数据set进去
        session.deleteChildByTagName(MetaSessionPara.TAG_NAME);
        for (int i = 0; i < sessionParaDataTable.size(); i++) {
            String sessionParaKey = Optional.ofNullable(sessionParaDataTable.getString(i, "SessionParaKey")).orElse("");
            String sessionParaItemsProvider = Optional.ofNullable(sessionParaDataTable.getString(i, "SessionParaItemsProvider")).orElse("");
            boolean isAsCluster = Optional.ofNullable(sessionParaDataTable.getInt(i, "IsAsCluster")).orElse(0) == 1;
            TagNode sessionPara = new TagNode(MetaSessionPara.TAG_NAME, null);
            sessionPara.setAttribute("ParaKey", sessionParaKey);
            sessionPara.setAttribute("Provider", sessionParaItemsProvider);
            if (isAsCluster) {
                sessionPara.setAttribute("AsCluster", "true");
            }
            session.addNode(sessionPara);
        }
    }

    /**
     * 处理权限代理配置
     */
    private void dealRightsProxyTable(TagNode rootNode, DataTable rightsProxyDataTable) throws Throwable {
        rightsProxyDataTable.setShowDeleted(true);
        if (rightsProxyDataTable.size() == 0 || !isTableChange(rightsProxyDataTable)) {
            return;
        }
        rightsProxyDataTable.setShowDeleted(false);
        TagNode rightsProxyCollection = rootNode.getOrCreateChildByTagName(MetaRightsProxyCollection.TAG_NAME);
        // 先把原有的全部删掉,再把页面上的数据set进去
        rightsProxyCollection.deleteChildByTagName(MetaRightsProxy.TAG_NAME);
        for (int i = 0; i < rightsProxyDataTable.size(); i++) {
            String rightsProxyKey = Optional.ofNullable(rightsProxyDataTable.getString(i, "RightsProxyKey")).orElse("");
            String rightsProxyDriver = Optional.ofNullable(rightsProxyDataTable.getString(i, "RightsProxyDriver")).orElse("");
            TagNode rightsProxy = new TagNode(MetaRightsProxy.TAG_NAME, null);
            rightsProxy.setAttribute("Key", rightsProxyKey);
            rightsProxy.setAttribute("Driver", rightsProxyDriver);
            rightsProxyCollection.addNode(rightsProxy);
        }
    }

    /**
     * 处理hbea配置
     */
    private void dealIoService(TagNode rootNode, DataTable iOServiceDataTable, DataTable hbeaParasDataTable)
            throws Throwable {
        iOServiceDataTable.setShowDeleted(true);
        hbeaParasDataTable.setShowDeleted(true);
        if (iOServiceDataTable.size() == 0 || (!isTableChange(iOServiceDataTable) && !isTableChange(hbeaParasDataTable))) {
            return;
        }
        iOServiceDataTable.setShowDeleted(false);
        hbeaParasDataTable.setShowDeleted(false);
        TagNode ioService = rootNode.getOrCreateChildByTagName(MetaIOService.TAG_NAME);
        ioService.deleteChildByTagName(MetaIOProvider.TAG_NAME);
        for (int i = 0; i < iOServiceDataTable.size(); i++) {
            String ioServiceKey = Optional.ofNullable(iOServiceDataTable.getString(i, "IOServiceKey")).orElse("");
            String ioServiceDriver = Optional.ofNullable(iOServiceDataTable.getString(i, "IOServiceDriver")).orElse("");
            TagNode ioProvider = new TagNode(MetaIOProvider.TAG_NAME, null);
            ioProvider.setAttribute("Driver", ioServiceDriver);
            ioProvider.setAttribute("Key", ioServiceKey);
            ioService.addNode(ioProvider);
            long pid = iOServiceDataTable.getLong(i, ConstantUtil.OID);
            TagNode paras = new TagNode(MetaParas.TAG_NAME, null);
            ioProvider.addNode(paras);
            for (int j = 0; j < hbeaParasDataTable.size(); j++) {
                long oid = hbeaParasDataTable.getLong(j, ConstantUtil.POID);
                if (oid != pid) {
                    continue;
                }
                String paraKey = Optional.ofNullable(hbeaParasDataTable.getString(j, "ParaKey")).orElse("");
                String paraValue = Optional.ofNullable(hbeaParasDataTable.getString(j, "ParaValue")).orElse("");
                TagNode para = new TagNode(MetaPara.TAG_NAME, null);
                para.setAttribute("Value", paraValue);
                para.setAttribute("Key", paraKey);
                paras.addNode(para);
            }
            if (paras.getChildrenByTagName(MetaPara.TAG_NAME).size() == 0) {
                ioProvider.deleteChildByTagName(MetaParas.TAG_NAME);
            }
        }
    }

    /**
     * 简单属性设置
     */
    private void dealSimpleSettings(TagNode rootNode, DataTable tagNameDataTable, DataTable tagParaDataTable)
            throws Throwable {
        tagNameDataTable.setShowDeleted(true);
        tagParaDataTable.setShowDeleted(true);
        if (tagNameDataTable.size() == 0 || (!isTableChange(tagNameDataTable) && !isTableChange(tagParaDataTable))) {
            // 没有数据或没任何修改则返回
            return;
        }
        // 属性数据会清空重新设置，所以不需要将删除的数据显示
        tagParaDataTable.setShowDeleted(false);
        for (int i = 0; i < tagNameDataTable.size(); i++) {
            String tagName = tagNameDataTable.getString(i, "TagName");
            if (tagNameDataTable.getState(i) == RowState.DELETED) {
                // 需要删除的节点
                rootNode.deleteChildByTagName(tagName);
                continue;
            }
            TagNode tag = rootNode.getOrCreateChildByTagName(tagName);
            // 先将节点属性清空
            tag.setAttributes(new HashMap<>());
            long pid = tagNameDataTable.getLong(i, ConstantUtil.OID);
            for (int j = 0; j < tagParaDataTable.size(); j++) {
                long oid = tagParaDataTable.getLong(j, ConstantUtil.POID);
                if (oid != pid) {
                    continue;
                }
                String tagParaKey = Optional.ofNullable(tagParaDataTable.getString(j, "TagParaKey")).orElse("");
                String tagParaValue = Optional.ofNullable(tagParaDataTable.getString(j, "TagParaValue")).orElse("");
                tag.setAttribute(tagParaKey, tagParaValue);
            }
            if (tag.getAttributes().size() == 0) {
                rootNode.deleteChildByTagName(tagName);
            }
        }
    }

    public void reload(String solutionPath) throws Exception {
        // 重新加载setting
        solutionPath = StringUtils.substringBeforeLast(solutionPath, File.separator);
        if (solutionPath.endsWith("erp-solution-core")) {
            IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
            IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
            MetaSettingLoad settingLoad = new MetaSettingLoad(AppRunType.App);
            settingLoad.load(iMetaResolver, DomMetaConstants.SETTING_FILE);
            MetaSetting metaSetting = (MetaSetting) settingLoad.getRootMetaObject();
            MetaFactory.getGlobalInstance().setSetting(metaSetting);
        }
    }
}


